/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.notifications.ui.popup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mylyn.commons.notifications.core.AbstractNotification;
import org.eclipse.mylyn.commons.notifications.core.NotificationSink;
import org.eclipse.mylyn.commons.notifications.core.NotificationSinkEvent;
import org.eclipse.mylyn.internal.commons.notifications.ui.popup.Messages;
import org.eclipse.mylyn.internal.commons.notifications.ui.popup.NotificationPopup;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PopupNotificationSink
extends NotificationSink {
    private static final long DELAY_OPEN = 1000L;
    private static final boolean runSystem = true;
    private final WeakHashMap<Object, Object> cancelledTokens = new WeakHashMap();
    private final Set<AbstractNotification> notifications = new HashSet<AbstractNotification>();
    private final Set<AbstractNotification> currentlyNotifying = Collections.synchronizedSet(this.notifications);
    private final Job openJob = new Job(Messages.PopupNotificationSink_Popup_Noifier_Job_Label){

        protected IStatus run(IProgressMonitor monitor) {
            try {
                if (Platform.isRunning() && PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getDisplay() != null && !PlatformUI.getWorkbench().getDisplay().isDisposed()) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            PopupNotificationSink.this.collectNotifications();
                            if (PopupNotificationSink.this.popup != null && PopupNotificationSink.this.popup.getReturnCode() == 1) {
                                List<AbstractNotification> notifications = PopupNotificationSink.this.popup.getNotifications();
                                for (AbstractNotification notification : notifications) {
                                    if (notification.getToken() == null) continue;
                                    PopupNotificationSink.this.cancelledTokens.put(notification.getToken(), null);
                                }
                            }
                            Iterator it = PopupNotificationSink.this.currentlyNotifying.iterator();
                            while (it.hasNext()) {
                                AbstractNotification notification;
                                notification = (AbstractNotification)it.next();
                                if (notification.getToken() == null || !PopupNotificationSink.this.cancelledTokens.containsKey(notification.getToken())) continue;
                                it.remove();
                            }
                            Class<PopupNotificationSink> clazz = PopupNotificationSink.class;
                            synchronized (PopupNotificationSink.class) {
                                if (PopupNotificationSink.this.currentlyNotifying.size() > 0) {
                                    PopupNotificationSink.this.showPopup();
                                }
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                return;
                            }
                        }
                    });
                }
            }
            finally {
                if (PopupNotificationSink.this.popup != null) {
                    this.schedule(PopupNotificationSink.this.popup.getDelayClose() / 2L);
                }
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    };
    private NotificationPopup popup;

    private void cleanNotified() {
        this.currentlyNotifying.clear();
    }

    public void collectNotifications() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AbstractNotification> getNotifications() {
        Class<PopupNotificationSink> clazz = PopupNotificationSink.class;
        synchronized (PopupNotificationSink.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.currentlyNotifying;
        }
    }

    public boolean isAnimationsEnabled() {
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        return store.getBoolean("ENABLE_ANIMATIONS");
    }

    public void notify(NotificationSinkEvent event) {
        this.currentlyNotifying.addAll(event.getNotifications());
        if (!this.openJob.cancel()) {
            try {
                this.openJob.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.openJob.setSystem(true);
        this.openJob.schedule(1000L);
    }

    public void showPopup() {
        if (this.popup != null) {
            this.popup.close();
        }
        Shell shell = new Shell(PlatformUI.getWorkbench().getDisplay());
        this.popup = new NotificationPopup(shell);
        this.popup.setFadingEnabled(this.isAnimationsEnabled());
        ArrayList<AbstractNotification> toDisplay = new ArrayList<AbstractNotification>(this.currentlyNotifying);
        Collections.sort(toDisplay);
        this.popup.setContents(toDisplay);
        this.cleanNotified();
        this.popup.setBlockOnOpen(false);
        this.popup.open();
    }
}

