/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui;

import java.io.IOException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.builds.ui.BuildsUiStartup;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.builds.ui.BuildNotifier;
import org.eclipse.mylyn.internal.builds.ui.BuildRefresher;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BuildsUiPlugin
extends AbstractUIPlugin {
    public static final String ID_PLUGIN = "org.eclipse.mylyn.builds.ui";
    private static BuildsUiPlugin instance;
    private BuildRefresher refresher;
    private BuildNotifier notifier;
    private boolean startupExtensionsInitialized;

    public static BuildsUiPlugin getDefault() {
        return instance;
    }

    public void start(BundleContext context) throws Exception {
        instance = this;
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.refresher != null) {
            this.refresher.stop();
            this.refresher = null;
        }
        try {
            BuildsUiInternal.save();
        }
        catch (IOException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, ID_PLUGIN, "Unexpected error while saving builds", (Throwable)e));
        }
        super.stop(context);
        instance = null;
    }

    protected IPath getBuildsFile() {
        IPath stateLocation = Platform.getStateLocation((Bundle)this.getBundle());
        IPath cacheFile = stateLocation.append("builds.xmi");
        return cacheFile;
    }

    public void initializeRefresh() {
        if (this.notifier == null) {
            this.notifier = new BuildNotifier();
            this.notifier.register(BuildsUiInternal.getModel());
        }
        if (this.refresher == null) {
            this.refresher = new BuildRefresher(this.getPreferenceStore(), BuildsUiInternal.getModel().getScheduler());
            this.refresher.start();
        }
        if (!this.startupExtensionsInitialized) {
            UiStartupExtensionPointReader.runStartupExtensions();
            this.startupExtensionsInitialized = true;
        }
    }

    public void refreshBuilds() {
        this.initializeRefresh();
        this.refresher.refresh();
        BuildsUiInternal.getModel().getLoader().getRealm().asyncExec(new Runnable(){

            public void run() {
                try {
                    BuildsUiInternal.save();
                }
                catch (IOException e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, BuildsUiPlugin.ID_PLUGIN, "Unexpected error while saving builds", (Throwable)e));
                }
            }
        });
    }

    static class UiStartupExtensionPointReader {
        private static final String EXTENSION_ID_STARTUP = "org.eclipse.mylyn.builds.ui.startup";
        private static final String ELEMENT_STARTUP = "startup";
        private static final String ELEMENT_CLASS = "class";

        UiStartupExtensionPointReader() {
        }

        public static void runStartupExtensions() {
            IExtension[] extensions;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_ID_STARTUP);
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().compareTo(ELEMENT_STARTUP) == 0) {
                        UiStartupExtensionPointReader.runStartupExtension(element);
                    }
                    ++n4;
                }
                ++n2;
            }
        }

        private static void runStartupExtension(IConfigurationElement configurationElement) {
            try {
                Object object = configurationElement.createExecutableExtension(ELEMENT_CLASS);
                if (!(object instanceof BuildsUiStartup)) {
                    StatusHandler.log((IStatus)new Status(4, BuildsUiPlugin.ID_PLUGIN, NLS.bind((String)"Startup extension failed: {0} does notimplement {1}", (Object)object.getClass().getCanonicalName(), (Object)BuildsUiStartup.class.getCanonicalName())));
                    return;
                }
                final BuildsUiStartup startup = (BuildsUiStartup)object;
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        startup.lazyStartup();
                    }

                    public void handleException(Throwable exception) {
                    }
                });
            }
            catch (Throwable e) {
                StatusHandler.log((IStatus)new Status(4, BuildsUiPlugin.ID_PLUGIN, "Startup extension failed", e));
            }
        }
    }
}

