/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.provisional.commons.ui.editor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.commons.ui.CommonsUiPlugin;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.provisional.commons.ui.editor.IBusyEditor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

@Deprecated
public class EditorBusyIndicator {
    private static final int UPDATE_INTERVAL = 90;
    private Animator animator;
    private final IBusyEditor editor;
    private Image[] images;
    private Image oldImage;

    public EditorBusyIndicator(IBusyEditor editor) {
        this.editor = editor;
    }

    public void start() {
        if (this.animator != null) {
            this.stop();
        }
        try {
            if (this.images == null) {
                this.images = CommonImages.getProgressImages();
                if (this.images == null) {
                    return;
                }
            }
            this.oldImage = this.editor.getTitleImage();
            if (this.images.length > 1) {
                this.animator = new Animator(this.images);
                this.animator.run();
            }
        }
        catch (SWTException e) {
            CommonsUiPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.mylyn.commons.ui", "Failed to start animation", (Throwable)e));
        }
    }

    public void stop() {
        if (this.animator != null) {
            this.animator.stop();
            this.animator = null;
            this.updateTitleImage(this.oldImage);
            this.oldImage = null;
        }
    }

    private boolean updateTitleImage(Image image) {
        if (!PlatformUI.getWorkbench().isClosing()) {
            if (image != null && !image.isDisposed()) {
                this.editor.setTitleImage(image);
                return true;
            }
            if (this.oldImage != null && !this.oldImage.isDisposed()) {
                this.editor.setTitleImage(this.oldImage);
            }
        }
        return false;
    }

    private class Animator
    implements Runnable {
        int imageDataIndex = 0;
        private final Image[] images;
        private boolean stopped;

        public Animator(Image[] images) {
            this.images = images;
        }

        public void run() {
            if (this.stopped) {
                return;
            }
            try {
                Image image = this.images[this.imageDataIndex];
                this.imageDataIndex = (this.imageDataIndex + 1) % this.images.length;
                if (EditorBusyIndicator.this.updateTitleImage(image)) {
                    PlatformUI.getWorkbench().getDisplay().timerExec(90, (Runnable)this);
                }
            }
            catch (Exception e) {
                CommonsUiPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.mylyn.commons.ui", "Failed to update animation", (Throwable)e));
            }
        }

        public void stop() {
            this.stopped = true;
        }
    }
}

