/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.ui.notifications;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.internal.commons.ui.notifications.NotificationCategory;
import org.eclipse.mylyn.internal.commons.ui.notifications.NotificationElement;

public class NotificationEvent
extends NotificationElement {
    private static final String EXTENSION_POINT_ID = "org.eclipse.mylyn.commons.notifications.notifications";
    private NotificationCategory category;
    private boolean selected;
    private final ArrayList<String> defaultSinks = new ArrayList();

    public boolean defaultHandledBySink(String sinkId) {
        return this.defaultSinks.isEmpty() || this.defaultSinks.contains(sinkId);
    }

    public NotificationEvent(IConfigurationElement element) {
        super(element);
        IConfigurationElement[] children;
        IConfigurationElement[] iConfigurationElementArray = children = element.getChildren("defaultHandler");
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            this.defaultSinks.add(child.getAttribute("sinkId"));
            ++n2;
        }
        this.doEventMappings();
    }

    private void doEventMappings() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = point.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement mapping = iConfigurationElementArray[n2];
                if (mapping.getName().equals("eventMapping")) {
                    String[] list;
                    String eventIds = mapping.getAttribute("eventIds");
                    String[] stringArray = list = eventIds.split(",");
                    int n3 = list.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String item = stringArray[n4];
                        if (this.wildCardMatch(this.getId(), item)) {
                            this.defaultSinks.add(mapping.getAttribute("sinkId"));
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    private boolean wildCardMatch(String text, String pattern) {
        String[] cards;
        String[] stringArray = cards = pattern.split("\\*");
        int n = cards.length;
        int n2 = 0;
        while (n2 < n) {
            String card = stringArray[n2];
            int idx = text.indexOf(card);
            if (idx == -1) {
                return false;
            }
            text = text.substring(idx + card.length());
            ++n2;
        }
        return true;
    }

    public NotificationCategory getCategory() {
        return this.category;
    }

    public String getCategoryId() {
        return this.element.getAttribute("categoryId");
    }

    public String getDescription() {
        IConfigurationElement[] children = this.element.getChildren("description");
        if (children.length > 0) {
            return children[0].getValue();
        }
        return "";
    }

    public void setCategory(NotificationCategory category) {
        this.category = category;
    }

    @Deprecated
    public boolean isSelected() {
        return this.selected;
    }

    @Deprecated
    public void setSelected(boolean selected) {
        this.selected = selected;
    }
}

