/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.egit;

import com.google.gerrit.reviewdb.Project;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.gerrit.core.GerritCorePlugin;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritConfiguration;
import org.eclipse.mylyn.internal.tasks.ui.TaskRepositoryComparator;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class GerritRepositorySearchPageContentProvider
implements ITreeContentProvider {
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TaskRepository) {
            return !this.getProjects((TaskRepository)element).isEmpty();
        }
        return false;
    }

    public Object getParent(Object element) {
        return null;
    }

    public Object[] getElements(Object inputElement) {
        return GerritRepositorySearchPageContentProvider.getGerritTaskRepositories();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TaskRepository) {
            return this.getProjects((TaskRepository)parentElement).toArray();
        }
        return null;
    }

    private static TaskRepository[] getGerritTaskRepositories() {
        Set repositories = TasksUiPlugin.getRepositoryManager().getRepositories("org.eclipse.mylyn.gerrit");
        Iterator it = repositories.iterator();
        while (it.hasNext()) {
            TaskRepository repository = (TaskRepository)it.next();
            if (!repository.isOffline()) continue;
            it.remove();
        }
        TaskRepository[] result = repositories.toArray(new TaskRepository[0]);
        Arrays.sort(result, new TaskRepositoryComparator());
        return result;
    }

    private List<Project> getProjects(TaskRepository repository) {
        GerritConfiguration config = GerritCorePlugin.getGerritClient((TaskRepository)repository).getConfiguration();
        if (config != null) {
            return config.getProjects();
        }
        return Collections.emptyList();
    }
}

