/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.ui;

import java.util.regex.Matcher;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.trac.ui.TracHyperlinkUtil;

public class TracHyperlinkUtilStandaloneTest
extends TestCase {
    public void testWikiPattern2SinglePositiveMatch() {
        Matcher matcher = TracHyperlinkUtil.wikiPattern2.matcher("a HyperLink there");
        TracHyperlinkUtilStandaloneTest.assertTrue((boolean)matcher.find());
        TracHyperlinkUtilStandaloneTest.assertEquals((String)matcher.group(0), (String)"HyperLink");
        TracHyperlinkUtilStandaloneTest.assertFalse((boolean)matcher.find());
    }

    public void testWikiPattern2MultiplePositiveMatch() {
        Matcher matcher = TracHyperlinkUtil.wikiPattern2.matcher("a HyperLink there and ThereIsAnother");
        TracHyperlinkUtilStandaloneTest.assertTrue((boolean)matcher.find());
        TracHyperlinkUtilStandaloneTest.assertEquals((String)matcher.group(0), (String)"HyperLink");
        TracHyperlinkUtilStandaloneTest.assertTrue((boolean)matcher.find());
        TracHyperlinkUtilStandaloneTest.assertEquals((String)matcher.group(0), (String)"ThereIsAnother");
        TracHyperlinkUtilStandaloneTest.assertFalse((boolean)matcher.find());
    }

    public void testWikiPattern2SingleNegativeMatch() {
        Matcher matcher = TracHyperlinkUtil.wikiPattern2.matcher("no !HyperLink there");
        TracHyperlinkUtilStandaloneTest.assertFalse((boolean)matcher.find());
    }

    public void testWikiPattern2SinglePositiveMatchAtStartOfLine() {
        Matcher matcher = TracHyperlinkUtil.wikiPattern2.matcher("HyperLink there");
        TracHyperlinkUtilStandaloneTest.assertTrue((boolean)matcher.find());
        TracHyperlinkUtilStandaloneTest.assertEquals((String)matcher.group(0), (String)"HyperLink");
        TracHyperlinkUtilStandaloneTest.assertFalse((boolean)matcher.find());
    }

    public void testWikiPattern2SingleNegativeMatchAtStartOfLine() {
        Matcher matcher = TracHyperlinkUtil.wikiPattern2.matcher("!HyperLink there");
        TracHyperlinkUtilStandaloneTest.assertFalse((boolean)matcher.find());
    }

    public void testWikiPattern2MixedPositiveNegativeMatch() {
        Matcher matcher = TracHyperlinkUtil.wikiPattern2.matcher("a HyperLink there and ThereIsAnother but !NotHere");
        TracHyperlinkUtilStandaloneTest.assertTrue((boolean)matcher.find());
        TracHyperlinkUtilStandaloneTest.assertEquals((String)matcher.group(0), (String)"HyperLink");
        TracHyperlinkUtilStandaloneTest.assertTrue((boolean)matcher.find());
        TracHyperlinkUtilStandaloneTest.assertEquals((String)matcher.group(0), (String)"ThereIsAnother");
        TracHyperlinkUtilStandaloneTest.assertFalse((boolean)matcher.find());
    }
}

