/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.core;

import java.io.File;
import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.trac.core.TracClientManager;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.model.TracMilestone;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;
import org.eclipse.mylyn.trac.tests.support.TracTestConstants;

public class TracClientManagerTest
extends TestCase {
    public void testNullCache() throws Exception {
        TaskRepository taskRepository = new TaskRepository("trac", TracTestConstants.TEST_TRAC_010_URL);
        taskRepository.setVersion(ITracClient.Version.TRAC_0_9.name());
        TracClientManager manager = new TracClientManager(null, new TaskRepositoryLocationFactory());
        ITracClient client = manager.getTracClient(taskRepository);
        TracClientManagerTest.assertNull((Object)client.getMilestones());
        manager.writeCache();
        TracClientManagerTest.assertNull((Object)client.getMilestones());
    }

    public void testReadCache() throws Exception {
        TaskRepository taskRepository = new TaskRepository("trac", TracTestConstants.TEST_TRAC_010_URL);
        taskRepository.setVersion(ITracClient.Version.TRAC_0_9.name());
        File file = File.createTempFile("mylyn", null);
        file.deleteOnExit();
        TracClientManager manager = new TracClientManager(file, new TaskRepositoryLocationFactory());
        ITracClient client = manager.getTracClient(taskRepository);
        TracClientManagerTest.assertNull((Object)client.getMilestones());
    }

    public void testWriteCache() throws Exception {
        TaskRepository taskRepository = new TaskRepository("trac", TracTestConstants.TEST_TRAC_010_URL);
        taskRepository.setVersion(ITracClient.Version.TRAC_0_9.name());
        taskRepository.setCredentials(AuthenticationType.REPOSITORY, null, false);
        File file = File.createTempFile("mylyn", null);
        file.deleteOnExit();
        TracClientManager manager = new TracClientManager(file, new TaskRepositoryLocationFactory());
        ITracClient client = manager.getTracClient(taskRepository);
        TracClientManagerTest.assertNull((Object)client.getMilestones());
        client.updateAttributes((IProgressMonitor)new NullProgressMonitor(), false);
        TracClientManagerTest.assertTrue((client.getMilestones().length > 0 ? 1 : 0) != 0);
        TracMilestone[] milestones = client.getMilestones();
        manager.writeCache();
        manager = new TracClientManager(file, new TaskRepositoryLocationFactory());
        TracClientManagerTest.assertEquals(Arrays.asList(milestones), Arrays.asList(client.getMilestones()));
    }
}

