/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.core;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.trac.core.model.TracSearch;
import org.eclipse.mylyn.internal.trac.core.model.TracSearchFilter;
import org.eclipse.mylyn.internal.trac.core.util.TracUtil;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.trac.tests.support.TracTestConstants;

public class TracUtilTest
extends TestCase {
    private TaskRepository taskRepository;

    protected void setUp() throws Exception {
        this.taskRepository = new TaskRepository("trac", TracTestConstants.TEST_TRAC_010_URL);
    }

    public void testToTracSearch() {
        String queryParameter = "&order=priority&status=new&status=assigned&status=reopened&milestone=M1&owner=%7E%C3%A4%C3%B6%C3%BC";
        IRepositoryQuery query = TasksUi.getRepositoryModel().createRepositoryQuery(this.taskRepository);
        query.setUrl(String.valueOf(this.taskRepository.getRepositoryUrl()) + "/query?format=tab" + queryParameter);
        TracSearch search = TracUtil.toTracSearch((IRepositoryQuery)query);
        TracUtilTest.assertNotNull((Object)search);
        TracUtilTest.assertEquals((String)queryParameter, (String)search.toUrl());
    }

    public void testToTracSearchFilterList() {
        String parameterUrl = "&status=new&status=assigned&status=reopened&milestone=0.1";
        String queryUrl = String.valueOf(this.taskRepository.getRepositoryUrl()) + "/query?format=tab" + parameterUrl;
        IRepositoryQuery query = TasksUi.getRepositoryModel().createRepositoryQuery(this.taskRepository);
        query.setUrl(queryUrl);
        TracSearch filterList = TracUtil.toTracSearch((IRepositoryQuery)query);
        TracUtilTest.assertEquals((String)parameterUrl, (String)filterList.toUrl());
        TracUtilTest.assertEquals((String)"&status=new|assigned|reopened&milestone=0.1", (String)filterList.toQuery());
        List list = filterList.getFilters();
        TracSearchFilter filter = (TracSearchFilter)list.get(0);
        TracUtilTest.assertEquals((String)"status", (String)filter.getFieldName());
        TracUtilTest.assertEquals(Arrays.asList("new", "assigned", "reopened"), (Object)filter.getValues());
        filter = (TracSearchFilter)list.get(1);
        TracUtilTest.assertEquals((String)"milestone", (String)filter.getFieldName());
        TracUtilTest.assertEquals(Arrays.asList("0.1"), (Object)filter.getValues());
    }

    public void testEncodeUrl() {
        TracUtilTest.assertEquals((String)"encode", (String)TracUtil.encodeUrl((String)"encode"));
        TracUtilTest.assertEquals((String)"sp%20ace%20", (String)TracUtil.encodeUrl((String)"sp ace "));
        TracUtilTest.assertEquals((String)"%2B%2B", (String)TracUtil.encodeUrl((String)"++"));
        TracUtilTest.assertEquals((String)"%2520", (String)TracUtil.encodeUrl((String)"%20"));
        TracUtilTest.assertEquals((String)"%2Fslash", (String)TracUtil.encodeUrl((String)"/slash"));
    }
}

