/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.support;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.client.TracException;
import org.eclipse.mylyn.internal.trac.core.model.TracAttachment;
import org.eclipse.mylyn.internal.trac.core.model.TracSearch;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;
import org.eclipse.mylyn.trac.tests.support.TracFixture;
import org.eclipse.mylyn.trac.tests.support.XmlRpcServer;

public class TracTestCleanupUtil
extends TestCase {
    private XmlRpcServer.TestData data;
    private ITracClient client;

    protected void setUp() throws Exception {
        this.data = TracFixture.init010();
    }

    public void testCleanup010() throws Exception {
        TracFixture fixture = TracFixture.TRAC_0_10_XML_RPC.activate();
        System.err.println("Connected to " + fixture.getRepositoryUrl());
        this.client = fixture.connect(CommonTestUtil.PrivilegeLevel.ADMIN);
        this.deleteOldAttachments();
        this.deleteOldTickets();
    }

    public void testCleanup010FormAuth() throws Exception {
        TracFixture fixture = TracFixture.TRAC_0_10_XML_RPC_FORM_AUTH.activate();
        System.err.println("Connected to " + fixture.getRepositoryUrl());
        this.client = fixture.connect(CommonTestUtil.PrivilegeLevel.ADMIN);
        this.deleteOldAttachments();
        this.deleteOldTickets();
    }

    public void testCleanup011() throws Exception {
        TracFixture fixture = TracFixture.TRAC_0_11_XML_RPC.activate();
        System.err.println("Connected to " + fixture.getRepositoryUrl());
        this.client = fixture.connect(CommonTestUtil.PrivilegeLevel.ADMIN);
        this.deleteOldAttachments();
        this.deleteOldTickets();
    }

    public void testCleanup012() throws Exception {
        TracFixture fixture = TracFixture.TRAC_0_12_XML_RPC.activate();
        System.err.println("Connected to " + fixture.getRepositoryUrl());
        this.client = fixture.connect(CommonTestUtil.PrivilegeLevel.ADMIN);
        this.deleteOldAttachments();
        this.deleteOldTickets();
    }

    public void testCleanupTrunk() throws Exception {
        TracFixture fixture = TracFixture.TRAC_TRUNK_XML_RPC.activate();
        System.err.println("Connected to " + fixture.getRepositoryUrl());
        this.client = fixture.connect(CommonTestUtil.PrivilegeLevel.ADMIN);
        this.deleteOldAttachments();
        this.deleteOldTickets();
    }

    private void deleteOldAttachments() throws TracException {
        TracTicket ticket = this.client.getTicket(this.data.attachmentTicketId, null);
        TracAttachment[] attachments = ticket.getAttachments();
        System.err.println("Found " + attachments.length + " attachments");
        System.err.print("Deleting attachment: ");
        int i = 1;
        while (i < attachments.length) {
            System.err.print(String.valueOf(i) + ", ");
            this.client.deleteAttachment(this.data.attachmentTicketId, attachments[i].getFilename(), null);
            if (i % 20 == 0) {
                System.err.println();
                System.err.print(" ");
            }
            ++i;
        }
        System.err.println();
    }

    public void deleteOldTickets() throws TracException {
        TracSearch query = new TracSearch();
        query.setMax(10000);
        ArrayList result = new ArrayList();
        this.client.searchForTicketIds(query, result, null);
        System.err.println("Found " + result.size() + " tickets");
        System.err.print("Deleting ticket: ");
        for (Integer i : result) {
            if (i <= 10) continue;
            System.err.print(i + ", ");
            this.client.deleteTicket(i.intValue(), null);
            if (i % 20 != 0) continue;
            System.err.println();
            System.err.print(" ");
        }
        System.err.println();
    }
}

