/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.util;

import junit.framework.TestCase;
import org.eclipse.mylyn.internal.wikitext.ui.util.OutlineItemWorkbenchAdapter;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.tests.EclipseRuntimeRequired;

@EclipseRuntimeRequired
public class OutlineItemWorkbenchAdapterTest
extends TestCase {
    private OutlineItem outline;
    private OutlineItem child1;
    private OutlineItem child2;
    private OutlineItemWorkbenchAdapter adapter;

    protected void setUp() throws Exception {
        super.setUp();
        this.outline = new OutlineItem(null, 0, "<root>", 0, 100, "<root>");
        this.child1 = new OutlineItem(this.outline, 1, "id1", 0, 10, "one");
        this.child2 = new OutlineItem(this.outline, 1, "id2", 11, 50, "two");
        this.adapter = new OutlineItemWorkbenchAdapter();
    }

    public void testGetParent() {
        OutlineItemWorkbenchAdapterTest.assertNull((Object)this.adapter.getParent((Object)this.outline));
        OutlineItemWorkbenchAdapterTest.assertSame((Object)this.outline, (Object)this.adapter.getParent((Object)this.child1));
        OutlineItemWorkbenchAdapterTest.assertSame((Object)this.outline, (Object)this.adapter.getParent((Object)this.child2));
    }

    public void testGetChildren() {
        OutlineItemWorkbenchAdapterTest.assertEquals((int)2, (int)this.adapter.getChildren((Object)this.outline).length);
        OutlineItemWorkbenchAdapterTest.assertSame((Object)this.child1, (Object)this.adapter.getChildren((Object)this.outline)[0]);
        OutlineItemWorkbenchAdapterTest.assertSame((Object)this.child2, (Object)this.adapter.getChildren((Object)this.outline)[1]);
        OutlineItemWorkbenchAdapterTest.assertEquals((int)0, (int)this.adapter.getChildren((Object)this.child1).length);
        OutlineItemWorkbenchAdapterTest.assertEquals((int)0, (int)this.adapter.getChildren((Object)this.child2).length);
    }

    public void testGetLabel() {
        OutlineItemWorkbenchAdapterTest.assertTrue((this.adapter.getLabel((Object)this.outline).indexOf(this.outline.getLabel()) != -1 ? 1 : 0) != 0);
        OutlineItemWorkbenchAdapterTest.assertTrue((this.adapter.getLabel((Object)this.child1).indexOf(this.child1.getLabel()) != -1 ? 1 : 0) != 0);
        OutlineItemWorkbenchAdapterTest.assertTrue((this.adapter.getLabel((Object)this.child2).indexOf(this.child2.getLabel()) != -1 ? 1 : 0) != 0);
    }
}

