/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.search;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.workbench.DecoratingPatternStyledCellLabelProvider;
import org.eclipse.mylyn.commons.workbench.EnhancedFilteredTree;
import org.eclipse.mylyn.commons.workbench.SubstringPatternFilter;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskGroup;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.actions.OpenTaskSearchAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.OpenWithBrowserAction;
import org.eclipse.mylyn.internal.tasks.ui.search.CreateQueryFromSearchAction;
import org.eclipse.mylyn.internal.tasks.ui.search.Messages;
import org.eclipse.mylyn.internal.tasks.ui.search.OpenSearchResultAction;
import org.eclipse.mylyn.internal.tasks.ui.search.RepositorySearchResult;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchHitCollector;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchResultContentProvider;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchResultSortAction;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchResultSorter;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchResultTreeContentProvider;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchResultsLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskDragSourceListener;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListToolTip;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.IShowInTargetList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositorySearchResultView
extends AbstractTextSearchViewPage
implements IAdaptable {
    private static final String MEMENTO_KEY_SORT = "sort";
    private SearchResultContentProvider searchResultProvider;
    private final OpenSearchResultAction openInEditorAction = new OpenSearchResultAction(Messages.RepositorySearchResultView_Open_in_Editor, this);
    private final CreateQueryFromSearchAction createQueryAction = new CreateQueryFromSearchAction(Messages.RepositorySearchResultView_Create_Query_from_Search_, this);
    private final Action refineSearchAction = new OpenTaskSearchAction();
    private static final String[] SHOW_IN_TARGETS = new String[]{"org.eclipse.mylyn.tasks.ui.views.tasks"};
    private TaskListToolTip toolTip;
    private final List<GroupingAction> groupingActions;
    private final List<FilteringAction> filterActions;
    private final OpenWithBrowserAction openSearchWithBrowserAction;
    private final SearchResultSorter searchResultSorter;
    private SearchResultSortAction sortByDialogAction;
    private DecoratingPatternStyledCellLabelProvider styledLabelProvider;
    private static final IShowInTargetList SHOW_IN_TARGET_LIST = new IShowInTargetList(){

        public String[] getShowInTargetIds() {
            return SHOW_IN_TARGETS;
        }
    };

    public RepositorySearchResultView() {
        super(2);
        this.refineSearchAction.setText(Messages.RepositorySearchResultView_Refine_Search_);
        this.openSearchWithBrowserAction = new OpenWithBrowserAction();
        this.openSearchWithBrowserAction.setText(Messages.RepositorySearchResultView_Open_Search_with_Browser_Label);
        this.groupingActions = new ArrayList<GroupingAction>();
        GroupingAction groupByOwnerAction = new GroupingAction(Messages.RepositorySearchResultView_Group_By_Owner, SearchResultTreeContentProvider.GroupBy.OWNER);
        groupByOwnerAction.setImageDescriptor(CommonImages.PRESENTATION);
        this.filterActions = new ArrayList<FilteringAction>();
        FilteringAction filterCompleteAction = new FilteringAction(Messages.RepositorySearchResultView_Filter_Completed_Tasks, new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof ITask) {
                    return !((ITask)element).isCompleted();
                }
                if (element instanceof TaskGroup) {
                    TaskGroup taskGroup = (TaskGroup)element;
                    return taskGroup.getHandleIdentifier().equals("group-incompleteIncomplete");
                }
                return true;
            }
        });
        filterCompleteAction.setImageDescriptor(CommonImages.FILTER_COMPLETE);
        this.searchResultSorter = new SearchResultSorter();
    }

    protected void elementsChanged(Object[] objects) {
        if (this.searchResultProvider != null) {
            this.searchResultProvider.elementsChanged(objects);
            this.getViewer().refresh();
        }
    }

    protected void clear() {
        if (this.searchResultProvider != null) {
            this.searchResultProvider.clear();
            this.getViewer().refresh();
        }
    }

    public StructuredViewer getViewer() {
        return super.getViewer();
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        this.searchResultProvider = new SearchResultTreeContentProvider();
        viewer.setContentProvider((IContentProvider)this.searchResultProvider);
        this.styledLabelProvider = new DecoratingPatternStyledCellLabelProvider((ILabelProvider)new SearchResultsLabelProvider(this.searchResultProvider, viewer), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null);
        viewer.setLabelProvider((IBaseLabelProvider)this.styledLabelProvider);
        viewer.setSorter((ViewerSorter)this.searchResultSorter);
        Transfer[] dragTypes = new Transfer[]{LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance()};
        this.getViewer().addDragSupport(7, dragTypes, (DragSourceListener)new TaskDragSourceListener((ISelectionProvider)this.getViewer()));
        this.sortByDialogAction = new SearchResultSortAction(this);
        this.toolTip = new TaskListToolTip(viewer.getControl());
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        Composite treeComposite = parent;
        Layout parentLayout = parent.getLayout();
        if (!(parentLayout instanceof GridLayout)) {
            treeComposite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            treeComposite.setLayout((Layout)layout);
        }
        EnhancedFilteredTree searchTree = new EnhancedFilteredTree(treeComposite, 770, (PatternFilter)new SubstringPatternFilter(){

            public void setPattern(String patternString) {
                RepositorySearchResultView.this.styledLabelProvider.setPattern(patternString);
                super.setPattern(patternString);
            }
        }, true);
        return searchTree.getViewer();
    }

    protected void configureTableViewer(TableViewer viewer) {
    }

    public void dispose() {
        this.toolTip.dispose();
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        return this.getAdapterDelegate(adapter);
    }

    private Object getAdapterDelegate(Class<?> adapter) {
        if (IShowInTargetList.class.equals(adapter)) {
            return SHOW_IN_TARGET_LIST;
        }
        return null;
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        AbstractTask repositoryHit = (AbstractTask)match.getElement();
        TasksUiInternal.refreshAndOpenTaskListElement((IRepositoryElement)repositoryHit);
    }

    protected void fillContextMenu(IMenuManager menuManager) {
        super.fillContextMenu(menuManager);
        menuManager.appendToGroup("group.open", (IAction)this.openInEditorAction);
        MenuManager subMenuManager = new MenuManager(MessageFormat.format(Messages.RepositorySearchResultView_Add_to_X_Category, TaskListView.LABEL_VIEW));
        ArrayList categories = new ArrayList(TasksUiInternal.getTaskList().getCategories());
        Collections.sort(categories);
        for (final AbstractTaskCategory category : categories) {
            if (category instanceof UnmatchedTaskContainer) continue;
            Action action = new Action(){

                public void run() {
                    RepositorySearchResultView.this.moveToCategory(category);
                }
            };
            String text = category.getSummary();
            action.setText(text);
            action.setImageDescriptor(TasksUiImages.CATEGORY);
            subMenuManager.add((IAction)action);
        }
        menuManager.appendToGroup("group.open", (IContributionItem)subMenuManager);
        menuManager.appendToGroup("group.search", (IAction)this.createQueryAction);
        menuManager.appendToGroup("group.search", (IAction)this.refineSearchAction);
        menuManager.appendToGroup("group.search", (IAction)this.openSearchWithBrowserAction);
        menuManager.appendToGroup("group.viewerSetup", (IAction)this.sortByDialogAction);
        this.addPresentationActions((IContributionManager)menuManager);
    }

    private void moveToCategory(AbstractTaskCategory category) {
        StructuredSelection selection = (StructuredSelection)this.getViewer().getSelection();
        for (Object selectedObject : selection) {
            if (!(selectedObject instanceof ITask)) continue;
            ITask task = (ITask)selectedObject;
            TasksUiInternal.getTaskList().addTask(task, (AbstractTaskContainer)category);
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        IMenuManager menuManager = this.getSite().getActionBars().getMenuManager();
        menuManager.appendToGroup("group.viewerSetup", (IAction)this.sortByDialogAction);
        this.addPresentationActions((IContributionManager)menuManager);
        this.addPresentationActions((IContributionManager)this.getSite().getActionBars().getToolBarManager());
    }

    public void addPresentationActions(IContributionManager menuManager) {
        for (Action action : this.groupingActions) {
            menuManager.appendToGroup("group.viewerSetup", (IAction)action);
        }
        menuManager.appendToGroup("group.viewerSetup", (IContributionItem)new Separator());
        for (Action action : this.filterActions) {
            menuManager.appendToGroup("group.viewerSetup", (IAction)action);
        }
    }

    public void setInput(ISearchResult newSearch, Object viewState) {
        super.setInput(newSearch, viewState);
        if (newSearch != null) {
            ISearchQuery query = ((RepositorySearchResult)newSearch).getQuery();
            IRepositoryQuery repositoryQuery = ((SearchHitCollector)query).getRepositoryQuery();
            this.openSearchWithBrowserAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)repositoryQuery));
        } else {
            this.openSearchWithBrowserAction.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
        }
    }

    public SearchResultSorter getSorter() {
        return this.searchResultSorter;
    }

    public void restoreState(IMemento memento) {
        IMemento child;
        super.restoreState(memento);
        if (memento != null && (child = memento.getChild(MEMENTO_KEY_SORT)) != null && this.searchResultSorter != null) {
            this.searchResultSorter.getTaskComparator().restoreState(child);
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (memento != null) {
            IMemento child = memento.createChild(MEMENTO_KEY_SORT);
            if (this.searchResultSorter != null) {
                this.searchResultSorter.getTaskComparator().saveState(child);
            }
        }
    }

    private class FilteringAction
    extends Action {
        private final ViewerFilter filter;

        public FilteringAction(String text, ViewerFilter filter) {
            super(text, 2);
            this.filter = filter;
            RepositorySearchResultView.this.filterActions.add(this);
        }

        public void runWithEvent(Event event) {
            if (this.isChecked()) {
                RepositorySearchResultView.this.getViewer().addFilter(this.filter);
            } else {
                RepositorySearchResultView.this.getViewer().removeFilter(this.filter);
            }
        }
    }

    private class GroupingAction
    extends Action {
        private final SearchResultTreeContentProvider.GroupBy groupBy;

        public GroupingAction(String text, SearchResultTreeContentProvider.GroupBy groupBy) {
            super(text, 2);
            this.groupBy = groupBy;
            RepositorySearchResultView.this.groupingActions.add(this);
        }

        public void run() {
            for (GroupingAction action : RepositorySearchResultView.this.groupingActions) {
                action.setChecked(false);
            }
            SearchResultTreeContentProvider contentProvider = (SearchResultTreeContentProvider)RepositorySearchResultView.this.getViewer().getContentProvider();
            if (contentProvider.getSelectedGroup() == this.groupBy) {
                contentProvider.setSelectedGroup(SearchResultTreeContentProvider.GroupBy.NONE);
            } else {
                contentProvider.setSelectedGroup(this.groupBy);
                this.setChecked(true);
            }
            RepositorySearchResultView.this.getViewer().refresh();
        }
    }
}

