/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.oslc.cm.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.oslc.core.OslcCreationDialogDescriptor;
import org.eclipse.mylyn.internal.oslc.core.OslcSelectionDialogDescriptor;
import org.eclipse.mylyn.internal.oslc.core.OslcServiceDescriptor;
import org.eclipse.mylyn.internal.oslc.core.OslcServiceProvider;
import org.eclipse.mylyn.internal.oslc.core.client.AbstractOslcClient;
import org.eclipse.mylyn.internal.oslc.core.cm.AbstractChangeRequest;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class ServiceDiscoveryTest
extends TestCase {
    private TaskRepository repository;
    private AbstractWebLocation location;
    private AbstractOslcClient client;

    protected void setUp() throws Exception {
        super.setUp();
        this.repository = new TaskRepository("myoslcconnetorkind", "http://mylyn.eclipse.org/oslc/cqrest");
        this.repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials("xxx", "xxx"), false);
        this.location = new TaskRepositoryLocationFactory().createWebLocation(this.repository);
        this.client = new AbstractOslcClient(this.location, new OslcServiceDescriptor("http://mylyn.eclipse.org/oslc/cqrest")){

            public RepositoryResponse putTaskData(TaskData taskData, Set<TaskAttribute> oldValues, IProgressMonitor monitor) throws CoreException {
                return null;
            }

            public String getUserAgent() {
                return null;
            }

            public TaskData getTaskData(String encodedTaskId, TaskAttributeMapper mapper, IProgressMonitor monitor) throws CoreException {
                return null;
            }

            protected AbstractChangeRequest createChangeRequest(String id, String title) {
                return new AbstractChangeRequest(id, title){};
            }
        };
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testServiceCatalogParsing() throws IOException, CoreException {
        File file = CommonTestUtil.getFile(ServiceDiscoveryTest.class, (String)"xml/service-provider-catalog.xml");
        FileInputStream inStream = new FileInputStream(file);
        ArrayList list = new ArrayList();
        this.client.parseServices((InputStream)inStream, list, (IProgressMonitor)new NullProgressMonitor());
        ServiceDiscoveryTest.assertEquals((int)2, (int)list.size());
        OslcServiceProvider desc = (OslcServiceProvider)list.get(0);
        ServiceDiscoveryTest.assertEquals((String)"http://somewhere/catalog", (String)desc.getUrl());
        desc = (OslcServiceProvider)list.get(1);
        ServiceDiscoveryTest.assertEquals((String)"http://mylyn.eclipse.org/oslc/cqrest/repo/7.0.0/db/SAMPL", (String)desc.getUrl());
    }

    public void testServiceDescriptorParsing() throws IOException, CoreException {
        File file = CommonTestUtil.getFile(ServiceDiscoveryTest.class, (String)"xml/service-descriptor.xml");
        FileInputStream inStream = new FileInputStream(file);
        OslcServiceDescriptor desc = new OslcServiceDescriptor("http://mylyn.eclipse.org/oslc/cqrest/repo/7.0.0/db/SAMPL");
        this.client.parseServiceDescriptor((InputStream)inStream, desc, (IProgressMonitor)new NullProgressMonitor());
        ServiceDiscoveryTest.assertEquals((String)"RCM/CQ OSLC CM Service Description Document", (String)desc.getTitle());
        ServiceDiscoveryTest.assertEquals((String)"Rational Change Management/ClearQuest OSLC CM Services available for 7.0.0/SAMPL.", (String)desc.getDescription());
        ServiceDiscoveryTest.assertEquals((String)"Change Requests", (String)desc.getHome().getTitle());
        ServiceDiscoveryTest.assertEquals((String)"http://mylyn.eclipse.org/cqweb/restapi/7.0.0/SAMPL?format=html", (String)desc.getHome().getUrl());
        OslcCreationDialogDescriptor creationDialog = desc.getDefaultCreationDialog();
        ServiceDiscoveryTest.assertEquals((String)"New Defect - IBM Rational ClearQuest", (String)creationDialog.getTitle());
        ServiceDiscoveryTest.assertEquals((String)"http://mylyn.eclipse.org/oslc/cqrest/repo/7.0.0/db/SAMPL/record-type/16777224/creationDialog?dc%3Atype=Defect", (String)creationDialog.getUrl());
        ServiceDiscoveryTest.assertEquals((String)"Unattended location for the creation of ClearQuest Records", (String)desc.getDefaultFactory().getTitle());
        ServiceDiscoveryTest.assertEquals((String)"http://mylyn.eclipse.org/oslc/cqrest/repo/7.0.0/db/SAMPL/record", (String)desc.getDefaultFactory().getUrl());
        ServiceDiscoveryTest.assertTrue((desc.getSelectionDialogs().size() > 0 ? 1 : 0) != 0);
        OslcSelectionDialogDescriptor selectionDialog = desc.getDefaultSelectionDialog();
        ServiceDiscoveryTest.assertNotNull((Object)selectionDialog);
        ServiceDiscoveryTest.assertEquals((String)"640px", (String)selectionDialog.getHintWidth());
        ServiceDiscoveryTest.assertEquals((String)"540px", (String)selectionDialog.getHintHeight());
        ServiceDiscoveryTest.assertEquals((String)"Choose ClearQuest Record - IBM Rational ClearQuest", (String)selectionDialog.getTitle());
        ServiceDiscoveryTest.assertEquals((String)"ClearQuest Record", (String)selectionDialog.getLabel());
        ServiceDiscoveryTest.assertEquals((String)"http://mylyn.eclipse.org/cqweb/chooseRecord.cq?type=cq.repo.cq-rectype%3A16777224%407.0.0%2FSAMPL&restrictType=false", (String)selectionDialog.getUrl());
    }
}

