/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.oslc.cm.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.oslc.core.OslcServiceDescriptor;
import org.eclipse.mylyn.internal.oslc.core.client.AbstractOslcClient;
import org.eclipse.mylyn.internal.oslc.core.cm.AbstractChangeRequest;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class SimpleQueryTest
extends TestCase {
    private TaskRepository repository;
    private AbstractWebLocation location;
    private AbstractOslcClient client;

    protected void setUp() throws Exception {
        super.setUp();
        this.repository = new TaskRepository("org.eclipse.mylyn.oslc.core", "http://mylyn.eclipse.org/oslc/cqrest");
        this.repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials("xxx", "xxx"), false);
        this.location = new TaskRepositoryLocationFactory().createWebLocation(this.repository);
        this.client = new AbstractOslcClient(this.location, new OslcServiceDescriptor("http://mylyn.eclipse.org/oslc/cqrest")){

            public RepositoryResponse putTaskData(TaskData taskData, Set<TaskAttribute> oldValues, IProgressMonitor monitor) throws CoreException {
                return null;
            }

            public String getUserAgent() {
                return null;
            }

            public TaskData getTaskData(String encodedTaskId, TaskAttributeMapper mapper, IProgressMonitor monitor) throws CoreException {
                return null;
            }

            protected AbstractChangeRequest createChangeRequest(String id, String title) {
                return new AbstractChangeRequest(id, title){};
            }
        };
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testParseQueryResponse() throws Exception {
        File file = CommonTestUtil.getFile(SimpleQueryTest.class, (String)"xml/query-response.xml");
        FileInputStream inStream = new FileInputStream(file);
        ArrayList list = new ArrayList();
        this.client.parseQueryResponse((InputStream)inStream, list, (IProgressMonitor)new NullProgressMonitor());
        SimpleQueryTest.assertEquals((int)1, (int)list.size());
        AbstractChangeRequest desc = (AbstractChangeRequest)list.get(0);
        SimpleQueryTest.assertEquals((String)"test bug", (String)desc.getTitle());
        SimpleQueryTest.assertEquals((String)"10", (String)desc.getIdentifier());
        SimpleQueryTest.assertEquals((String)"", (String)desc.getType());
        SimpleQueryTest.assertEquals((String)"test description", (String)desc.getDescription());
        SimpleQueryTest.assertEquals((String)"", (String)desc.getSubject());
        SimpleQueryTest.assertEquals((String)"", (String)desc.getCreator());
        SimpleQueryTest.assertEquals((String)"2009-10-12T08:58:20.588Z", (String)desc.getModified());
    }
}

