/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.textile.core;

import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.wikitext.tasks.ui.util.Util;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguageConfiguration;
import org.eclipse.mylyn.wikitext.core.parser.markup.block.JavaStackTraceBlock;
import org.eclipse.mylyn.wikitext.tests.EclipseRuntimeRequired;
import org.eclipse.mylyn.wikitext.tests.HeadRequired;
import org.eclipse.mylyn.wikitext.tests.TestUtil;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;

@EclipseRuntimeRequired
@HeadRequired
public class BugzillaTextileLanguageTest
extends TestCase {
    private MarkupParser parser;

    public void setUp() throws Exception {
        super.setUp();
        this.initParser();
    }

    private void initParser() throws IOException {
        this.parser = new MarkupParser();
        TextileLanguage markupLanguage = new TextileLanguage();
        MarkupLanguageConfiguration configuration = Util.create((String)"bugzilla");
        markupLanguage.configure(configuration);
        this.parser.setMarkupLanguage((MarkupLanguage)markupLanguage);
    }

    public void testQuotedBlock() {
        String html = this.parser.parseToHtml("One\n\n> Two\n\nThree");
        TestUtil.println(html);
        BugzillaTextileLanguageTest.assertTrue((boolean)html.contains("<body><p>One</p><blockquote><p>&gt; Two</p></blockquote><p>Three</p></body>"));
    }

    public void testQuotedBlock2() {
        String html = this.parser.parseToHtml("One\n\n> Two\nThree");
        TestUtil.println(html);
        BugzillaTextileLanguageTest.assertTrue((boolean)html.contains("<body><p>One</p><blockquote><p>&gt; Two</p></blockquote><p>Three</p></body>"));
    }

    public void testQuotedBlock3() {
        String html = this.parser.parseToHtml("One\n> Two\n\nThree");
        TestUtil.println(html);
        BugzillaTextileLanguageTest.assertTrue((boolean)html.contains("<body><p>One</p><blockquote><p>&gt; Two</p></blockquote><p>Three</p></body>"));
    }

    public void testQuotedBlock4() {
        String html = this.parser.parseToHtml("One\n(In reply to comment #123)\n> Two\n\nThree");
        TestUtil.println(html);
        BugzillaTextileLanguageTest.assertTrue((boolean)html.contains("<body><p>One</p><blockquote><p>(In reply to comment #123)<br/>&gt; Two</p></blockquote><p>Three</p></body>"));
    }

    public void testQuotedBlock5() {
        String html = this.parser.parseToHtml("One\n > Two\n > Three\nFour");
        TestUtil.println(html);
        BugzillaTextileLanguageTest.assertTrue((boolean)html.contains("<body><p>One</p><blockquote><p> &gt; Two<br/> &gt; Three</p></blockquote><p>Four</p></body>"));
    }

    public void testThisBugHasBeen() {
        String baseMarkup = "*** This bug has been marked as a duplicate of bug 123 ***";
        String html = this.parser.parseToHtml(baseMarkup);
        TestUtil.println(html);
        BugzillaTextileLanguageTest.assertTrue((boolean)html.contains("<p style=\"color: Blue;\">*** This bug has been marked as a duplicate of bug 123 ***</p>"));
        html = this.parser.parseToHtml(" \t " + baseMarkup);
        TestUtil.println(html);
        BugzillaTextileLanguageTest.assertTrue((boolean)html.contains("<p style=\"color: Blue;\"> \t *** This bug has been marked as a duplicate of bug 123 ***</p>"));
        html = this.parser.parseToHtml(String.valueOf(baseMarkup) + "  ");
        TestUtil.println(html);
        BugzillaTextileLanguageTest.assertTrue((boolean)html.contains("<p style=\"color: Blue;\">*** This bug has been marked as a duplicate of bug 123 ***  </p>"));
    }

    public void testThisBugHasBeenNegativeMatch() {
        String baseMarkup = "*** This bug has been marked as a duplicate of bug 123";
        String html = this.parser.parseToHtml(baseMarkup);
        TestUtil.println(html);
        BugzillaTextileLanguageTest.assertTrue((boolean)html.contains("<body><ul><li><ul><li><ul><li>This bug has been marked as a duplicate of bug 123"));
    }

    public void testBugFooHasBeenMatch() {
        String markup = "*** Bug 209610 has been marked as a duplicate of this bug. ***";
        String html = this.parser.parseToHtml(markup);
        TestUtil.println(html);
        BugzillaTextileLanguageTest.assertTrue((boolean)html.contains("<body><p style=\"color: Blue;\">*** Bug 209610 has been marked as a duplicate of this bug. ***</p>"));
    }

    public void testBugFooHasBeenNegativeMatch() {
        String markup = "*** Bug 209610 has been marked as a duplicate of this bug.";
        String html = this.parser.parseToHtml(markup);
        TestUtil.println(html);
        BugzillaTextileLanguageTest.assertTrue((boolean)html.contains("<body><ul><li><ul><li><ul><li>Bug 209610 has been marked as a duplicate of this bug."));
    }

    public void testXmlEscaping() {
        String html = this.parser.parseToHtml("some <start>mark</start> up");
        TestUtil.println(html);
        BugzillaTextileLanguageTest.assertTrue((boolean)html.contains("<p>some &lt;start&gt;mark&lt;/start&gt; up</p>"));
    }

    public void testHtmlEscaping() {
        String html = this.parser.parseToHtml("some <span class=\"s\">mark</span> up");
        TestUtil.println(html);
        BugzillaTextileLanguageTest.assertTrue((boolean)html.contains("<p>some &lt;span class=\"s\"&gt;mark&lt;/span&gt; up</p>"));
    }

    public void testJavaStackTraceDetection() {
        String html = this.parser.parseToHtml("text\njava.lang.Exception: java.lang.IllegalStateException\n\tat org.eclipse.mylyn.internal.wikitext.tasks.ui.util.Test.main(Test.java:21)\nCaused by: java.lang.IllegalStateException\n\t... 1 more\ntext");
        TestUtil.println(html);
        BugzillaTextileLanguageTest.assertTrue((boolean)html.contains("<p>text</p><pre class=\"javaStackTrace\">java.lang.Exception"));
        BugzillaTextileLanguageTest.assertTrue((boolean)html.contains("</pre><p>text</p>"));
    }

    public void testJavaStackTraceDetection_bug280805() {
        String html = this.parser.parseToHtml("text\njava.lang.Exception: java.lang.IllegalStateException\n\tat org.eclipse.mylyn.internal.wikitext.tasks.ui.util.test.main(Test.java:21)\nCaused by: java.lang.IllegalStateException\n\t... 1 more\ntext");
        TestUtil.println(html);
        BugzillaTextileLanguageTest.assertTrue((boolean)html.contains("<p>text</p><pre class=\"javaStackTrace\">java.lang.Exception"));
        BugzillaTextileLanguageTest.assertTrue((boolean)html.contains("</pre><p>text</p>"));
    }

    public void testJavaStackTraceDetection_bug273629() {
        boolean canStart = new JavaStackTraceBlock().canStart("org.eclipse.ui.internal.PerspectiveBarContributionItem.select(PerspectiveBarContributionItem.java:124)", 0);
        BugzillaTextileLanguageTest.assertTrue((boolean)canStart);
    }

    public void testJavaStackTraceDetection_bug283629() {
        boolean canStart = new JavaStackTraceBlock().canStart(" org.eclipse.ui.texteditor.AbstractDecoratedTextEditor$11.run()V+165", 0);
        BugzillaTextileLanguageTest.assertFalse((boolean)canStart);
    }

    public void testJavaStackTraceDetection_bug298781() {
        String markup = "java.io.EOFException\nat java.io.DataInputStream.readInt(Unknown Source)\nat org.eclipse.jdt.internal.core.JavaModelManager.loadNonChainingJarsCache(JavaModelManager.java:2843)\nat org.eclipse.jdt.internal.core.JavaModelManager.<init>(JavaModelManager.java:1477)\nat org.eclipse.jdt.internal.core.JavaModelManager.<clinit>(JavaModelManager.java:1012)\nat org.eclipse.jdt.core.JavaCore.start(JavaCore.java:4965)\nat org.eclipse.osgi.framework.internal.core.BundleContextImpl$1.run(BundleContextImpl.java:783)\nat java.security.AccessController.doPrivileged(Native Method)";
        String html = this.parser.parseToHtml(markup);
        TestUtil.println(html);
        BugzillaTextileLanguageTest.assertTrue((boolean)html.contains("<pre class=\"javaStackTrace\">java.io.EOFException\nat java.io.DataInputStream.readInt(Unknown Source)\nat org.eclipse.jdt.internal.core.JavaModelManager.loadNonChainingJarsCache(JavaModelManager.java:2843)\nat org.eclipse.jdt.internal.core.JavaModelManager.&lt;init&gt;(JavaModelManager.java:1477)\nat org.eclipse.jdt.internal.core.JavaModelManager.&lt;clinit&gt;(JavaModelManager.java:1012)\nat org.eclipse.jdt.core.JavaCore.start(JavaCore.java:4965)\nat org.eclipse.osgi.framework.internal.core.BundleContextImpl$1.run(BundleContextImpl.java:783)\nat java.security.AccessController.doPrivileged(Native Method)\n</pre>"));
    }

    public void testEclipseErrorDetailsBlock() {
        String html = this.parser.parseToHtml("text\n-- Error Details --\ndetail line 1\n\nno detail");
        TestUtil.println(html);
        BugzillaTextileLanguageTest.assertTrue((boolean)html.contains("<p>text</p><pre class=\"eclipseErrorDetails\">-- Error Details --"));
        BugzillaTextileLanguageTest.assertTrue((boolean)html.contains("</pre><p>no detail</p>"));
    }
}

