/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.index.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.index.core.TaskListIndex;
import org.eclipse.mylyn.internal.tasks.index.ui.AbstractIndexReference;
import org.eclipse.mylyn.internal.tasks.index.ui.ContentProposal;
import org.eclipse.mylyn.internal.tasks.index.ui.Messages;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskSchema;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentProposalProvider
implements IContentProposalProvider {
    private static final Pattern PATTERN_WHITESPACE = Pattern.compile("\\s");
    private static final Pattern PATTERN_SPECIAL_CHARACTERS = Pattern.compile("([+&\\|!\\(\\)\\{\\}\\[\\]^\"~\\*\\?:\\\\-])");
    private final AbstractIndexReference reference;
    private final TaskList taskList;

    public ContentProposalProvider(TaskList taskList, AbstractIndexReference reference) {
        this.taskList = taskList;
        this.reference = reference;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        ArrayList<IContentProposal> proposals = new ArrayList<IContentProposal>(10);
        ProposalContentState contentState = this.computeProposalContentState(contents, position);
        if (contentState.fieldPrefix.length() > 0) {
            AbstractTaskSchema.Field indexField = this.computeIndexField(contentState.fieldPrefix);
            if (indexField != null && "person".equals(indexField.getType())) {
                this.computePersonProposals(proposals, contentState);
            }
        } else {
            for (AbstractTaskSchema.Field field : this.reference.index().getIndexedFields()) {
                String indexKey;
                if (field.equals((Object)TaskListIndex.FIELD_IDENTIFIER) || !(indexKey = field.getIndexKey()).startsWith(contentState.prefix)) continue;
                String description = TaskListIndex.FIELD_CONTENT.equals((Object)field) ? Messages.IndexSearchHandler_hint_content : (TaskListIndex.FIELD_PERSON.equals((Object)field) ? Messages.IndexSearchHandler_hint_person : NLS.bind((String)Messages.IndexSearchHandler_hint_generic, (Object)field.getLabel()));
                proposals.add(new ContentProposal(String.valueOf(contentState.beforePrefixContent) + indexKey + ":", contentState.suffix, indexKey, description));
                if (!"date".equals(field.getType()) && !"dateTime".equals(field.getType())) continue;
                this.computeDateRangeProposals(proposals, contentState, field);
            }
        }
        return proposals.toArray(new IContentProposal[proposals.size()]);
    }

    public ProposalContentState computeProposalContentState(String contents, int position) {
        ProposalContentState contentState = new ProposalContentState(contents);
        if (position >= 0 && position <= contents.length()) {
            int i = position;
            while (i > 0 && !Character.isWhitespace(contents.charAt(i - 1)) && contents.charAt(i - 1) != ':') {
                --i;
            }
            if (i > 0 && contents.charAt(i - 1) == ':') {
                int fieldEnd = i - 1;
                int fieldStart = i - 1;
                while (fieldStart > 0 && Character.isLetter(contents.charAt(fieldStart - 1))) {
                    --fieldStart;
                }
                contentState.fieldPrefix = contents.substring(fieldStart, fieldEnd);
            }
            contentState.prefix = contents.substring(i, position);
            contentState.beforePrefixContent = contents.substring(0, i);
            if (position < contents.length()) {
                i = position;
                while (i < contents.length()) {
                    if (Character.isWhitespace(contents.charAt(i))) break;
                    ++i;
                }
                contentState.suffix = contents.substring(i);
            }
        }
        return contentState;
    }

    public AbstractTaskSchema.Field computeIndexField(String fieldPrefix) {
        for (AbstractTaskSchema.Field field : this.reference.index().getIndexedFields()) {
            if (!field.getIndexKey().equals(fieldPrefix)) continue;
            return field;
        }
        return null;
    }

    public void computeDateRangeProposals(List<IContentProposal> proposals, ProposalContentState contentState, AbstractTaskSchema.Field field) {
        Date now = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(now);
        calendar.add(7, 1);
        Date dateSearchUpperBound = calendar.getTime();
        calendar.setTime(now);
        calendar.add(7, -7);
        Date dateSearchOneWeekLowerBound = calendar.getTime();
        String description = NLS.bind((String)Messages.IndexSearchHandler_Generic_date_range_search_1_week, (Object)field.getLabel());
        String label = NLS.bind((String)Messages.IndexSearchHandler_Past_week_date_range_label, (Object)field.getIndexKey());
        String queryText = this.reference.index().computeQueryFieldDateRange(field, dateSearchOneWeekLowerBound, dateSearchUpperBound);
        if (queryText.startsWith(contentState.prefix)) {
            proposals.add(new ContentProposal(String.valueOf(contentState.beforePrefixContent) + queryText, contentState.suffix, label, description));
        }
    }

    public void computePersonProposals(List<IContentProposal> proposals, ProposalContentState contentState) {
        TreeSet<String> addresses = new TreeSet<String>();
        Collection allTasks = this.taskList.getAllTasks();
        for (AbstractTask task : allTasks) {
            this.addAddresses(addresses, task);
        }
        for (String address : addresses) {
            if (!address.startsWith(contentState.prefix)) continue;
            String proposalContent = address;
            if (PATTERN_WHITESPACE.matcher(proposalContent = PATTERN_SPECIAL_CHARACTERS.matcher(proposalContent).replaceAll("\\\\$1")).find()) {
                proposalContent = "\"" + proposalContent + "\"";
            }
            proposals.add(new ContentProposal(String.valueOf(contentState.beforePrefixContent) + proposalContent, contentState.suffix, address, null));
        }
    }

    private void addAddresses(Set<String> addresses, AbstractTask task) {
        String name = task.getOwner();
        if (name != null && name.trim().length() > 0) {
            addresses.add(name.trim());
        }
    }

    public static class ProposalContentState {
        public String beforePrefixContent;
        public String fieldPrefix = "";
        public String prefix = "";
        public String suffix = "";

        public ProposalContentState(String contents) {
            this.beforePrefixContent = contents;
        }
    }
}

