/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.commons.sdk.util.ManagedTestSuite;
import org.eclipse.mylyn.commons.sdk.util.TestConfiguration;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.trac.tests.AllTracHeadlessStandaloneTests;
import org.eclipse.mylyn.trac.tests.core.TracAttachmentHandlerTest;
import org.eclipse.mylyn.trac.tests.core.TracRepositoryConnectorTest;
import org.eclipse.mylyn.trac.tests.core.TracRepositoryConnectorWebTest;
import org.eclipse.mylyn.trac.tests.core.TracRepositoryQueryTest;
import org.eclipse.mylyn.trac.tests.core.TracTaskDataHandlerXmlRpcTest;
import org.eclipse.mylyn.trac.tests.core.TracUtilTest;
import org.eclipse.mylyn.trac.tests.support.TracFixture;
import org.eclipse.mylyn.trac.tests.support.TracTestCleanupUtil;
import org.eclipse.mylyn.trac.tests.ui.TracHyperlinkUtilTest;
import org.eclipse.mylyn.trac.tests.ui.TracRepositorySettingsPageTest;

public class AllTracTests {
    public static Test suite() {
        ManagedTestSuite suite = new ManagedTestSuite(AllTracTests.class.getName());
        AllTracTests.addTests((TestSuite)suite, TestConfiguration.getDefault());
        return suite;
    }

    public static Test suite(TestConfiguration configuration) {
        TestSuite suite = new TestSuite(AllTracTests.class.getName());
        AllTracTests.addTests(suite, configuration);
        return suite;
    }

    public static void addTests(TestSuite suite, TestConfiguration configuration) {
        if (configuration.hasKind(TestConfiguration.TestKind.INTEGRATION) && !configuration.isLocalOnly() && CommonTestUtil.hasCredentials((CommonTestUtil.PrivilegeLevel)CommonTestUtil.PrivilegeLevel.ADMIN)) {
            suite.addTestSuite(TracTestCleanupUtil.class);
        }
        suite.addTest(AllTracHeadlessStandaloneTests.suite(configuration));
        suite.addTestSuite(TracUtilTest.class);
        suite.addTestSuite(TracHyperlinkUtilTest.class);
        if (!configuration.isLocalOnly()) {
            suite.addTestSuite(TracRepositoryQueryTest.class);
            suite.addTestSuite(TracRepositorySettingsPageTest.class);
            if (configuration.isDefaultOnly()) {
                AllTracTests.addTests(suite, TracFixture.DEFAULT);
            } else {
                TracFixture[] tracFixtureArray = TracFixture.ALL;
                int n = TracFixture.ALL.length;
                int n2 = 0;
                while (n2 < n) {
                    TracFixture fixture = tracFixtureArray[n2];
                    AllTracTests.addTests(suite, fixture);
                    ++n2;
                }
            }
        }
    }

    protected static void addTests(TestSuite suite, TracFixture fixture) {
        fixture.createSuite(suite);
        fixture.add(TracRepositoryConnectorTest.class);
        if (fixture.getAccessMode() == ITracClient.Version.XML_RPC) {
            fixture.add(TracTaskDataHandlerXmlRpcTest.class);
            fixture.add(TracAttachmentHandlerTest.class);
        } else {
            fixture.add(TracRepositoryConnectorWebTest.class);
        }
        fixture.done();
    }
}

