/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.client;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.trac.core.TracAttribute;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.client.TracException;
import org.eclipse.mylyn.internal.trac.core.client.TracLoginException;
import org.eclipse.mylyn.internal.trac.core.client.TracPermissionDeniedException;
import org.eclipse.mylyn.internal.trac.core.client.TracRemoteException;
import org.eclipse.mylyn.internal.trac.core.model.TracSearch;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketField;
import org.eclipse.mylyn.internal.trac.core.model.TracVersion;
import org.eclipse.mylyn.trac.tests.support.TracFixture;
import org.eclipse.mylyn.trac.tests.support.TracTestUtil;
import org.eclipse.mylyn.trac.tests.support.XmlRpcServer;

public class TracClientTest
extends TestCase {
    private ITracClient client;
    private XmlRpcServer.TestData data;
    private TracFixture fixture;
    protected List<XmlRpcServer.Ticket> tickets;

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture = TracFixture.current();
        this.client = this.fixture.connect();
        this.data = TracFixture.init010();
        this.tickets = this.data.tickets;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetTicket() throws Exception {
        TracTicket ticket = this.client.getTicket(this.tickets.get(0).getId(), null);
        TracTestUtil.assertTicketEquals(this.tickets.get(0), ticket);
        ticket = this.client.getTicket(this.tickets.get(1).getId(), null);
        TracTestUtil.assertTicketEquals(this.tickets.get(1), ticket);
    }

    public void testGetTicketInvalidId() throws Exception {
        try {
            this.client.getTicket(Integer.MAX_VALUE, null);
            TracClientTest.fail((String)"Expected TracException");
        }
        catch (TracException tracException) {}
    }

    public void testGetTicketUmlaute() throws Exception {
        TracTicket ticket = this.client.getTicket(this.data.htmlEntitiesTicketId, null);
        TracClientTest.assertEquals((String)"test html entities: \u00e4\u00f6\u00fc", (String)ticket.getValue(TracTicket.Key.SUMMARY));
        if (this.client.getAccessMode() == ITracClient.Version.XML_RPC) {
            TracClientTest.assertEquals((String)"\u00c4\u00d6\u00dc\n\nmulti\nline\n\n'''bold'''\n", (String)ticket.getValue(TracTicket.Key.DESCRIPTION));
        } else {
            TracClientTest.assertEquals(null, (String)ticket.getValue(TracTicket.Key.DESCRIPTION));
        }
    }

    public void testProxy() throws Exception {
        this.client = this.fixture.connect(this.fixture.getRepositoryUrl(), "", "", new Proxy(Proxy.Type.HTTP, new InetSocketAddress("invalidhostname", 8080)));
        try {
            this.client.validate((IProgressMonitor)new NullProgressMonitor());
            TracClientTest.fail((String)"Expected IOException");
        }
        catch (TracException tracException) {}
    }

    public void testSearchAll() throws Exception {
        TracSearch search = new TracSearch();
        ArrayList result = new ArrayList();
        this.client.search(search, result, null);
        TracClientTest.assertTrue((result.size() >= this.tickets.size() ? 1 : 0) != 0);
    }

    public void testSearchEmpty() throws Exception {
        TracSearch search = new TracSearch();
        search.addFilter("milestone", "does not exist");
        ArrayList result = new ArrayList();
        this.client.search(search, result, null);
        TracClientTest.assertEquals((int)0, (int)result.size());
    }

    public void testSearchExactMatch() throws Exception {
        TracSearch search = new TracSearch();
        search.addFilter("milestone", "milestone1");
        search.addFilter("summary", "summary1");
        ArrayList result = new ArrayList();
        this.client.search(search, result, null);
        TracClientTest.assertEquals((int)1, (int)result.size());
        TracTestUtil.assertTicketEquals(this.tickets.get(0), (TracTicket)result.get(0));
        TracClientTest.assertEquals((String)"milestone1", (String)((TracTicket)result.get(0)).getValue(TracTicket.Key.MILESTONE));
        TracClientTest.assertEquals((String)"summary1", (String)((TracTicket)result.get(0)).getValue(TracTicket.Key.SUMMARY));
    }

    public void testSearchMilestone1() throws Exception {
        TracSearch search = new TracSearch();
        search.addFilter("milestone", "milestone1");
        ArrayList result = new ArrayList();
        this.client.search(search, result, null);
        TracClientTest.assertEquals((int)1, (int)result.size());
        TracTestUtil.assertTicketEquals(this.tickets.get(0), (TracTicket)result.get(0));
    }

    public void testSearchMilestone2() throws Exception {
        TracSearch search = new TracSearch();
        search.addFilter("milestone", "milestone1");
        search.addFilter("milestone", "milestone2");
        search.setOrderBy("id");
        ArrayList result = new ArrayList();
        this.client.search(search, result, null);
        TracClientTest.assertEquals((int)3, (int)result.size());
        TracTestUtil.assertTicketEquals(this.tickets.get(0), (TracTicket)result.get(0));
        TracTestUtil.assertTicketEquals(this.tickets.get(1), (TracTicket)result.get(1));
        TracTestUtil.assertTicketEquals(this.tickets.get(2), (TracTicket)result.get(2));
    }

    public void testSearchMilestoneAmpersand() throws Exception {
        block2: {
            TracSearch search = new TracSearch();
            search.addFilter("milestone", "mile&stone");
            search.setOrderBy("id");
            ArrayList result = new ArrayList();
            try {
                this.client.search(search, result, null);
                TracClientTest.assertEquals((int)1, (int)result.size());
                TracTestUtil.assertTicketEquals(this.tickets.get(7), (TracTicket)result.get(0));
            }
            catch (TracRemoteException e) {
                if ("'Query filter requires field and constraints separated by a \"=\"' while executing 'ticket.query()'".equals(e.getMessage()) && (this.fixture.getVersion().equals("0.10") || this.fixture.getVersion().equals("0.11"))) break block2;
                throw e;
            }
        }
    }

    public void testStatusClosed() throws Exception {
        TracTicket ticket = this.client.getTicket(this.data.offlineHandlerTicketId, null);
        TracClientTest.assertEquals((String)"closed", (String)ticket.getValue(TracTicket.Key.STATUS));
        TracClientTest.assertEquals((String)"fixed", (String)ticket.getValue(TracTicket.Key.RESOLUTION));
    }

    public void testUpdateAttributesAnonymous() throws Exception {
        this.client = this.fixture.connect(this.fixture.getRepositoryUrl(), "", "");
        TracClientTest.assertNull((Object)this.client.getMilestones());
        try {
            this.client.updateAttributes((IProgressMonitor)new NullProgressMonitor(), true);
            if (this.fixture.getAccessMode() == ITracClient.Version.XML_RPC) {
                TracClientTest.fail((String)"Expected anonymous access to be denied");
            }
        }
        catch (TracPermissionDeniedException e) {
            if (this.fixture.getAccessMode() == ITracClient.Version.XML_RPC) {
                return;
            }
            throw e;
        }
        TracVersion[] versions = this.client.getVersions();
        TracClientTest.assertEquals((int)2, (int)versions.length);
        Arrays.sort(versions, new Comparator<TracVersion>(){

            @Override
            public int compare(TracVersion o1, TracVersion o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        TracClientTest.assertEquals((String)"1.0", (String)versions[0].getName());
        TracClientTest.assertEquals((String)"2.0", (String)versions[1].getName());
    }

    public void testUpdateAttributesChangedTicketFields() throws Exception {
        if (this.fixture.getAccessMode() == ITracClient.Version.TRAC_0_9) {
            return;
        }
        this.client = this.fixture.connect(this.fixture.getRepositoryUrl());
        this.client.updateAttributes((IProgressMonitor)new NullProgressMonitor(), true);
        TracTicketField field = this.client.getTicketFieldByName(TracAttribute.MILESTONE.getTracKey());
        field.setDefaultValue("modified default value");
        this.client.updateAttributes((IProgressMonitor)new NullProgressMonitor(), true);
        field = this.client.getTicketFieldByName(TracAttribute.MILESTONE.getTracKey());
        TracClientTest.assertEquals((String)"", (String)field.getDefaultValue());
    }

    public void testValidate() throws Exception {
        UserCredentials credentials = CommonTestUtil.getCredentials((CommonTestUtil.PrivilegeLevel)CommonTestUtil.PrivilegeLevel.USER);
        this.client.validate((IProgressMonitor)new NullProgressMonitor());
        this.client = TracFixture.current().connect("http://non.existant/repository");
        try {
            this.client.validate((IProgressMonitor)new NullProgressMonitor());
            TracClientTest.fail((String)"Expected TracException");
        }
        catch (TracException tracException) {}
        String url = TracFixture.current().getRepositoryUrl();
        this.client = TracFixture.current().connect(url, credentials.getUserName(), "wrongpassword");
        try {
            this.client.validate((IProgressMonitor)new NullProgressMonitor());
            TracClientTest.fail((String)"Expected TracLoginException");
        }
        catch (TracLoginException tracLoginException) {}
        this.client = TracFixture.current().connect(url, "wrongusername", credentials.getPassword());
        try {
            this.client.validate((IProgressMonitor)new NullProgressMonitor());
            TracClientTest.fail((String)"Expected TracLoginException");
        }
        catch (TracLoginException tracLoginException) {}
    }

    public void testValidateAnonymousLogin() throws Exception {
        block3: {
            this.client = this.fixture.connect(this.fixture.getRepositoryUrl(), "", "");
            try {
                this.client.validate((IProgressMonitor)new NullProgressMonitor());
                if (this.fixture.getAccessMode() == ITracClient.Version.XML_RPC) {
                    TracClientTest.fail((String)"Expected anonymous access to be denied");
                }
            }
            catch (TracPermissionDeniedException tracPermissionDeniedException) {
                if (this.fixture.getAccessMode() != ITracClient.Version.TRAC_0_9) break block3;
                TracClientTest.fail((String)"Expected anonymous access to be allowed");
            }
        }
    }

    public void testValidateAnyPage() throws Exception {
        this.client = this.fixture.connect("http://mylyn.eclipse.org/");
        try {
            this.client.validate((IProgressMonitor)new NullProgressMonitor());
            TracClientTest.fail((String)"Expected TracException");
        }
        catch (TracException tracException) {}
    }
}

