/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.core;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.internal.tasks.ui.wizards.EditRepositoryWizard;
import org.eclipse.mylyn.internal.trac.core.TracRepositoryConnector;
import org.eclipse.mylyn.internal.trac.core.TracTaskDataHandler;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.model.TracPriority;
import org.eclipse.mylyn.internal.trac.core.model.TracSearch;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;
import org.eclipse.mylyn.internal.trac.core.model.TracVersion;
import org.eclipse.mylyn.internal.trac.ui.wizard.TracRepositorySettingsPage;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.trac.tests.support.TracFixture;
import org.eclipse.mylyn.trac.tests.support.TracTestUtil;
import org.eclipse.mylyn.trac.tests.support.XmlRpcServer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TracRepositoryConnectorTest
extends TestCase {
    private XmlRpcServer.TestData data;
    private TaskRepository repository;
    private TracRepositoryConnector connector;

    protected void setUp() throws Exception {
        super.setUp();
        this.data = TracFixture.init010();
        this.connector = (TracRepositoryConnector)TasksUi.getRepositoryConnector((String)"trac");
        this.repository = TracFixture.current().singleRepository(this.connector);
    }

    public void testGetRepositoryUrlFromTaskUrl() {
        TracRepositoryConnectorTest.assertEquals((String)"http://host/repo", (String)this.connector.getRepositoryUrlFromTaskUrl("http://host/repo/ticket/1"));
        TracRepositoryConnectorTest.assertEquals((String)"http://host", (String)this.connector.getRepositoryUrlFromTaskUrl("http://host/ticket/2342"));
        TracRepositoryConnectorTest.assertEquals(null, (String)this.connector.getRepositoryUrlFromTaskUrl("http://host/repo/2342"));
        TracRepositoryConnectorTest.assertEquals(null, (String)this.connector.getRepositoryUrlFromTaskUrl("http://host/repo/ticket-2342"));
    }

    public void testCreateTaskFromExistingKeyXml() throws CoreException {
        String taskId = String.valueOf(this.data.tickets.get(0).getId());
        TaskData taskData = this.connector.getTaskData(this.repository, taskId, null);
        ITask task = TasksUi.getRepositoryModel().createTask(this.repository, taskData.getTaskId());
        TracRepositoryConnectorTest.assertNotNull((Object)task);
        this.connector.updateTaskFromTaskData(this.repository, task, taskData);
        TracRepositoryConnectorTest.assertEquals(TaskTask.class, task.getClass());
        TracRepositoryConnectorTest.assertTrue((boolean)task.getSummary().contains("summary1"));
        TracRepositoryConnectorTest.assertEquals((String)(String.valueOf(this.repository.getRepositoryUrl()) + "/ticket/" + taskId), (String)task.getUrl());
    }

    public void testClientManagerChangeTaskRepositorySettings() throws MalformedURLException {
        this.repository = TracFixture.TRAC_0_10_WEB.singleRepository();
        ITracClient client = this.connector.getClientManager().getTracClient(this.repository);
        TracRepositoryConnectorTest.assertEquals((Object)ITracClient.Version.TRAC_0_9, (Object)client.getAccessMode());
        EditRepositoryWizard wizard = new EditRepositoryWizard(this.repository);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        try {
            dialog.create();
            ((TracRepositorySettingsPage)wizard.getSettingsPage()).setTracVersion(ITracClient.Version.XML_RPC);
            TracRepositoryConnectorTest.assertTrue((boolean)wizard.performFinish());
            client = this.connector.getClientManager().getTracClient(this.repository);
            TracRepositoryConnectorTest.assertEquals((Object)ITracClient.Version.XML_RPC, (Object)client.getAccessMode());
        }
        finally {
            dialog.close();
        }
    }

    public void testPerformQuery() {
        TracSearch search = new TracSearch();
        search.addFilter("milestone", "milestone1");
        search.addFilter("milestone", "milestone2");
        search.setOrderBy("id");
        IRepositoryQuery query = TasksUi.getRepositoryModel().createRepositoryQuery(this.repository);
        query.setUrl(String.valueOf(this.repository.getUrl()) + "/query?format=tab" + search.toUrl());
        final ArrayList result = new ArrayList();
        TaskDataCollector hitCollector = new TaskDataCollector(){

            public void accept(TaskData hit) {
                result.add(hit);
            }
        };
        IStatus queryStatus = this.connector.performQuery(this.repository, query, hitCollector, null, (IProgressMonitor)new NullProgressMonitor());
        TracRepositoryConnectorTest.assertEquals((Object)Status.OK_STATUS, (Object)queryStatus);
        TracRepositoryConnectorTest.assertEquals((int)3, (int)result.size());
        TracRepositoryConnectorTest.assertEquals((String)String.valueOf(this.data.tickets.get(0).getId()), (String)((TaskData)result.get(0)).getTaskId());
        TracRepositoryConnectorTest.assertEquals((String)String.valueOf(this.data.tickets.get(1).getId()), (String)((TaskData)result.get(1)).getTaskId());
        TracRepositoryConnectorTest.assertEquals((String)String.valueOf(this.data.tickets.get(2).getId()), (String)((TaskData)result.get(2)).getTaskId());
    }

    public void testUpdateAttributes() throws Exception {
        this.connector.updateRepositoryConfiguration(this.repository, (IProgressMonitor)new NullProgressMonitor());
        ITracClient server = this.connector.getClientManager().getTracClient(this.repository);
        TracVersion[] versions = server.getVersions();
        TracRepositoryConnectorTest.assertEquals((int)2, (int)versions.length);
        Arrays.sort(versions, new Comparator<TracVersion>(){

            @Override
            public int compare(TracVersion o1, TracVersion o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        TracRepositoryConnectorTest.assertEquals((String)"1.0", (String)versions[0].getName());
        TracRepositoryConnectorTest.assertEquals((String)"2.0", (String)versions[1].getName());
    }

    public void testContext() throws Exception {
        boolean result;
        String taskId = String.valueOf(this.data.attachmentTicketId);
        ITask task = TracTestUtil.createTask(this.repository, taskId);
        File sourceContextFile = TasksUiPlugin.getContextStore().getFileForContext(task);
        sourceContextFile.createNewFile();
        sourceContextFile.deleteOnExit();
        try {
            result = AttachmentUtil.postContext((AbstractRepositoryConnector)this.connector, (TaskRepository)this.repository, (ITask)task, (String)"", null, null);
            if (this.repository.getVersion().equals(ITracClient.Version.TRAC_0_9.name())) {
                TracRepositoryConnectorTest.fail((String)"expected CoreException");
            }
        }
        catch (CoreException e) {
            if (this.repository.getVersion().equals(ITracClient.Version.TRAC_0_9.name())) {
                return;
            }
            throw e;
        }
        TracRepositoryConnectorTest.assertTrue((boolean)result);
        task = TracTestUtil.createTask(this.repository, taskId);
        List<ITaskAttachment> attachments = TracTestUtil.getTaskAttachments(task);
        ITaskAttachment attachment = attachments.get(attachments.size() - 1);
        result = AttachmentUtil.downloadContext((ITask)task, (ITaskAttachment)attachment, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
        TracRepositoryConnectorTest.assertTrue((boolean)result);
        TracRepositoryConnectorTest.assertTrue((boolean)task.isActive());
    }

    public void testIsCompleted() {
        TracRepositoryConnectorTest.assertTrue((boolean)TracRepositoryConnector.isCompleted((String)"closed"));
        TracRepositoryConnectorTest.assertFalse((boolean)TracRepositoryConnector.isCompleted((String)"Closed"));
        TracRepositoryConnectorTest.assertFalse((boolean)TracRepositoryConnector.isCompleted((String)"new"));
        TracRepositoryConnectorTest.assertFalse((boolean)TracRepositoryConnector.isCompleted((String)"assigned"));
        TracRepositoryConnectorTest.assertFalse((boolean)TracRepositoryConnector.isCompleted((String)"reopened"));
        TracRepositoryConnectorTest.assertFalse((boolean)TracRepositoryConnector.isCompleted((String)"foobar"));
        TracRepositoryConnectorTest.assertFalse((boolean)TracRepositoryConnector.isCompleted((String)""));
        TracRepositoryConnectorTest.assertFalse((boolean)TracRepositoryConnector.isCompleted(null));
    }

    public void testGetTaskPriority() {
        TracRepositoryConnectorTest.assertEquals((String)"P1", (String)TracRepositoryConnector.getTaskPriority((String)"blocker").toString());
        TracRepositoryConnectorTest.assertEquals((String)"P2", (String)TracRepositoryConnector.getTaskPriority((String)"critical").toString());
        TracRepositoryConnectorTest.assertEquals((String)"P3", (String)TracRepositoryConnector.getTaskPriority((String)"major").toString());
        TracRepositoryConnectorTest.assertEquals((String)"P3", (String)TracRepositoryConnector.getTaskPriority(null).toString());
        TracRepositoryConnectorTest.assertEquals((String)"P3", (String)TracRepositoryConnector.getTaskPriority((String)"").toString());
        TracRepositoryConnectorTest.assertEquals((String)"P3", (String)TracRepositoryConnector.getTaskPriority((String)"foo bar").toString());
        TracRepositoryConnectorTest.assertEquals((String)"P4", (String)TracRepositoryConnector.getTaskPriority((String)"minor").toString());
        TracRepositoryConnectorTest.assertEquals((String)"P5", (String)TracRepositoryConnector.getTaskPriority((String)"trivial").toString());
    }

    public void testGetTaskPriorityFromTracPriorities() {
        TracPriority p1 = new TracPriority("a", 1);
        TracPriority p2 = new TracPriority("b", 2);
        TracPriority p3 = new TracPriority("c", 3);
        TracPriority[] priorities = new TracPriority[]{p1, p2, p3};
        TracRepositoryConnectorTest.assertEquals((String)"P1", (String)TracRepositoryConnector.getTaskPriority((String)"a", (TracPriority[])priorities).toString());
        TracRepositoryConnectorTest.assertEquals((String)"P3", (String)TracRepositoryConnector.getTaskPriority((String)"b", (TracPriority[])priorities).toString());
        TracRepositoryConnectorTest.assertEquals((String)"P5", (String)TracRepositoryConnector.getTaskPriority((String)"c", (TracPriority[])priorities).toString());
        TracRepositoryConnectorTest.assertEquals((String)"P3", (String)TracRepositoryConnector.getTaskPriority((String)"foo", (TracPriority[])priorities).toString());
        TracRepositoryConnectorTest.assertEquals((String)"P3", (String)TracRepositoryConnector.getTaskPriority(null, (TracPriority[])priorities).toString());
        p1 = new TracPriority("a", 10);
        priorities = new TracPriority[]{p1};
        TracRepositoryConnectorTest.assertEquals((String)"P1", (String)TracRepositoryConnector.getTaskPriority((String)"a", (TracPriority[])priorities).toString());
        TracRepositoryConnectorTest.assertEquals((String)"P3", (String)TracRepositoryConnector.getTaskPriority((String)"b", (TracPriority[])priorities).toString());
        TracRepositoryConnectorTest.assertEquals((String)"P3", (String)TracRepositoryConnector.getTaskPriority(null, (TracPriority[])priorities).toString());
        p1 = new TracPriority("1", 10);
        p2 = new TracPriority("2", 20);
        p3 = new TracPriority("3", 30);
        TracPriority p4 = new TracPriority("4", 40);
        TracPriority p5 = new TracPriority("5", 70);
        TracPriority p6 = new TracPriority("6", 100);
        priorities = new TracPriority[]{p1, p2, p3, p4, p5, p6};
        TracRepositoryConnectorTest.assertEquals((String)"P1", (String)TracRepositoryConnector.getTaskPriority((String)"1", (TracPriority[])priorities).toString());
        TracRepositoryConnectorTest.assertEquals((String)"P1", (String)TracRepositoryConnector.getTaskPriority((String)"2", (TracPriority[])priorities).toString());
        TracRepositoryConnectorTest.assertEquals((String)"P2", (String)TracRepositoryConnector.getTaskPriority((String)"3", (TracPriority[])priorities).toString());
        TracRepositoryConnectorTest.assertEquals((String)"P2", (String)TracRepositoryConnector.getTaskPriority((String)"4", (TracPriority[])priorities).toString());
        TracRepositoryConnectorTest.assertEquals((String)"P4", (String)TracRepositoryConnector.getTaskPriority((String)"5", (TracPriority[])priorities).toString());
        TracRepositoryConnectorTest.assertEquals((String)"P5", (String)TracRepositoryConnector.getTaskPriority((String)"6", (TracPriority[])priorities).toString());
    }

    public void testUpdateTaskFromTaskData() throws Exception {
        TracTicket ticket = new TracTicket(123);
        ticket.putBuiltinValue(TracTicket.Key.DESCRIPTION, "mydescription");
        ticket.putBuiltinValue(TracTicket.Key.PRIORITY, "mypriority");
        ticket.putBuiltinValue(TracTicket.Key.SUMMARY, "mysummary");
        ticket.putBuiltinValue(TracTicket.Key.TYPE, "mytype");
        TracTaskDataHandler taskDataHandler = this.connector.getTaskDataHandler();
        ITracClient client = this.connector.getClientManager().getTracClient(this.repository);
        client.updateAttributes((IProgressMonitor)new NullProgressMonitor(), false);
        TaskData taskData = taskDataHandler.createTaskDataFromTicket(client, this.repository, ticket, null);
        ITask task = TasksUi.getRepositoryModel().createTask(this.repository, taskData.getTaskId());
        this.connector.updateTaskFromTaskData(this.repository, task, taskData);
        TracRepositoryConnectorTest.assertEquals((String)(String.valueOf(this.repository.getRepositoryUrl()) + "/ticket/" + "123"), (String)task.getUrl());
        TracRepositoryConnectorTest.assertEquals((String)"123", (String)task.getTaskKey());
        TracRepositoryConnectorTest.assertEquals((String)"mysummary", (String)task.getSummary());
        TracRepositoryConnectorTest.assertEquals((String)"P3", (String)task.getPriority());
        TracRepositoryConnectorTest.assertEquals((String)"mytype", (String)task.getTaskKind());
    }

    public void testUpdateTaskFromTaskDataSummaryOnly() throws Exception {
        TracTaskDataHandler taskDataHandler = this.connector.getTaskDataHandler();
        ITracClient client = this.connector.getClientManager().getTracClient(this.repository);
        client.updateAttributes((IProgressMonitor)new NullProgressMonitor(), true);
        TracRepositoryConnectorTest.assertEquals((String)client.getAccessMode().name(), (String)this.repository.getVersion());
        TracTicket ticket = new TracTicket(456);
        ticket.putBuiltinValue(TracTicket.Key.SUMMARY, "mysummary");
        TaskData taskData = taskDataHandler.createTaskDataFromTicket(client, this.repository, ticket, null);
        TaskAttribute attribute = taskData.getRoot().getMappedAttribute("task.common.priority");
        if (attribute != null) {
            TracRepositoryConnectorTest.assertEquals((String)"major", (String)attribute.getValue());
        }
        ITask task = TasksUi.getRepositoryModel().createTask(this.repository, taskData.getTaskId());
        task.setPriority("P2");
        this.connector.updateTaskFromTaskData(this.repository, task, taskData);
        TracRepositoryConnectorTest.assertEquals((String)(String.valueOf(this.repository.getRepositoryUrl()) + "/ticket/" + "456"), (String)task.getUrl());
        TracRepositoryConnectorTest.assertEquals((String)"456", (String)task.getTaskKey());
        TracRepositoryConnectorTest.assertEquals((String)"mysummary", (String)task.getSummary());
        if (client.getAccessMode() == ITracClient.Version.TRAC_0_9) {
            TracRepositoryConnectorTest.assertEquals((String)"task", (String)task.getTaskKind());
            TracRepositoryConnectorTest.assertEquals((String)"P2", (String)task.getPriority());
        } else {
            TracRepositoryConnectorTest.assertEquals((String)"Defect", (String)task.getTaskKind());
            TracRepositoryConnectorTest.assertEquals((String)"P3", (String)task.getPriority());
        }
    }

    public void testUpdateTaskFromTaskDataClosed() throws Exception {
        TracTaskDataHandler taskDataHandler = this.connector.getTaskDataHandler();
        ITracClient client = this.connector.getClientManager().getTracClient(this.repository);
        ITask task = TasksUi.getRepositoryModel().createTask(this.repository, "1");
        TracTicket ticket = new TracTicket(123);
        ticket.putBuiltinValue(TracTicket.Key.STATUS, "resolved");
        TaskData taskData = taskDataHandler.createTaskDataFromTicket(client, this.repository, ticket, null);
        this.connector.updateTaskFromTaskData(this.repository, task, taskData);
        TracRepositoryConnectorTest.assertEquals(null, (Object)task.getCompletionDate());
        ticket.putBuiltinValue(TracTicket.Key.STATUS, "closed");
        taskData = taskDataHandler.createTaskDataFromTicket(client, this.repository, ticket, null);
        this.connector.updateTaskFromTaskData(this.repository, task, taskData);
        TracRepositoryConnectorTest.assertEquals((Object)new Date(0L), (Object)task.getCompletionDate());
        ticket.putBuiltinValue(TracTicket.Key.STATUS, "closed");
        ticket.putBuiltinValue(TracTicket.Key.CHANGE_TIME, "123");
        taskData = taskDataHandler.createTaskDataFromTicket(client, this.repository, ticket, null);
        this.connector.updateTaskFromTaskData(this.repository, task, taskData);
        TracRepositoryConnectorTest.assertEquals((Object)new Date(123000L), (Object)task.getCompletionDate());
    }
}

