/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.support;

import java.net.Proxy;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.IProxyProvider;
import org.eclipse.mylyn.commons.net.WebLocation;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.trac.core.TracClientFactory;
import org.eclipse.mylyn.internal.trac.core.TracCorePlugin;
import org.eclipse.mylyn.internal.trac.core.TracRepositoryConnector;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tests.util.TestFixture;
import org.eclipse.mylyn.trac.tests.support.TracTestConstants;
import org.eclipse.mylyn.trac.tests.support.XmlRpcServer;

public class TracFixture
extends TestFixture {
    private static TracFixture current;
    public static XmlRpcServer.TestData data010;
    public static TracFixture TRAC_INVALID;
    public static TracFixture TRAC_0_10_WEB;
    public static TracFixture TRAC_0_10_XML_RPC;
    public static TracFixture TRAC_0_10_XML_RPC_DIGEST_AUTH;
    public static TracFixture TRAC_0_10_XML_RPC_FORM_AUTH;
    public static TracFixture TRAC_0_10_XML_RPC_SSL;
    public static TracFixture TRAC_0_11_WEB;
    public static TracFixture TRAC_0_11_XML_RPC;
    public static TracFixture TRAC_0_12_WEB;
    public static TracFixture TRAC_0_12_XML_RPC;
    public static TracFixture TRAC_TRUNK_WEB;
    public static TracFixture TRAC_TRUNK_XML_RPC;
    public static TracFixture DEFAULT;
    public static final TracFixture[] ALL;
    public static final TracFixture[] MISC;
    private final ITracClient.Version accessMode;
    private final String version;

    static {
        TRAC_INVALID = new TracFixture(ITracClient.Version.TRAC_0_9, TracTestConstants.TEST_TRAC_INVALID_URL, "0.11", "Invalid URL");
        TRAC_0_10_WEB = new TracFixture(ITracClient.Version.TRAC_0_9, TracTestConstants.TEST_TRAC_010_URL, "0.10", "Web");
        TRAC_0_10_XML_RPC = new TracFixture(ITracClient.Version.XML_RPC, TracTestConstants.TEST_TRAC_010_URL, "0.10", "XML-RPC");
        TRAC_0_10_XML_RPC_DIGEST_AUTH = new TracFixture(ITracClient.Version.XML_RPC, TracTestConstants.TEST_TRAC_010_DIGEST_AUTH_URL, "0.10", "XML-RPC/DigestAuth");
        TRAC_0_10_XML_RPC_FORM_AUTH = new TracFixture(ITracClient.Version.XML_RPC, TracTestConstants.TEST_TRAC_010_FORM_AUTH_URL, "0.10", "XML-RPC/FormAuth");
        TRAC_0_10_XML_RPC_SSL = new TracFixture(ITracClient.Version.XML_RPC, TracTestConstants.TEST_TRAC_010_SSL_URL, "0.10", "XML-RPC/SSL");
        TRAC_0_11_WEB = new TracFixture(ITracClient.Version.TRAC_0_9, TracTestConstants.TEST_TRAC_011_URL, "0.11", "Web");
        TRAC_0_11_XML_RPC = new TracFixture(ITracClient.Version.XML_RPC, TracTestConstants.TEST_TRAC_011_URL, "0.11", "XML-RPC");
        TRAC_0_12_WEB = new TracFixture(ITracClient.Version.TRAC_0_9, TracTestConstants.TEST_TRAC_012_URL, "0.12", "Web");
        TRAC_0_12_XML_RPC = new TracFixture(ITracClient.Version.XML_RPC, TracTestConstants.TEST_TRAC_012_URL, "0.12", "XML-RPC");
        TRAC_TRUNK_WEB = new TracFixture(ITracClient.Version.TRAC_0_9, TracTestConstants.TEST_TRAC_TRUNK_URL, "0.12dev-r0", "Web");
        TRAC_TRUNK_XML_RPC = new TracFixture(ITracClient.Version.XML_RPC, TracTestConstants.TEST_TRAC_TRUNK_URL, "0.13dev-r0", "XML-RPC");
        DEFAULT = TRAC_0_12_XML_RPC;
        ALL = new TracFixture[]{TRAC_0_10_WEB, TRAC_0_11_WEB, TRAC_0_12_WEB, TRAC_0_10_XML_RPC, TRAC_0_11_XML_RPC, TRAC_0_12_XML_RPC};
        MISC = new TracFixture[]{TRAC_0_10_XML_RPC_DIGEST_AUTH, TRAC_0_10_XML_RPC_FORM_AUTH};
    }

    public static void cleanup010() throws Exception {
        if (data010 != null) {
            data010 = null;
        }
    }

    public static TracFixture current(TracFixture fixture) {
        if (current == null) {
            fixture.activate();
        }
        return current;
    }

    public static TracFixture current() {
        return TracFixture.current(DEFAULT);
    }

    public static XmlRpcServer.TestData init010() throws Exception {
        if (data010 == null) {
            UserCredentials credentials = CommonTestUtil.getCredentials((CommonTestUtil.PrivilegeLevel)CommonTestUtil.PrivilegeLevel.USER);
            XmlRpcServer server = new XmlRpcServer(TracTestConstants.TEST_TRAC_010_URL, credentials.getUserName(), credentials.getPassword());
            TracFixture.initializeTestData(server);
            data010 = server.getData();
        }
        return data010;
    }

    protected static void initializeTestData(XmlRpcServer server) throws Exception {
        server.ticketMilestone("milestone1").itemCreated();
        server.ticketMilestone("milestone2").itemCreated();
        server.ticketMilestone("milestone3").itemCreated();
        server.ticketMilestone("milestone4").itemCreated();
        server.ticketMilestone("mile&stone").itemCreated();
        server.ticketVersion("1.0").itemCreated();
        server.ticketVersion("2.0").itemCreated();
        server.ticket(1).itemCreated();
        server.ticket(2).itemCreated();
        server.ticket(3).itemCreated();
        server.ticket(4).itemCreated();
        server.ticket(5).itemCreated();
        server.ticket(6).itemCreated();
        server.ticket(7).itemCreated();
        server.ticket(8).itemCreated();
    }

    public TracFixture(ITracClient.Version accessMode, String url, String version, String info) {
        super("trac", url);
        this.accessMode = accessMode;
        this.version = version;
        this.setInfo("Trac", version, info);
    }

    public TracFixture activate() {
        current = this;
        this.setUpFramework();
        return this;
    }

    protected TestFixture getDefault() {
        return DEFAULT;
    }

    public ITracClient connect() throws Exception {
        return this.connect(this.repositoryUrl);
    }

    public ITracClient connect(CommonTestUtil.PrivilegeLevel level) throws Exception {
        return this.connect(this.repositoryUrl, this.getDefaultProxy(this.repositoryUrl), level);
    }

    private Proxy getDefaultProxy(String url) {
        return WebUtil.getProxyForUrl((String)url);
    }

    public ITracClient connect(String url) throws Exception {
        return this.connect(url, this.getDefaultProxy(url), CommonTestUtil.PrivilegeLevel.USER);
    }

    public ITracClient connect(String url, Proxy proxy, CommonTestUtil.PrivilegeLevel level) throws Exception {
        UserCredentials credentials = CommonTestUtil.getCredentials((CommonTestUtil.PrivilegeLevel)level);
        return this.connect(url, credentials.getUserName(), credentials.getPassword(), proxy);
    }

    public ITracClient connect(String url, String username, String password) throws Exception {
        return this.connect(url, username, password, this.getDefaultProxy(url));
    }

    public ITracClient connect(String url, String username, String password, Proxy proxy) throws Exception {
        return this.connect(url, username, password, proxy, this.accessMode);
    }

    public ITracClient connect(String url, String username, String password, final Proxy proxy, ITracClient.Version version) throws Exception {
        WebLocation location = new WebLocation(url, username, password, new IProxyProvider(){

            public Proxy getProxyForHost(String host, String proxyType) {
                return proxy;
            }
        });
        return TracClientFactory.createClient((AbstractWebLocation)location, (ITracClient.Version)version);
    }

    public ITracClient.Version getAccessMode() {
        return this.accessMode;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isXmlRpcEnabled() {
        return true;
    }

    public TaskRepository singleRepository(TracRepositoryConnector connector) {
        connector.getClientManager().writeCache();
        TaskRepository repository = super.singleRepository();
        connector.getClientManager().clearClients();
        connector.getClientManager().readCache();
        return repository;
    }

    public TaskRepository singleRepository() {
        return this.singleRepository(TracCorePlugin.getDefault().getConnector());
    }

    protected void configureRepository(TaskRepository repository) {
        repository.setTimeZoneId("UTC");
        repository.setCharacterEncoding("UTF-8");
        repository.setVersion(this.accessMode.name());
    }

    protected void resetRepositories() {
        TracCorePlugin.getDefault().getConnector().getClientManager().clearClients();
    }
}

