/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskKeyComparator;

public class TaskKeyComparatorTest
extends TestCase {
    private static final TaskKeyComparator tkc = new TaskKeyComparator();

    public void testPatterns() {
        String[] stringArray = new String[3];
        stringArray[2] = "";
        this.comparisonCheck("", stringArray);
        String[] stringArray2 = new String[3];
        stringArray2[2] = " ";
        this.comparisonCheck(" ", stringArray2);
        String[] stringArray3 = new String[3];
        stringArray3[2] = "aa";
        this.comparisonCheck("aa", stringArray3);
        this.comparisonCheck("11", new String[]{"", "11", ""});
        this.comparisonCheck("11 aa", new String[]{"", "11", " aa"});
        String[] stringArray4 = new String[3];
        stringArray4[2] = " 11 aa";
        this.comparisonCheck(" 11 aa", stringArray4);
        this.comparisonCheck("aa11 bb", new String[]{"aa", "11", " bb"});
        this.comparisonCheck("aa-11 bb", new String[]{"aa-", "11", " bb"});
        String[] stringArray5 = new String[3];
        stringArray5[2] = "aa 11 bb";
        this.comparisonCheck("aa 11 bb", stringArray5);
        String[] stringArray6 = new String[3];
        stringArray6[2] = "aa bb 11 cc";
        this.comparisonCheck("aa bb 11 cc", stringArray6);
        this.comparisonCheck("aa", "aa", 0);
        this.comparisonCheck("aa", "bb", -1);
        this.comparisonCheck("bb", "aa", 1);
        this.comparisonCheck("aa11", "aa11", 0);
        this.comparisonCheck("aa11", "aa12", -1);
        this.comparisonCheck("aa12", "aa11", 1);
        this.comparisonCheck("aa1", "aa11", -1);
        this.comparisonCheck("aa1", "aa2", -1);
        this.comparisonCheck("aa1", "aa21", -1);
        this.comparisonCheck("aa1 aaa", "aa1 aaa", 0);
        this.comparisonCheck("aa1 aaa", "aa1 bbb", -1);
        this.comparisonCheck("aa1 bbb", "aa11 aaa", -1);
    }

    private void comparisonCheck(String s, String[] exptecation) {
        Object[] res = new TaskKeyComparator().split(s);
        TaskKeyComparatorTest.assertTrue((String)("Invalid " + Arrays.asList(res) + " " + Arrays.asList(exptecation)), (boolean)Arrays.equals(res, exptecation));
    }

    public void comparisonCheck(String s1, String s2, int n) {
        String[] stringArray = new String[3];
        stringArray[2] = s1;
        String[] c1 = stringArray;
        String[] stringArray2 = new String[3];
        stringArray2[2] = s2;
        String[] c2 = stringArray2;
        TaskKeyComparatorTest.assertEquals((int)n, (int)tkc.compare(c1, c2));
    }
}

