/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.core;

import java.io.File;
import java.io.Serializable;
import junit.framework.TestCase;
import org.eclipse.mylyn.tasks.core.RepositoryClientManager;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class RepositoryClientManagerTest
extends TestCase {
    public void testClassloadingSerialize() throws Exception {
        File cacheFile = File.createTempFile("config", "");
        cacheFile.delete();
        MockRepositoryClientManager manager = new MockRepositoryClientManager(cacheFile);
        TaskRepository repository = new TaskRepository("kind", "url");
        manager.getClient(repository);
        manager.writeCache();
        RepositoryClientManagerTest.assertNull((Object)manager.getThrowable());
        manager.readCache();
        RepositoryClientManagerTest.assertNull((Object)manager.getThrowable());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MockRepositoryClientManager
    extends RepositoryClientManager<Object, MyConfig> {
        private Throwable throwable;

        public MockRepositoryClientManager(File cacheFile) {
            super(cacheFile, MyConfig.class);
        }

        protected Object createClient(TaskRepository taskRepository, MyConfig data) {
            return new Object();
        }

        protected void handleError(String message, Throwable e) {
            this.throwable = e;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }

    public static class MyConfig
    implements Serializable {
        private static final long serialVersionUID = 5105526708474366441L;
        public String someString = "mylyn";
        public TaskRepository repository = null;
    }
}

