/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core;

import com.google.gerrit.common.data.ChangeInfo;
import com.google.gwtorm.client.KeyUtil;
import com.google.gwtorm.server.StandardKeyEncoder;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.gerrit.core.GerritCorePlugin;
import org.eclipse.mylyn.internal.gerrit.core.GerritTaskDataHandler;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritAuthenticationState;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritConfiguration;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritHttpException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritLoginException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritSystemInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.JSonSupport;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;
import org.eclipse.osgi.util.NLS;

public class GerritConnector
extends AbstractRepositoryConnector {
    static Logger logger = Logger.getLogger("com.google.gson.ParameterizedTypeHandlerMap");
    public static final String CHANGE_PREFIX = "/#change,";
    public static final String CONNECTOR_KIND = "org.eclipse.mylyn.gerrit";
    public static final String CONNECTOR_LABEL = "Gerrit Code Review";
    public static final String KEY_REPOSITORY_CONFIG = "org.eclipse.mylyn.gerrit.config";
    public static final String KEY_REPOSITORY_AUTH = "org.eclipse.mylyn.gerrit.auth";
    public static final String KEY_REPOSITORY_ACCOUNT_ID = "org.eclipse.mylyn.gerrit.accountId";
    public static final String KEY_REPOSITORY_OPEN_ID_ENABLED = "org.eclipse.mylyn.gerrit.openId.enabled";
    public static final String KEY_REPOSITORY_OPEN_ID_PROVIDER = "org.eclipse.mylyn.gerrit.openId.provider";
    private final GerritTaskDataHandler taskDataHandler = new GerritTaskDataHandler(this);
    private TaskRepositoryLocationFactory taskRepositoryLocationFactory = new TaskRepositoryLocationFactory();
    private final ConcurrentMap<TaskRepository, GerritConfiguration> configurationCache = new ConcurrentHashMap<TaskRepository, GerritConfiguration>();

    static {
        KeyUtil.setEncoderImpl((KeyUtil.Encoder)new StandardKeyEncoder());
        logger.setLevel(Level.OFF);
    }

    public GerritConnector() {
        if (GerritCorePlugin.getDefault() != null) {
            GerritCorePlugin.getDefault().setConnector(this);
        }
    }

    public boolean canCreateNewTask(TaskRepository arg0) {
        return false;
    }

    public boolean canCreateTaskFromKey(TaskRepository arg0) {
        return true;
    }

    public GerritClient getClient(TaskRepository repository) {
        return this.createClient(repository, true);
    }

    public String getConnectorKind() {
        return CONNECTOR_KIND;
    }

    public String getLabel() {
        return "Gerrit Code Review (supports 2.3 and later)";
    }

    public TaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        return this.taskDataHandler.getTaskData(repository, taskId, monitor);
    }

    public AbstractTaskDataHandler getTaskDataHandler() {
        return this.taskDataHandler;
    }

    public String getRepositoryUrlFromTaskUrl(String url) {
        if (url == null) {
            return null;
        }
        int i = url.indexOf(CHANGE_PREFIX);
        if (i != -1) {
            return url.substring(0, i);
        }
        return null;
    }

    public String getTaskIdFromTaskUrl(String url) {
        if (url == null) {
            return null;
        }
        int index = url.indexOf(CHANGE_PREFIX);
        if (index > 0) {
            return url.substring(index + CHANGE_PREFIX.length());
        }
        return null;
    }

    public ITaskMapping getTaskMapping(TaskData taskData) {
        return new TaskMapper(taskData);
    }

    public synchronized TaskRepositoryLocationFactory getTaskRepositoryLocationFactory() {
        return this.taskRepositoryLocationFactory;
    }

    public String getTaskUrl(String repositoryUrl, String taskId) {
        return String.valueOf(repositoryUrl) + CHANGE_PREFIX + taskId;
    }

    public boolean hasTaskChanged(TaskRepository repository, ITask task, TaskData taskData) {
        ITaskMapping taskMapping = this.getTaskMapping(taskData);
        Date repositoryDate = taskMapping.getModificationDate();
        Date localDate = task.getModificationDate();
        return repositoryDate == null || !repositoryDate.equals(localDate);
    }

    public IStatus performQuery(TaskRepository repository, IRepositoryQuery query, TaskDataCollector resultCollector, ISynchronizationSession session, IProgressMonitor monitor) {
        try {
            monitor.beginTask("Executing query", -1);
            GerritClient client = this.getClient(repository);
            client.refreshConfigOnce(monitor);
            List<ChangeInfo> result = null;
            if ("all open changes".equals(query.getAttribute("gerrit query type"))) {
                result = client.queryAllReviews(monitor);
            } else if ("custom".equals(query.getAttribute("gerrit query type"))) {
                String queryString = query.getAttribute("gerrit query string");
                result = client.executeQuery(monitor, queryString);
            } else if ("my changes".equals(query.getAttribute("gerrit query type"))) {
                result = client.queryMyReviews(monitor);
            } else if ("my watched changes".equals(query.getAttribute("gerrit query type"))) {
                result = client.queryWatchedReviews(monitor);
            } else if ("open changes by project".equals(query.getAttribute("gerrit query type"))) {
                String project = query.getAttribute("gerrit query project");
                result = client.queryByProject(monitor, project);
            }
            if (result != null) {
                for (ChangeInfo changeInfo : result) {
                    TaskData taskData = this.taskDataHandler.createPartialTaskData(repository, "" + changeInfo.getId(), monitor);
                    taskData.setPartial(true);
                    this.taskDataHandler.updateTaskData(repository, taskData, changeInfo);
                    resultCollector.accept(taskData);
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            Status status = new Status(4, "org.eclipse.mylyn.gerrit.core", NLS.bind((String)"Unknows query type: {0}", (Object)query.getAttribute("gerrit query project")));
            return status;
        }
        catch (UnsupportedClassVersionError e) {
            Status status = this.toStatus(repository, e);
            return status;
        }
        catch (GerritException e) {
            Status status = this.toStatus(repository, e);
            return status;
        }
        finally {
            monitor.done();
        }
    }

    public synchronized void setTaskRepositoryLocationFactory(TaskRepositoryLocationFactory taskRepositoryLocationFactory) {
        this.taskRepositoryLocationFactory = taskRepositoryLocationFactory;
    }

    public void updateRepositoryConfiguration(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        try {
            this.getClient(repository).refreshConfig(monitor);
        }
        catch (GerritException e) {
            throw this.toCoreException(repository, e);
        }
    }

    public void updateTaskFromTaskData(TaskRepository taskRepository, ITask task, TaskData taskData) {
        TaskMapper mapper = (TaskMapper)this.getTaskMapping(taskData);
        mapper.applyTo(task);
        String key = task.getTaskKey();
        if (key != null) {
            task.setSummary(NLS.bind((String)"{0} [{1}]", (Object)mapper.getSummary(), (Object)key));
            task.setTaskKey(task.getTaskId());
        }
    }

    public GerritSystemInfo validate(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        try {
            if (!Boolean.parseBoolean(repository.getProperty(KEY_REPOSITORY_OPEN_ID_ENABLED))) {
                monitor = Policy.backgroundMonitorFor((IProgressMonitor)monitor);
            }
            return this.createClient(repository, false).getInfo(monitor);
        }
        catch (UnsupportedClassVersionError e) {
            throw this.toCoreException(repository, e);
        }
        catch (GerritException e) {
            throw this.toCoreException(repository, e);
        }
    }

    private GerritClient createClient(final TaskRepository repository, boolean cachedConfig) {
        GerritConfiguration config = cachedConfig ? this.loadConfiguration(repository) : null;
        GerritAuthenticationState authState = cachedConfig ? GerritClient.authStateFromString(repository.getProperty(KEY_REPOSITORY_AUTH)) : null;
        return new GerritClient(this.taskRepositoryLocationFactory.createWebLocation(repository), config, authState){

            @Override
            protected void configurationChanged(GerritConfiguration config) {
                GerritConnector.this.saveConfiguration(repository, config);
            }

            @Override
            protected void authStateChanged(GerritAuthenticationState authState) {
                repository.setProperty(GerritConnector.KEY_REPOSITORY_AUTH, GerritClient.authStateToString(authState));
            }
        };
    }

    protected GerritConfiguration loadConfiguration(TaskRepository repository) {
        GerritConfiguration configuration = (GerritConfiguration)this.configurationCache.get(repository);
        if (configuration == null && (configuration = GerritConnector.configurationFromString(repository.getProperty(KEY_REPOSITORY_CONFIG))) != null) {
            this.configurationCache.put(repository, configuration);
        }
        return configuration;
    }

    protected void saveConfiguration(TaskRepository repository, GerritConfiguration configuration) {
        this.configurationCache.put(repository, configuration);
        repository.setProperty(KEY_REPOSITORY_CONFIG, GerritConnector.configurationToString(configuration));
    }

    public GerritConfiguration getConfiguration(TaskRepository repository) {
        GerritConfiguration configuration = (GerritConfiguration)this.configurationCache.get(repository);
        if (configuration == null) {
            configuration = this.loadConfiguration(repository);
        }
        return configuration;
    }

    private static GerritConfiguration configurationFromString(String token) {
        try {
            JSonSupport support = new JSonSupport();
            return (GerritConfiguration)support.getGson().fromJson(token, GerritConfiguration.class);
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.gerrit.core", "Failed to deserialize configuration: '" + token + "'", (Throwable)e));
            return null;
        }
    }

    private static String configurationToString(GerritConfiguration config) {
        try {
            JSonSupport support = new JSonSupport();
            return support.getGson().toJson((Object)config);
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.gerrit.core", "Failed to serialize configuration", (Throwable)e));
            return null;
        }
    }

    CoreException toCoreException(TaskRepository repository, GerritException e) {
        return new CoreException((IStatus)this.toStatus(repository, e));
    }

    CoreException toCoreException(TaskRepository repository, UnsupportedClassVersionError e) {
        return new CoreException((IStatus)this.toStatus(repository, e));
    }

    Status toStatus(TaskRepository repository, GerritException e) {
        String message;
        if (e instanceof GerritHttpException) {
            int code = ((GerritHttpException)e).getResponseCode();
            message = NLS.bind((String)"Unexpected error: {1} ({0})", (Object)code, (Object)HttpStatus.getStatusText((int)code));
        } else {
            message = e instanceof GerritLoginException ? "Login failed" : (e.getMessage() != null ? NLS.bind((String)"Unexpected error: {0}", (Object)e.getMessage()) : "Unexpected error while communicating with Gerrit");
        }
        return new Status(4, "org.eclipse.mylyn.gerrit.core", message, (Throwable)e);
    }

    Status toStatus(TaskRepository repository, UnsupportedClassVersionError e) {
        String message = NLS.bind((String)"The Gerrit Connector requires at Java 1.6 or higer (installed version: {0})", (Object)System.getProperty("java.version"));
        return new Status(4, "org.eclipse.mylyn.gerrit.core", message, (Throwable)e);
    }
}

