/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core;

import com.google.gerrit.common.data.AccountInfo;
import com.google.gerrit.common.data.AccountInfoCache;
import com.google.gerrit.common.data.ChangeDetail;
import com.google.gerrit.common.data.CommentDetail;
import com.google.gerrit.common.data.GerritConfig;
import com.google.gerrit.common.data.PatchScript;
import com.google.gerrit.prettify.common.SparseFileContent;
import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.AccountGeneralPreferences;
import com.google.gerrit.reviewdb.Patch;
import com.google.gerrit.reviewdb.PatchLineComment;
import com.google.gerrit.reviewdb.PatchSet;
import com.google.gerrit.reviewdb.Project;
import com.google.gerrit.reviewdb.UserIdentity;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.gerrit.core.GerritTaskSchema;
import org.eclipse.mylyn.internal.gerrit.core.ReviewItemCache;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritChange;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritConfiguration;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritPatchSetContent;
import org.eclipse.mylyn.internal.gerrit.core.client.JSonSupport;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ProjectDetailX;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IFileRevision;
import org.eclipse.mylyn.reviews.core.model.ILineLocation;
import org.eclipse.mylyn.reviews.core.model.ILineRange;
import org.eclipse.mylyn.reviews.core.model.ILocation;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.core.model.ITopic;
import org.eclipse.mylyn.reviews.core.model.IUser;
import org.eclipse.mylyn.reviews.internal.core.model.ReviewsFactory;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.osgi.util.NLS;

public class GerritUtil {
    private static final ReviewsFactory FACTORY = ReviewsFactory.eINSTANCE;

    public static GerritChange getChange(TaskData taskData) {
        JSonSupport json = new JSonSupport();
        TaskAttribute attribute = taskData.getRoot().getAttribute(GerritTaskSchema.getDefault().OBJ_REVIEW.getKey());
        if (attribute != null) {
            return (GerritChange)json.getGson().fromJson(attribute.getValue(), GerritChange.class);
        }
        return null;
    }

    public static IReview toReview(ChangeDetail detail) throws GerritException {
        IReview review = FACTORY.createReview();
        review.setId(String.valueOf(detail.getChange().getId().get()));
        List patchSets = detail.getPatchSets();
        for (PatchSet patchSet : patchSets) {
            IReviewItemSet itemSet = GerritUtil.toReviewItemSet(detail, null, patchSet);
            itemSet.setReview(review);
            review.getItems().add(itemSet);
        }
        return review;
    }

    public static IReviewItemSet toReviewItemSet(ChangeDetail detail, PatchSet base, PatchSet patchSet) {
        IReviewItemSet itemSet = FACTORY.createReviewItemSet();
        if (base == null) {
            itemSet.setName(NLS.bind((String)"Patch Set {0}", (Object)patchSet.getPatchSetId()));
        } else {
            itemSet.setName(NLS.bind((String)"Compare Patch Set {0} and {1}", (Object)patchSet.getPatchSetId(), (Object)base.getPatchSetId()));
        }
        itemSet.setId(String.valueOf(patchSet.getPatchSetId()));
        itemSet.setAddedBy(GerritUtil.createUser(patchSet.getUploader(), detail.getAccounts()));
        itemSet.setRevision(patchSet.getRevision().get());
        return itemSet;
    }

    public static List<IReviewItem> toReviewItems(GerritPatchSetContent content, ReviewItemCache cache) {
        ArrayList<IReviewItem> items = new ArrayList<IReviewItem>();
        for (Patch patch : content.getTarget().getPatches()) {
            PatchScript patchScript;
            String targetId = patch.getKey().toString();
            String sourceFileName = patch.getSourceFileName() != null ? patch.getSourceFileName() : patch.getFileName();
            String baseId = content.getBase() != null ? new Patch.Key(content.getBase().getId(), sourceFileName).toString() : "base-" + targetId;
            String id = String.valueOf(baseId) + ":" + targetId;
            IFileItem item = (IFileItem)cache.getItem(id);
            if (item == null) {
                item = FACTORY.createFileItem();
                item.setId(id);
                item.setName(patch.getFileName());
                cache.put((IReviewItem)item);
            }
            items.add((IReviewItem)item);
            if (content.getPatchScriptByPatchKey() == null || (patchScript = content.getPatchScriptByPatchKey().get(patch.getKey())) == null) continue;
            CommentDetail commentDetail = patchScript.getCommentDetail();
            IFileRevision revisionA = (IFileRevision)cache.getItem(baseId);
            if (revisionA == null) {
                revisionA = FACTORY.createFileRevision();
                revisionA.setId(baseId);
                revisionA.setContent(patchScript.getA().asString());
                revisionA.setPath(patchScript.getA().getPath());
                revisionA.setRevision(content.getBase() != null ? NLS.bind((String)"Patch Set {0}", (Object)content.getBase().getPatchSetId()) : "Base");
                GerritUtil.addComments(revisionA, commentDetail.getCommentsA(), commentDetail.getAccounts());
                cache.put((IReviewItem)revisionA);
            }
            item.setBase(revisionA);
            IFileRevision revisionB = (IFileRevision)cache.getItem(targetId);
            if (revisionB == null) {
                revisionB = FACTORY.createFileRevision();
                revisionB.setId(targetId);
                SparseFileContent target = patchScript.getB().apply(patchScript.getA(), patchScript.getEdits());
                revisionB.setContent(target.asString());
                revisionB.setPath(patchScript.getB().getPath());
                revisionB.setRevision(NLS.bind((String)"Patch Set {0}", (Object)content.getTarget().getPatchSet().getPatchSetId()));
                GerritUtil.addComments(revisionB, commentDetail.getCommentsB(), commentDetail.getAccounts());
                cache.put((IReviewItem)revisionB);
            }
            item.setTarget(revisionB);
        }
        return items;
    }

    private static void addComments(IFileRevision revision, List<PatchLineComment> comments, AccountInfoCache accountInfoCache) {
        if (comments == null || comments.isEmpty()) {
            return;
        }
        for (PatchLineComment comment : comments) {
            ILineRange line = FACTORY.createLineRange();
            line.setStart(comment.getLine());
            line.setEnd(comment.getLine());
            ILineLocation location = FACTORY.createLineLocation();
            location.getRanges().add(line);
            IUser author = GerritUtil.createUser(comment.getAuthor(), accountInfoCache);
            IComment topicComment = FACTORY.createComment();
            topicComment.setAuthor(author);
            topicComment.setCreationDate((Date)comment.getWrittenOn());
            topicComment.setDescription(comment.getMessage());
            ITopic topic = FACTORY.createTopic();
            topic.setId(comment.getKey().get());
            topic.setAuthor(author);
            topic.setCreationDate((Date)comment.getWrittenOn());
            topic.setLocation((ILocation)location);
            topic.setItem((IReviewItem)revision);
            topic.setDraft(PatchLineComment.Status.DRAFT == comment.getStatus());
            topic.setDescription(comment.getMessage());
            topic.setTitle(GerritUtil.shortenText(comment.getMessage(), 10, 20));
            topic.getComments().add(topicComment);
            revision.getTopics().add(topic);
        }
    }

    public static IUser createUser(Account.Id id, AccountInfoCache accountInfoCache) {
        AccountInfo info = accountInfoCache.get(id);
        IUser user = FACTORY.createUser();
        user.setDisplayName(GerritUtil.getUserLabel(info));
        user.setId(Integer.toString(id.get()));
        return user;
    }

    public static String getUserLabel(AccountInfo user) {
        if (user == null) {
            return "Anonymous";
        }
        if (user.getFullName() != null) {
            return user.getFullName();
        }
        if (user.getPreferredEmail() != null) {
            String email = user.getPreferredEmail();
            int i = email.indexOf("@");
            return i > 0 ? email.substring(0, i) : email;
        }
        return "<Unknown>";
    }

    public static String getUserLabel(UserIdentity user) {
        StringBuilder sb = new StringBuilder();
        sb.append(user.getName());
        if (user.getEmail() != null) {
            sb.append(" <");
            sb.append(user.getEmail());
            sb.append(">");
        }
        return sb.toString();
    }

    public static boolean isPermissionOnlyProject(ProjectDetailX projectDetail, GerritConfig config) {
        if (projectDetail.isPermissionOnly) {
            return true;
        }
        return projectDetail.project.getName().equals(config.getWildProject().get());
    }

    public static String shortenText(String t, int minChars, int maxChars) {
        Assert.isTrue((minChars >= 0 ? 1 : 0) != 0);
        Assert.isTrue((maxChars >= 0 ? 1 : 0) != 0);
        Assert.isTrue((minChars <= maxChars ? 1 : 0) != 0);
        if (t.length() < maxChars) {
            return t;
        }
        int i = maxChars - 1;
        while (i >= minChars) {
            if (Character.isWhitespace(t.charAt(i))) {
                return NLS.bind((String)"{0}...", (Object)t.substring(0, i));
            }
            --i;
        }
        return NLS.bind((String)"{0}...", (Object)t.substring(0, minChars));
    }

    public static IReviewItemSet createInput(ChangeDetail changeDetail, GerritPatchSetContent content, ReviewItemCache cache) {
        IReviewItemSet itemSet = GerritUtil.toReviewItemSet(changeDetail, content.getBase(), content.getTarget().getPatchSet());
        List<IReviewItem> items = GerritUtil.toReviewItems(content, cache);
        itemSet.getItems().addAll(items);
        return itemSet;
    }

    public static String getSshCloneUri(TaskRepository repository, GerritConfiguration config, Project project) throws URISyntaxException {
        Set supportedDownloadSchemes = config.getGerritConfig().getDownloadSchemes();
        if (supportedDownloadSchemes.contains(AccountGeneralPreferences.DownloadScheme.SSH) || supportedDownloadSchemes.contains(AccountGeneralPreferences.DownloadScheme.DEFAULT_DOWNLOADS)) {
            String user;
            String sshAddress = config.getGerritConfig().getSshdAddress();
            Account account = config.getAccount();
            StringBuilder sb = new StringBuilder();
            sb.append("ssh://");
            if (account != null && (user = account.getUserName()) != null && !user.equals("")) {
                sb.append(user);
                sb.append("@");
            }
            if (sshAddress.startsWith("*:") || "".equals(sshAddress)) {
                sb.append(new URI(repository.getRepositoryUrl()).getHost());
            }
            if (sshAddress.startsWith("*:")) {
                sb.append(sshAddress.substring(1));
            } else {
                sb.append(sshAddress);
            }
            sb.append("/");
            sb.append(project.getName());
            return sb.toString();
        }
        return null;
    }

    public static String getHttpCloneUri(TaskRepository repository, GerritConfiguration config, Project project) {
        Set supportedDownloadSchemes = config.getGerritConfig().getDownloadSchemes();
        if (supportedDownloadSchemes.contains(AccountGeneralPreferences.DownloadScheme.HTTP) || supportedDownloadSchemes.contains(AccountGeneralPreferences.DownloadScheme.DEFAULT_DOWNLOADS)) {
            String user;
            Account account = config.getAccount();
            StringBuilder sb = new StringBuilder();
            String httpAddress = config.getGerritConfig().getGitHttpUrl() != null ? config.getGerritConfig().getGitHttpUrl() : repository.getUrl();
            int schemeEndIndex = httpAddress.indexOf("://") + 3;
            sb.append(httpAddress.substring(0, schemeEndIndex));
            if (!httpAddress.contains("@") && account != null && (user = account.getUserName()) != null && !user.equals("")) {
                sb.append(user);
                sb.append('@');
            }
            sb.append(httpAddress.substring(schemeEndIndex));
            if (!httpAddress.substring(schemeEndIndex).endsWith("/")) {
                sb.append("/");
            }
            sb.append("p/");
            sb.append(project.getName());
            return sb.toString();
        }
        return null;
    }

    public static String getAnonHttpCloneUri(TaskRepository repository, GerritConfiguration config, Project project) {
        Set supportedDownloadSchemes = config.getGerritConfig().getDownloadSchemes();
        if (supportedDownloadSchemes.contains(AccountGeneralPreferences.DownloadScheme.ANON_HTTP) || supportedDownloadSchemes.contains(AccountGeneralPreferences.DownloadScheme.DEFAULT_DOWNLOADS)) {
            StringBuilder sb = new StringBuilder();
            String httpAddress = config.getGerritConfig().getGitHttpUrl() != null ? config.getGerritConfig().getGitHttpUrl() : repository.getUrl();
            sb.append(httpAddress);
            if (!httpAddress.endsWith("/")) {
                sb.append("/");
            }
            sb.append("p/");
            sb.append(project.getName());
            return sb.toString();
        }
        return null;
    }

    public static String getAnonGitCloneUri(TaskRepository repository, GerritConfiguration config, Project project) {
        Set supportedDownloadSchemes = config.getGerritConfig().getDownloadSchemes();
        String gitAddress = config.getGerritConfig().getGitDaemonUrl();
        if (gitAddress != null && (supportedDownloadSchemes.contains(AccountGeneralPreferences.DownloadScheme.ANON_GIT) || supportedDownloadSchemes.contains(AccountGeneralPreferences.DownloadScheme.DEFAULT_DOWNLOADS))) {
            StringBuilder sb = new StringBuilder();
            sb.append(gitAddress);
            if (!gitAddress.endsWith("/")) {
                sb.append("/");
            }
            sb.append(project.getName());
            return sb.toString();
        }
        return null;
    }

    public static HashMap<AccountGeneralPreferences.DownloadScheme, String> getCloneUris(GerritConfiguration config, TaskRepository repository, Project project) throws URISyntaxException {
        boolean isAuthenticated = config.getAccount() != null;
        HashMap<AccountGeneralPreferences.DownloadScheme, String> uriMap = new HashMap<AccountGeneralPreferences.DownloadScheme, String>();
        if (isAuthenticated) {
            uriMap.put(AccountGeneralPreferences.DownloadScheme.SSH, GerritUtil.getSshCloneUri(repository, config, project));
            uriMap.put(AccountGeneralPreferences.DownloadScheme.HTTP, GerritUtil.getHttpCloneUri(repository, config, project));
        }
        uriMap.put(AccountGeneralPreferences.DownloadScheme.ANON_HTTP, GerritUtil.getAnonHttpCloneUri(repository, config, project));
        uriMap.put(AccountGeneralPreferences.DownloadScheme.ANON_GIT, GerritUtil.getAnonGitCloneUri(repository, config, project));
        return uriMap;
    }
}

