/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.mylyn.bugzilla.tests.support.BugzillaFixture;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;

public class BugzillaCustomFieldsTest
extends TestCase {
    private BugzillaClient client;
    private TaskRepository repository;
    private TaskData fruitTaskData;

    protected void setUp() throws Exception {
        this.repository = BugzillaFixture.current().repository();
        this.client = BugzillaFixture.current().client();
    }

    public void testCustomAttributes() throws Exception {
        String taskNumber = "2";
        TaskData taskData = BugzillaFixture.current().getTask(taskNumber, this.client);
        BugzillaCustomFieldsTest.assertNotNull((Object)taskData);
        TaskMapper mapper = new TaskMapper(taskData);
        BugzillaCustomFieldsTest.assertEquals((String)taskNumber, (String)taskData.getTaskId());
        AuthenticationCredentials credentials = this.repository.getCredentials(AuthenticationType.REPOSITORY);
        BugzillaCustomFieldsTest.assertNotNull((String)"credentials are null", (Object)credentials);
        BugzillaCustomFieldsTest.assertNotNull((String)"Repositor User not set", (Object)credentials.getUserName());
        BugzillaCustomFieldsTest.assertNotNull((String)"no password for Repository", (Object)credentials.getPassword());
        TaskAttribute colorAttribute = mapper.getTaskData().getRoot().getAttribute("cf_multiselect");
        BugzillaCustomFieldsTest.assertNotNull((String)"TaskAttribute Color did not exists", (Object)colorAttribute);
        List theColors = colorAttribute.getValues();
        BugzillaCustomFieldsTest.assertNotNull((Object)theColors);
        BugzillaCustomFieldsTest.assertFalse((String)"no colors set", (boolean)theColors.isEmpty());
        boolean red = false;
        boolean green = false;
        boolean yellow = false;
        boolean blue = false;
        for (Object element : theColors) {
            String string = (String)element;
            if (!red && string.compareTo("Red") == 0) {
                red = true;
                continue;
            }
            if (!green && string.compareTo("Green") == 0) {
                green = true;
                continue;
            }
            if (!yellow && string.compareTo("Yellow") == 0) {
                yellow = true;
                continue;
            }
            if (blue || string.compareTo("Blue") != 0) continue;
            blue = true;
        }
        this.changeCollorAndSubmit(taskData, colorAttribute, red, green, yellow, blue);
        taskData = BugzillaFixture.current().getTask(taskNumber, this.client);
        BugzillaCustomFieldsTest.assertNotNull((Object)taskData);
        mapper = new TaskMapper(taskData);
        colorAttribute = mapper.getTaskData().getRoot().getAttribute("cf_multiselect");
        BugzillaCustomFieldsTest.assertNotNull((String)"TaskAttribute Color did not exists", (Object)colorAttribute);
        theColors = colorAttribute.getValues();
        BugzillaCustomFieldsTest.assertNotNull((Object)theColors);
        BugzillaCustomFieldsTest.assertFalse((String)"no colors set", (boolean)theColors.isEmpty());
        boolean red_new = false;
        boolean green_new = false;
        boolean yellow_new = false;
        boolean blue_new = false;
        for (Object element : theColors) {
            String string = (String)element;
            if (!red_new && string.compareTo("Red") == 0) {
                red_new = true;
                continue;
            }
            if (!green_new && string.compareTo("Green") == 0) {
                green_new = true;
                continue;
            }
            if (!yellow_new && string.compareTo("Yellow") == 0) {
                yellow_new = true;
                continue;
            }
            if (blue_new || string.compareTo("Blue") != 0) continue;
            blue_new = true;
        }
        BugzillaCustomFieldsTest.assertTrue((String)"wrong change", (!red && green && !yellow && !blue && red_new && green_new && !yellow_new && !blue_new || red && green && !yellow && !blue && !red_new && green_new && !yellow_new && !blue_new ? 1 : 0) != 0);
        this.changeCollorAndSubmit(taskData, colorAttribute, red_new, green_new, yellow_new, blue_new);
    }

    private void changeCollorAndSubmit(TaskData taskData, TaskAttribute colorAttribute, boolean red, boolean green, boolean yellow, boolean blue) throws Exception {
        if (!red && green && !yellow && !blue) {
            ArrayList<String> newValue = new ArrayList<String>(2);
            newValue.add("Red");
            newValue.add("Green");
            colorAttribute.setValues(newValue);
            HashSet<TaskAttribute> changed = new HashSet<TaskAttribute>();
            changed.add(colorAttribute);
            BugzillaFixture.current().submitTask(taskData, this.client);
        } else if (red && green && !yellow && !blue) {
            ArrayList<String> newValue = new ArrayList<String>(2);
            newValue.add("Green");
            colorAttribute.setValues(newValue);
            HashSet<TaskAttribute> changed = new HashSet<TaskAttribute>();
            changed.add(colorAttribute);
            BugzillaFixture.current().submitTask(taskData, this.client);
        }
    }

    public void testCustomAttributesNewTask() throws Exception {
        BugzillaVersion version = new BugzillaVersion(BugzillaFixture.current().getVersion());
        if (version.isSmallerOrEquals(BugzillaVersion.BUGZILLA_3_2)) {
            return;
        }
        TaskData taskData = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, null, null);
        BugzillaCustomFieldsTest.assertNotNull((Object)taskData);
        BugzillaCustomFieldsTest.assertNotNull((Object)taskData.getRoot().getAttribute("token"));
        TaskAttribute productAttribute = taskData.getRoot().getAttribute(BugzillaAttribute.PRODUCT.getKey());
        BugzillaCustomFieldsTest.assertNotNull((Object)productAttribute);
        BugzillaCustomFieldsTest.assertEquals((String)"ManualTest", (String)productAttribute.getValue());
        TaskAttribute cfAttribute1 = taskData.getRoot().getAttribute("cf_freetext");
        BugzillaCustomFieldsTest.assertNotNull((Object)cfAttribute1);
        TaskAttribute cfAttribute2 = taskData.getRoot().getAttribute("cf_dropdown");
        BugzillaCustomFieldsTest.assertNotNull((Object)cfAttribute2);
        TaskAttribute cfAttribute3 = taskData.getRoot().getAttribute("cf_largetextbox");
        BugzillaCustomFieldsTest.assertNotNull((Object)cfAttribute3);
        TaskAttribute cfAttribute4 = taskData.getRoot().getAttribute("cf_multiselect");
        BugzillaCustomFieldsTest.assertNotNull((Object)cfAttribute4);
        TaskAttribute cfAttribute5 = taskData.getRoot().getAttribute("cf_datetime");
        BugzillaCustomFieldsTest.assertNotNull((Object)cfAttribute5);
        TaskAttribute cfAttribute6 = taskData.getRoot().getAttribute("cf_bugid");
        BugzillaCustomFieldsTest.assertNotNull((Object)cfAttribute6);
    }

    public void testCustomFields() throws Exception {
        String taskNumber = "1";
        this.fruitTaskData = BugzillaFixture.current().getTask(taskNumber, this.client);
        BugzillaCustomFieldsTest.assertNotNull((Object)this.fruitTaskData);
        if (this.fruitTaskData.getRoot().getAttribute("cf_dropdown").getValue().equals("---")) {
            this.setFruitValueTo("one");
            this.setFruitValueTo("two");
            this.setFruitValueTo("---");
        } else if (this.fruitTaskData.getRoot().getAttribute("cf_dropdown").getValue().equals("one")) {
            this.setFruitValueTo("two");
            this.setFruitValueTo("one");
            this.setFruitValueTo("---");
        } else if (this.fruitTaskData.getRoot().getAttribute("cf_dropdown").getValue().equals("two")) {
            this.setFruitValueTo("one");
            this.setFruitValueTo("two");
            this.setFruitValueTo("---");
        }
        if (this.fruitTaskData != null) {
            this.fruitTaskData = null;
        }
    }

    private void setFruitValueTo(String newValue) throws Exception {
        HashSet<TaskAttribute> changed = new HashSet<TaskAttribute>();
        TaskAttribute cf_fruit = this.fruitTaskData.getRoot().getAttribute("cf_dropdown");
        cf_fruit.setValue(newValue);
        BugzillaCustomFieldsTest.assertEquals((String)newValue, (String)this.fruitTaskData.getRoot().getAttribute("cf_dropdown").getValue());
        changed.add(cf_fruit);
        BugzillaFixture.current().submitTask(this.fruitTaskData, this.client);
        this.fruitTaskData = BugzillaFixture.current().getTask(this.fruitTaskData.getTaskId(), this.client);
        BugzillaCustomFieldsTest.assertEquals((String)newValue, (String)this.fruitTaskData.getRoot().getAttribute("cf_dropdown").getValue());
    }
}

