/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.hudson.core;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.builds.core.IBuildFactory;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.core.spi.BuildConnector;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.internal.hudson.core.HudsonServerBehaviour;
import org.eclipse.mylyn.internal.hudson.core.client.HudsonConfigurationCache;
import org.osgi.framework.Bundle;

public class HudsonConnector
extends BuildConnector {
    private final HudsonConfigurationCache cache;

    protected static File getCacheFile() {
        Bundle bundle;
        if (Platform.isRunning() && (bundle = Platform.getBundle((String)"org.eclipse.mylyn.hudson.core")) != null) {
            IPath stateLocation = Platform.getStateLocation((Bundle)bundle);
            IPath cacheFile = stateLocation.append("configuration.obj");
            return cacheFile.toFile();
        }
        return null;
    }

    public HudsonConnector() {
        this(HudsonConnector.getCacheFile());
    }

    public HudsonConnector(File cacheFile) {
        this.cache = new HudsonConfigurationCache(cacheFile);
    }

    public HudsonServerBehaviour getBehaviour(RepositoryLocation location) throws CoreException {
        return new HudsonServerBehaviour(location, this.cache);
    }

    public IBuildElement getBuildElementFromUrl(IBuildServer server, String url) {
        if (url.startsWith(server.getUrl())) {
            url.substring(server.getUrl().length());
            Pattern p = Pattern.compile(".*/job/(.*)/(\\d+)");
            Matcher matcher = p.matcher(url);
            if (matcher.find()) {
                IBuildPlan plan = IBuildFactory.INSTANCE.createBuildPlan();
                plan.setServer(server);
                plan.setName(matcher.group(1));
                plan.setId(matcher.group(1));
                IBuild build = IBuildFactory.INSTANCE.createBuild();
                build.setId(matcher.group(2));
                build.setLabel(matcher.group(2));
                build.setPlan(plan);
                return build;
            }
        }
        return null;
    }
}

