/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.hudson.core.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.builds.core.spi.AbstractConfigurationCache;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpClient;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpResponse;
import org.eclipse.mylyn.internal.hudson.core.client.HudsonConfiguration;
import org.eclipse.mylyn.internal.hudson.core.client.HudsonConfigurationCache;
import org.eclipse.mylyn.internal.hudson.core.client.HudsonException;
import org.eclipse.mylyn.internal.hudson.core.client.HudsonOperation;
import org.eclipse.mylyn.internal.hudson.core.client.HudsonRunBuildForm;
import org.eclipse.mylyn.internal.hudson.core.client.HudsonServerInfo;
import org.eclipse.mylyn.internal.hudson.core.client.HudsonTestReport;
import org.eclipse.mylyn.internal.hudson.core.client.HudsonUrl;
import org.eclipse.mylyn.internal.hudson.model.HudsonMavenReportersSurefireAggregatedReport;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelBuild;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelHudson;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelJob;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelProject;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelRun;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelRunArtifact;
import org.eclipse.mylyn.internal.hudson.model.HudsonTasksJunitTestResult;
import org.eclipse.mylyn.internal.hudson.model.HudsonTasksTestAggregatedTestResultActionChildReport;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestfulHudsonClient {
    private static final String URL_API = "/api/xml";
    private AbstractConfigurationCache<HudsonConfiguration> cache;
    private final CommonHttpClient client;
    private volatile HudsonServerInfo info;

    public RestfulHudsonClient(RepositoryLocation location, HudsonConfigurationCache cache) {
        this.client = new CommonHttpClient(location);
        this.setCache(cache);
    }

    public List<HudsonModelRun> getBuilds(final HudsonModelJob job, final IOperationMonitor monitor) throws HudsonException {
        return (List)new HudsonOperation<List<HudsonModelRun>>(this.client){

            @Override
            public List<HudsonModelRun> execute() throws IOException, HudsonException, JAXBException {
                String url = HudsonUrl.create(RestfulHudsonClient.this.getJobUrl(job)).depth(1).tree("builds[number,url,building,result,duration,timestamp,actions[causes[shortDescription],failCount,totalCount,skipCount]]").toUrl();
                HttpGet request = this.createGetRequest(url);
                CommonHttpResponse response = this.execute((HttpRequestBase)request, monitor);
                return (List)this.processAndRelease(response, monitor);
            }

            @Override
            protected List<HudsonModelRun> doProcess(CommonHttpResponse response, IOperationMonitor monitor2) throws IOException, HudsonException, JAXBException {
                InputStream in = response.getResponseEntityAsStream((IProgressMonitor)monitor2);
                HudsonModelProject project = RestfulHudsonClient.unmarshal(RestfulHudsonClient.this.parse(in, response.getRequestPath()), HudsonModelProject.class);
                return project.getBuild();
            }
        }.run();
    }

    public HudsonModelBuild getBuild(final HudsonModelJob job, final HudsonModelRun build, final IOperationMonitor monitor) throws HudsonException {
        return (HudsonModelBuild)new HudsonOperation<HudsonModelBuild>(this.client){

            @Override
            public HudsonModelBuild execute() throws IOException, HudsonException, JAXBException {
                String url = String.valueOf(RestfulHudsonClient.this.getBuildUrl(job, build)) + RestfulHudsonClient.URL_API;
                HttpGet request = this.createGetRequest(url);
                CommonHttpResponse response = this.execute((HttpRequestBase)request, monitor);
                return (HudsonModelBuild)this.processAndRelease(response, monitor);
            }

            @Override
            protected HudsonModelBuild doProcess(CommonHttpResponse response, IOperationMonitor monitor2) throws IOException, HudsonException, JAXBException {
                InputStream in = response.getResponseEntityAsStream((IProgressMonitor)monitor2);
                HudsonModelBuild hudsonBuild = RestfulHudsonClient.unmarshal(RestfulHudsonClient.this.parse(in, response.getRequestPath()), HudsonModelBuild.class);
                return hudsonBuild;
            }
        }.run();
    }

    public HudsonTestReport getTestReport(final HudsonModelJob job, final HudsonModelRun build, final IOperationMonitor monitor) throws HudsonException {
        return (HudsonTestReport)new HudsonOperation<HudsonTestReport>(this.client){

            @Override
            public HudsonTestReport execute() throws IOException, HudsonException, JAXBException {
                String resultTree = "duration,failCount,passCount,skipCount,suites[cases[className,duration,errorDetails,errorStackTrace,failedSince,name,skipped,status],duration,name,stderr,stdout]";
                String aggregatedTree = "failCount,skipCount,totalCount,childReports[child[number,url],result[" + resultTree + "]]";
                String url = HudsonUrl.create(String.valueOf(RestfulHudsonClient.this.getBuildUrl(job, build)) + "/testReport").tree(String.valueOf(resultTree) + "," + aggregatedTree).toUrl();
                HttpGet request = this.createGetRequest(url);
                CommonHttpResponse response = this.execute((HttpRequestBase)request, monitor);
                return (HudsonTestReport)this.processAndRelease(response, monitor);
            }

            @Override
            protected HudsonTestReport doProcess(CommonHttpResponse response, IOperationMonitor monitor2) throws IOException, HudsonException, JAXBException {
                InputStream in = response.getResponseEntityAsStream((IProgressMonitor)monitor2);
                Element element = RestfulHudsonClient.this.parse(in, response.getRequestPath());
                if ("surefireAggregatedReport".equals(element.getNodeName())) {
                    HudsonMavenReportersSurefireAggregatedReport report = RestfulHudsonClient.unmarshal(element, HudsonMavenReportersSurefireAggregatedReport.class);
                    for (HudsonTasksTestAggregatedTestResultActionChildReport child : report.getChildReport()) {
                        child.setResult(RestfulHudsonClient.unmarshal((Node)child.getResult(), HudsonTasksJunitTestResult.class));
                    }
                    return new HudsonTestReport(report);
                }
                return new HudsonTestReport(RestfulHudsonClient.unmarshal(element, HudsonTasksJunitTestResult.class));
            }
        }.run();
    }

    protected String getBuildUrl(HudsonModelJob job, HudsonModelRun build) throws HudsonException {
        if (build.getNumber() == -1) {
            return String.valueOf(this.getJobUrl(job)) + "/lastBuild";
        }
        return String.valueOf(this.getJobUrl(job)) + "/" + build.getNumber();
    }

    public String getArtifactUrl(HudsonModelJob job, HudsonModelRun build, HudsonModelRunArtifact artifact) throws HudsonException {
        return String.valueOf(this.getBuildUrl(job, build)) + "/artifact/" + artifact.getRelativePath();
    }

    public AbstractConfigurationCache<HudsonConfiguration> getCache() {
        return this.cache;
    }

    public HudsonConfiguration getConfiguration() {
        return (HudsonConfiguration)this.getCache().getConfiguration(this.client.getLocation().getUrl());
    }

    public Reader getConsole(final HudsonModelJob job, final HudsonModelBuild hudsonBuild, final IOperationMonitor monitor) throws HudsonException {
        return (Reader)new HudsonOperation<Reader>(this.client){

            @Override
            public Reader execute() throws IOException, HudsonException, JAXBException {
                HttpGet request = this.createGetRequest(String.valueOf(RestfulHudsonClient.this.getBuildUrl(job, hudsonBuild)) + "/consoleText");
                CommonHttpResponse response = this.execute((HttpRequestBase)request, monitor);
                return (Reader)this.process(response, monitor);
            }

            @Override
            protected Reader doProcess(CommonHttpResponse response, IOperationMonitor monitor2) throws IOException, HudsonException {
                InputStream in = response.getResponseEntityAsStream((IProgressMonitor)monitor2);
                String charSet = response.getResponseCharSet();
                if (charSet == null) {
                    charSet = "UTF-8";
                }
                return new InputStreamReader(in, charSet);
            }
        }.run();
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }

    public List<HudsonModelJob> getJobs(final List<String> ids, final IOperationMonitor monitor) throws HudsonException {
        if (ids != null && ids.isEmpty()) {
            return Collections.emptyList();
        }
        return (List)new HudsonOperation<List<HudsonModelJob>>(this.client){

            @Override
            public List<HudsonModelJob> execute() throws IOException, HudsonException, JAXBException {
                String url = HudsonUrl.create(RestfulHudsonClient.this.client.getLocation().getUrl()).depth(1).include("/hudson/job").match("name", ids).exclude("/hudson/job/build").toUrl();
                HttpGet request = this.createGetRequest(url);
                CommonHttpResponse response = this.execute((HttpRequestBase)request, monitor);
                return (List)this.processAndRelease(response, monitor);
            }

            @Override
            protected List<HudsonModelJob> doProcess(CommonHttpResponse response, IOperationMonitor monitor2) throws IOException, HudsonException, JAXBException {
                InputStream in = response.getResponseEntityAsStream((IProgressMonitor)monitor2);
                HashMap<String, String> jobNameById = new HashMap<String, String>();
                HudsonModelHudson hudson = RestfulHudsonClient.unmarshal(RestfulHudsonClient.this.parse(in, response.getRequestPath()), HudsonModelHudson.class);
                ArrayList<HudsonModelJob> buildPlans = new ArrayList<HudsonModelJob>();
                List<Object> jobsNodes = hudson.getJob();
                for (Object jobNode : jobsNodes) {
                    Node node = (Node)jobNode;
                    HudsonModelJob job = RestfulHudsonClient.unmarshal(node, HudsonModelJob.class);
                    if (job.getDisplayName() != null && job.getDisplayName().length() > 0) {
                        jobNameById.put(job.getName(), job.getDisplayName());
                    } else {
                        jobNameById.put(job.getName(), job.getName());
                    }
                    buildPlans.add(job);
                }
                if (ids == null) {
                    HudsonConfiguration configuration = new HudsonConfiguration();
                    configuration.jobNameById = jobNameById;
                    RestfulHudsonClient.this.setConfiguration(configuration);
                }
                return buildPlans;
            }
        }.run();
    }

    String getJobUrl(HudsonModelJob job) throws HudsonException {
        String encodedJobname = "";
        try {
            encodedJobname = new URI(null, job.getName(), null).toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new HudsonException(e);
        }
        return String.valueOf(this.client.getLocation().getUrl()) + "/job/" + encodedJobname;
    }

    Element parse(InputStream in, String url) throws HudsonException {
        try {
            return this.getDocumentBuilder().parse(in).getDocumentElement();
        }
        catch (SAXException e) {
            throw new HudsonException(NLS.bind((String)"Failed to parse response from {0}", (Object)url), e);
        }
        catch (Exception e) {
            throw new HudsonException(NLS.bind((String)"Failed to parse response from {0}", (Object)url), e);
        }
    }

    public Document getJobConfig(final HudsonModelJob job, final IOperationMonitor monitor) throws HudsonException {
        return (Document)new HudsonOperation<Document>(this.client){

            @Override
            public Document execute() throws IOException, HudsonException, JAXBException {
                HttpGet request = this.createGetRequest(String.valueOf(RestfulHudsonClient.this.getJobUrl(job)) + "/config.xml");
                CommonHttpResponse response = this.execute((HttpRequestBase)request, monitor);
                return (Document)this.processAndRelease(response, monitor);
            }

            @Override
            protected Document doProcess(CommonHttpResponse response, IOperationMonitor monitor2) throws IOException, HudsonException, JAXBException {
                InputStream in = response.getResponseEntityAsStream((IProgressMonitor)monitor2);
                try {
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    return builder.parse(in);
                }
                catch (ParserConfigurationException e) {
                    throw new HudsonException(e);
                }
                catch (SAXException e) {
                    throw new HudsonException(e);
                }
            }
        }.run();
    }

    public void runBuild(final HudsonModelJob job, final Map<String, String> parameters, final IOperationMonitor monitor) throws HudsonException {
        new HudsonOperation<Object>(this.client){

            @Override
            public Object execute() throws IOException, HudsonException, JAXBException {
                HttpPost request = this.createPostRequest(String.valueOf(RestfulHudsonClient.this.getJobUrl(job)) + "/build");
                if (parameters != null) {
                    HudsonRunBuildForm form = new HudsonRunBuildForm();
                    for (Map.Entry entry : parameters.entrySet()) {
                        form.add((String)entry.getKey(), (String)entry.getValue());
                    }
                    request.setEntity((HttpEntity)form.createEntity());
                }
                CommonHttpResponse response = this.execute((HttpRequestBase)request, monitor);
                return this.processAndRelease(response, monitor);
            }

            @Override
            protected void doValidate(CommonHttpResponse response, IOperationMonitor monitor2) throws IOException, HudsonException {
                this.validate(response, 302, monitor2);
            }
        }.run();
    }

    public void setCache(AbstractConfigurationCache<HudsonConfiguration> cache) {
        Assert.isNotNull(cache);
        this.cache = cache;
    }

    protected void setConfiguration(HudsonConfiguration configuration) {
        this.getCache().setConfiguration(this.client.getLocation().getUrl(), (Serializable)configuration);
    }

    public static <T> T unmarshal(Node node, Class<T> clazz) throws JAXBException {
        JAXBContext ctx;
        try {
            ctx = JAXBContext.newInstance((Class[])new Class[]{clazz});
        }
        catch (JAXBException jAXBException) {
            try {
                Class<?> contextBuilderClass = Class.forName("com.sun.xml.bind.v2.runtime.JAXBContextImpl$JAXBContextBuilder");
                Object obj = contextBuilderClass.newInstance();
                Method method = contextBuilderClass.getDeclaredMethod("setClasses", Class[].class);
                obj = method.invoke(obj, new Object[]{new Class[]{clazz}});
                method = contextBuilderClass.getDeclaredMethod("build", new Class[0]);
                ctx = (JAXBContext)method.invoke(obj, new Object[0]);
            }
            catch (Exception e2) {
                throw new JAXBException((Throwable)e2);
            }
        }
        Unmarshaller unmarshaller = ctx.createUnmarshaller();
        JAXBElement hudsonElement = unmarshaller.unmarshal(node, clazz);
        return (T)hudsonElement.getValue();
    }

    public HudsonServerInfo validate(final IOperationMonitor monitor) throws HudsonException {
        this.info = (HudsonServerInfo)new HudsonOperation<HudsonServerInfo>(this.client){

            @Override
            public HudsonServerInfo execute() throws IOException, HudsonException, JAXBException {
                HttpHead request = this.createHeadRequest(RestfulHudsonClient.this.client.getLocation().getUrl());
                CommonHttpResponse response = this.execute((HttpRequestBase)request, monitor);
                return (HudsonServerInfo)this.processAndRelease(response, monitor);
            }

            @Override
            protected HudsonServerInfo doProcess(CommonHttpResponse response, IOperationMonitor monitor2) throws IOException, HudsonException, JAXBException {
                HudsonServerInfo.Type type;
                Header header = response.getResponse().getFirstHeader("X-Jenkins");
                if (header == null) {
                    type = HudsonServerInfo.Type.HUDSON;
                    header = response.getResponse().getFirstHeader("X-Hudson");
                    if (header == null) {
                        throw new HudsonException(NLS.bind((String)"{0} does not appear to be a Hudson or Jenkins instance", (Object)RestfulHudsonClient.this.client.getLocation().getUrl()));
                    }
                } else {
                    type = HudsonServerInfo.Type.JENKINS;
                }
                HudsonServerInfo info = new HudsonServerInfo(type, header.getValue());
                return info;
            }
        }.run();
        return this.info;
    }

    public RepositoryLocation getLocation() {
        return this.client.getLocation();
    }

    public HudsonServerInfo getInfo() {
        return this.info;
    }

    public HudsonServerInfo getInfo(IOperationMonitor monitor) throws HudsonException {
        HudsonServerInfo info = this.info;
        if (info != null) {
            return info;
        }
        return this.validate(monitor);
    }

    public void reset() {
        this.client.getHttpClient().getCookieStore().clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BuildId {
        LAST(-1, "lastBuild"),
        LAST_FAILED(-5, "lastFailedBuild"),
        LAST_STABLE(-2, "lastStableBuild"),
        LAST_SUCCESSFUL(-3, "lastSuccessfulBuild"),
        LAST_UNSTABLE(-4, "lastUnstableBuild");

        private HudsonModelBuild build;
        private final int id;
        private final String url;

        private BuildId(int id, String url) {
            this.id = id;
            this.url = url;
            this.build = new HudsonModelBuild();
            this.build.setNumber(id);
        }

        public HudsonModelBuild getBuild() {
            return this.build;
        }
    }
}

