/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.ui;

import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.internal.commons.ui.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class SwtUtil {
    public static final long FADE_RESCHEDULE_DELAY = 80L;
    public static final int FADE_IN_INCREMENT = 15;
    public static final int FADE_OUT_INCREMENT = -20;

    public static void collectItemData(TreeItem[] items, Set<Object> allVisible) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            allVisible.add(item.getData());
            SwtUtil.collectItemData(item.getItems(), allVisible);
            ++n2;
        }
    }

    public static FadeJob fastFadeIn(Shell shell, IFadeListener listener) {
        return new FadeJob(shell, 30, 80L, listener);
    }

    public static FadeJob fadeIn(Shell shell, IFadeListener listener) {
        return new FadeJob(shell, 15, 80L, listener);
    }

    public static FadeJob fadeOut(Shell shell, IFadeListener listener) {
        return new FadeJob(shell, -20, 80L, listener);
    }

    public static class FadeJob
    extends Job {
        private final Shell shell;
        private final int increment;
        private volatile boolean stopped;
        private volatile int currentAlpha;
        private final long delay;
        private final IFadeListener fadeListener;

        public FadeJob(Shell shell, int increment, long delay, IFadeListener fadeListener) {
            super(Messages.SwtUtil_Fading);
            if (increment < -255 || increment == 0 || increment > 255) {
                throw new IllegalArgumentException("-255 <= increment <= 255 && increment != 0");
            }
            if (delay < 1L) {
                throw new IllegalArgumentException("delay must be > 0");
            }
            this.currentAlpha = shell.getAlpha();
            this.shell = shell;
            this.increment = increment;
            this.delay = delay;
            this.fadeListener = fadeListener;
            this.setSystem(true);
            this.schedule(delay);
        }

        protected void canceling() {
            this.stopped = true;
        }

        private void reschedule() {
            if (this.stopped) {
                return;
            }
            this.schedule(this.delay);
        }

        public void cancelAndWait(final boolean setAlpha) {
            if (this.stopped) {
                return;
            }
            this.cancel();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (setAlpha) {
                        FadeJob.this.shell.setAlpha(FadeJob.this.getLastAlpha());
                    }
                }
            });
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (this.stopped) {
                return Status.OK_STATUS;
            }
            this.currentAlpha += this.increment;
            if (this.currentAlpha <= 0) {
                this.currentAlpha = 0;
            } else if (this.currentAlpha >= 255) {
                this.currentAlpha = 255;
            }
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (FadeJob.this.stopped) {
                        return;
                    }
                    if (FadeJob.this.shell.isDisposed()) {
                        FadeJob.this.stopped = true;
                        return;
                    }
                    FadeJob.this.shell.setAlpha(FadeJob.this.currentAlpha);
                    if (FadeJob.this.fadeListener != null) {
                        FadeJob.this.fadeListener.faded(FadeJob.this.shell, FadeJob.this.currentAlpha);
                    }
                }
            });
            if (this.currentAlpha == 0 || this.currentAlpha == 255) {
                this.stopped = true;
            }
            this.reschedule();
            return Status.OK_STATUS;
        }

        private int getLastAlpha() {
            return this.increment < 0 ? 0 : 255;
        }
    }

    public static interface IFadeListener {
        public void faded(Shell var1, int var2);
    }
}

