/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.bugzilla.core.AbstractBugzillaOperation;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCustomField;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaFlag;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaFlagMapper;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaOperation;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.eclipse.mylyn.internal.bugzilla.core.CustomTransitionManager;
import org.eclipse.mylyn.internal.bugzilla.core.IBugzillaConstants;
import org.eclipse.mylyn.internal.bugzilla.core.Messages;
import org.eclipse.mylyn.internal.bugzilla.core.service.BugzillaXmlRpcClient;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryConfiguration
implements Serializable {
    private static final long serialVersionUID = -7051029281842783666L;
    private String repositoryUrl = "<unknown>";
    private final Map<String, ProductEntry> products = new HashMap<String, ProductEntry>();
    private final List<String> platforms = new ArrayList<String>();
    private final List<String> operatingSystems = new ArrayList<String>();
    private final List<String> priorities = new ArrayList<String>();
    private final List<String> severities = new ArrayList<String>();
    private final List<String> bugStatus = new ArrayList<String>();
    private final List<String> openStatusValues = new ArrayList<String>();
    private final List<String> closedStatusValues = new ArrayList<String>();
    private final List<String> resolutionValues = new ArrayList<String>();
    private final List<String> keywords = new ArrayList<String>();
    private final List<String> versions = new ArrayList<String>();
    private final List<String> components = new ArrayList<String>();
    private final List<String> milestones = new ArrayList<String>();
    private final List<BugzillaCustomField> customFields = new ArrayList<BugzillaCustomField>();
    private final List<BugzillaFlag> flags = new ArrayList<BugzillaFlag>();
    private BugzillaVersion version = BugzillaVersion.MIN_VERSION;
    private CustomTransitionManager validTransitions;
    private String encoding = null;
    private String eTagValue = null;
    private Date lastModifiedHeader = null;

    public void addStatus(String status) {
        this.bugStatus.add(status);
    }

    public List<String> getStatusValues() {
        return this.bugStatus;
    }

    public void addResolution(String res) {
        this.resolutionValues.add(res);
    }

    public List<String> getResolutions() {
        return this.resolutionValues;
    }

    public void addProduct(String name) {
        if (!this.products.containsKey(name)) {
            ProductEntry product = new ProductEntry(name);
            this.products.put(name, product);
        }
    }

    public List<String> getProducts() {
        ArrayList<String> productList = new ArrayList<String>(this.products.keySet());
        Collections.sort(productList, String.CASE_INSENSITIVE_ORDER);
        return productList;
    }

    public List<String> getComponents(String product) {
        ProductEntry entry = this.products.get(product);
        if (entry != null) {
            return entry.getComponents();
        }
        return Collections.emptyList();
    }

    public List<String> getVersions(String product) {
        ProductEntry entry = this.products.get(product);
        if (entry != null) {
            return entry.getVersions();
        }
        return Collections.emptyList();
    }

    public List<String> getSeverities() {
        return this.severities;
    }

    public List<String> getOSs() {
        return this.operatingSystems;
    }

    public void addOS(String os) {
        this.operatingSystems.add(os);
    }

    public List<String> getPlatforms() {
        return this.platforms;
    }

    public List<String> getPriorities() {
        return this.priorities;
    }

    public void addComponent(String product, String component) {
        ProductEntry entry;
        if (!this.components.contains(component)) {
            this.components.add(component);
        }
        if ((entry = this.products.get(product)) == null) {
            entry = new ProductEntry(product);
            this.products.put(product, entry);
        }
        entry.addComponent(component);
    }

    public void addVersion(String product, String version) {
        ProductEntry entry;
        if (!this.versions.contains(version)) {
            this.versions.add(version);
        }
        if ((entry = this.products.get(product)) == null) {
            entry = new ProductEntry(product);
            this.products.put(product, entry);
        }
        entry.addVersion(version);
    }

    public void addKeyword(String keyword) {
        this.keywords.add(keyword);
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public void addPlatform(String platform) {
        this.platforms.add(platform);
    }

    public void addPriority(String priority) {
        this.priorities.add(priority);
    }

    public void addSeverity(String severity) {
        this.severities.add(severity);
    }

    public void setInstallVersion(String version) {
        this.version = new BugzillaVersion(version);
    }

    public BugzillaVersion getInstallVersion() {
        return this.version;
    }

    public void addTargetMilestone(String product, String target) {
        ProductEntry entry;
        if (!this.milestones.contains(target)) {
            this.milestones.add(target);
        }
        if ((entry = this.products.get(product)) == null) {
            entry = new ProductEntry(product);
            this.products.put(product, entry);
        }
        entry.addTargetMilestone(target);
    }

    public List<String> getTargetMilestones(String product) {
        ProductEntry entry = this.products.get(product);
        if (entry != null) {
            return entry.getTargetMilestones();
        }
        return Collections.emptyList();
    }

    public void addUnconfirmedAllowed(String product, Boolean unconfirmedAllowed) {
        ProductEntry entry = this.products.get(product);
        if (entry == null) {
            entry = new ProductEntry(product);
            this.products.put(product, entry);
        }
        entry.setUnconfirmedAllowed(unconfirmedAllowed);
    }

    public List<String> getOpenStatusValues() {
        return this.openStatusValues;
    }

    public void addOpenStatusValue(String value) {
        this.openStatusValues.add(value);
    }

    public List<String> getClosedStatusValues() {
        ArrayList<String> closedStatus;
        if (this.validTransitions != null && (closedStatus = this.validTransitions.getClosedStatuses()) != null && !closedStatus.isEmpty()) {
            return closedStatus;
        }
        return this.closedStatusValues;
    }

    public void addClosedStatusValue(String value) {
        this.closedStatusValues.add(value);
    }

    public List<String> getComponents() {
        return this.components;
    }

    public List<String> getTargetMilestones() {
        return this.milestones;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }

    public void setValidTransitions(IProgressMonitor monitor, String fileName, BugzillaXmlRpcClient xmlClient) throws CoreException {
        if (this.getInstallVersion() != null && this.getInstallVersion().compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_2) < 0) {
            return;
        }
        try {
            if (this.validTransitions == null) {
                this.validTransitions = new CustomTransitionManager();
            }
            if (xmlClient == null) {
                if (!this.validTransitions.parse(fileName)) {
                    this.validTransitions = null;
                }
            } else if (!this.version.isSmaller(BugzillaVersion.BUGZILLA_3_6)) {
                this.validTransitions.parse(monitor, xmlClient);
            } else {
                this.validTransitions = null;
            }
        }
        catch (CoreException e) {
            this.validTransitions = null;
            throw e;
        }
    }

    public List<String> getOptionValues(BugzillaAttribute element, String product) {
        switch (element) {
            case PRODUCT: {
                return this.getProducts();
            }
            case TARGET_MILESTONE: {
                return this.getTargetMilestones(product);
            }
            case BUG_STATUS: {
                return this.getStatusValues();
            }
            case VERSION: {
                return this.getVersions(product);
            }
            case COMPONENT: {
                return this.getComponents(product);
            }
            case REP_PLATFORM: {
                return this.getPlatforms();
            }
            case OP_SYS: {
                return this.getOSs();
            }
            case PRIORITY: {
                return this.getPriorities();
            }
            case BUG_SEVERITY: {
                return this.getSeverities();
            }
            case KEYWORDS: {
                return this.getKeywords();
            }
            case RESOLUTION: {
                return this.getResolutions();
            }
        }
        return Collections.emptyList();
    }

    public void addCustomField(BugzillaCustomField newField) {
        this.customFields.add(newField);
    }

    public List<BugzillaCustomField> getCustomFields() {
        return this.customFields;
    }

    public void configureTaskData(TaskData taskData, boolean localuser, BugzillaRepositoryConnector connector) {
        if (taskData != null) {
            this.addMissingFlags(taskData, connector);
            this.updateAttributeOptions(taskData);
            this.addValidOperations(taskData);
            if (localuser) {
                this.removeDomain(taskData);
            }
            this.addMissingAttachmentFlags(taskData, connector);
            this.updateAttachmentOptions(taskData);
        }
    }

    private void removeDomain(TaskData taskData) {
        BugzillaAttribute[] bugzillaAttributeArray = BugzillaAttribute.PERSON_ATTRIBUTES;
        int n = BugzillaAttribute.PERSON_ATTRIBUTES.length;
        int n2 = 0;
        while (n2 < n) {
            BugzillaAttribute element = bugzillaAttributeArray[n2];
            TaskAttribute attribute = taskData.getRoot().getAttribute(element.getKey());
            if (attribute != null) {
                this.cleanShortLogin(attribute);
            }
            ++n2;
        }
    }

    private void cleanShortLogin(TaskAttribute a) {
        int atIndex;
        if (a.getValue() != null && a.getValue().length() > 0 && (atIndex = a.getValue().indexOf("@")) != -1) {
            String newValue = a.getValue().substring(0, atIndex);
            a.setValue(newValue);
        }
    }

    private void addMissingFlags(TaskData taskData, BugzillaRepositoryConnector connector) {
        ArrayList<String> existingFlags = new ArrayList<String>();
        List<BugzillaFlag> flags = this.getFlags();
        for (TaskAttribute attribute : new HashSet(taskData.getRoot().getAttributes().values())) {
            String desc;
            TaskAttribute state;
            if (!attribute.getId().startsWith("task.common.kind.flag") || (state = attribute.getAttribute("state")) == null) continue;
            String nameValue = state.getMetaData().getLabel();
            if (!existingFlags.contains(nameValue)) {
                existingFlags.add(nameValue);
            }
            if ((desc = attribute.getMetaData().getLabel()) != null && !desc.equals("")) continue;
            for (BugzillaFlag bugzillaFlag : flags) {
                if (bugzillaFlag.getType().equals("attachment") || !bugzillaFlag.getName().equals(nameValue)) continue;
                attribute.getMetaData().setLabel(bugzillaFlag.getDescription());
            }
        }
        TaskAttribute productAttribute = taskData.getRoot().getMappedAttribute(BugzillaAttribute.PRODUCT.getKey());
        TaskAttribute componentAttribute = taskData.getRoot().getMappedAttribute(BugzillaAttribute.COMPONENT.getKey());
        for (BugzillaFlag bugzillaFlag : flags) {
            if (bugzillaFlag.getType().equals("attachment") || !bugzillaFlag.isUsedIn(productAttribute.getValue(), componentAttribute.getValue()) || existingFlags.contains(bugzillaFlag.getName()) && !bugzillaFlag.isMultiplicable()) continue;
            BugzillaFlagMapper mapper = new BugzillaFlagMapper(connector);
            mapper.setRequestee("");
            mapper.setSetter("");
            mapper.setState(" ");
            mapper.setFlagId(bugzillaFlag.getName());
            mapper.setNumber(0);
            mapper.setDescription(bugzillaFlag.getDescription());
            TaskAttribute attribute = taskData.getRoot().createAttribute("task.common.kind.flag_type" + bugzillaFlag.getFlagId());
            mapper.applyTo(attribute);
        }
        this.setFlagsRequestee(taskData);
    }

    private void setFlagsRequestee(TaskData taskData) {
        for (TaskAttribute attribute : new HashSet(taskData.getRoot().getAttributes().values())) {
            TaskAttribute state;
            if (!attribute.getId().startsWith("task.common.kind.flag") || (state = attribute.getAttribute("state")) == null) continue;
            String nameValue = state.getMetaData().getLabel();
            for (BugzillaFlag bugzillaFlag : this.flags) {
                if (!nameValue.equals(bugzillaFlag.getName())) continue;
                TaskAttribute requestee = attribute.getAttribute("requestee");
                if (requestee == null) {
                    requestee = attribute.createMappedAttribute("requestee");
                    requestee.getMetaData().defaults().setType("person");
                    requestee.setValue("");
                }
                requestee.getMetaData().setReadOnly(!bugzillaFlag.isSpecifically_requestable());
            }
        }
    }

    public void updateAttributeOptions(TaskData existingReport) {
        TaskAttribute attributeProduct = existingReport.getRoot().getMappedAttribute(BugzillaAttribute.PRODUCT.getKey());
        if (attributeProduct == null) {
            return;
        }
        String product = attributeProduct.getValue();
        for (TaskAttribute attribute : new HashSet(existingReport.getRoot().getAttributes().values())) {
            List<String> optionValues = this.getAttributeOptions(product, attribute);
            if (attribute.getId().equals(BugzillaAttribute.TARGET_MILESTONE.getKey()) && optionValues.isEmpty()) {
                existingReport.getRoot().removeAttribute(BugzillaAttribute.TARGET_MILESTONE.getKey());
                continue;
            }
            if (attribute.getId().startsWith("task.common.kind.flag")) {
                attribute = attribute.getAttribute("state");
            }
            attribute.clearOptions();
            for (String option : optionValues) {
                attribute.putOption(option, option);
            }
        }
    }

    public List<String> getAttributeOptions(String product, TaskAttribute attribute) {
        List<String> options = new ArrayList<String>();
        if (attribute.getId().startsWith("cf_")) {
            for (BugzillaCustomField bugzillaCustomField : this.customFields) {
                if (!bugzillaCustomField.getName().equals(attribute.getId())) continue;
                options = bugzillaCustomField.getOptions();
                break;
            }
        } else if (attribute.getId().startsWith("task.common.kind.flag")) {
            TaskAttribute state = attribute.getAttribute("state");
            if (state != null) {
                String nameValue = state.getMetaData().getLabel();
                options.add("");
                for (BugzillaFlag bugzillaFlag : this.flags) {
                    if (!nameValue.equals(bugzillaFlag.getName()) || !nameValue.equals(bugzillaFlag.getName())) continue;
                    if (!bugzillaFlag.isRequestable()) break;
                    options.add("?");
                    break;
                }
                options.add("+");
                options.add("-");
            }
        } else {
            String type = attribute.getMetaData().getType();
            if (type != null && type.equals("bugzilla.editor.flag")) {
                options.add("");
                options.add("?");
                options.add("+");
                options.add("-");
            } else {
                BugzillaAttribute element;
                try {
                    element = BugzillaAttribute.valueOf(attribute.getId().trim().toUpperCase(Locale.ENGLISH));
                }
                catch (RuntimeException e) {
                    if (e instanceof IllegalArgumentException) {
                        return options;
                    }
                    throw e;
                }
                options = this.getOptionValues(element, product);
                if (element != BugzillaAttribute.RESOLUTION && element != BugzillaAttribute.OP_SYS && element != BugzillaAttribute.BUG_SEVERITY && element != BugzillaAttribute.PRIORITY && element != BugzillaAttribute.BUG_STATUS && element != BugzillaAttribute.TARGET_MILESTONE && element != BugzillaAttribute.PRODUCT) {
                    Collections.sort(options);
                }
            }
        }
        return options;
    }

    public void addValidOperations(TaskData bugReport) {
        BugzillaVersion bugzillaVersion = this.getInstallVersion();
        if (bugzillaVersion == null) {
            bugzillaVersion = BugzillaVersion.MIN_VERSION;
        }
        if (bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_4_0) < 0) {
            this.addValidOperationsBefore4(bugReport);
        } else if (this.getStatusValues().contains(IBugzillaConstants.BUGZILLA_REPORT_STATUS_4_0.IN_PROGRESS.toString()) || this.getStatusValues().contains(IBugzillaConstants.BUGZILLA_REPORT_STATUS_4_0.CONFIRMED.toString())) {
            this.addValidOperationsAfter4(bugReport);
        } else {
            this.addValidOperationsBefore4(bugReport);
        }
    }

    public void addValidOperationsAfter4(TaskData bugReport) {
        TaskAttribute attributeStatus = bugReport.getRoot().getMappedAttribute("task.common.status");
        IBugzillaConstants.BUGZILLA_REPORT_STATUS_4_0 status = IBugzillaConstants.BUGZILLA_REPORT_STATUS_4_0.UNCONFIRMED;
        if (attributeStatus != null) {
            try {
                status = IBugzillaConstants.BUGZILLA_REPORT_STATUS_4_0.valueOf(attributeStatus.getValue());
            }
            catch (RuntimeException runtimeException) {
                status = IBugzillaConstants.BUGZILLA_REPORT_STATUS_4_0.UNCONFIRMED;
            }
        }
        if (this.validTransitions != null && attributeStatus != null && this.validTransitions.isValid()) {
            if (attributeStatus.getValue().equals("START")) {
                this.addOperation(bugReport, BugzillaOperation.new_default);
                TaskAttribute operationAttribute = bugReport.getRoot().getAttribute("task.common.operation");
                TaskOperation.applyTo((TaskAttribute)operationAttribute, (String)BugzillaOperation.new_default.toString(), (String)IBugzillaConstants.BUGZILLA_REPORT_STATUS_4_0.START.toString());
            } else {
                this.addOperation(bugReport, BugzillaOperation.none);
                for (AbstractBugzillaOperation b : this.validTransitions.getValidTransitions(attributeStatus.getValue())) {
                    if (b.toString().equals(BugzillaOperation.close.toString()) && (attributeStatus.getValue().equals("RESOLVED") && b.getInputId() != null || !attributeStatus.getValue().equals("RESOLVED") && b.getInputId() == null)) continue;
                    this.addOperation(bugReport, b);
                }
            }
        } else {
            TaskAttribute everConfirmed = bugReport.getRoot().getAttribute(BugzillaAttribute.EVERCONFIRMED.getKey());
            TaskAttribute product = bugReport.getRoot().getMappedAttribute("task.common.product");
            Boolean unconfirmedAllowed = this.products.get(product.getValue()).getUnconfirmedAllowed();
            switch (status) {
                case START: {
                    this.addOperation(bugReport, BugzillaOperation.new_default);
                    this.addOperation(bugReport, BugzillaOperation.unconfirmed);
                    TaskAttribute unconfirmedAttribute = bugReport.getRoot().getAttribute("task.common.operation-" + BugzillaOperation.unconfirmed.toString());
                    if (unconfirmedAttribute != null && unconfirmedAllowed != null) {
                        unconfirmedAttribute.getMetaData().setDisabled(unconfirmedAllowed == false);
                    }
                    this.addOperation(bugReport, BugzillaOperation.confirmed);
                    this.addOperation(bugReport, BugzillaOperation.in_progress);
                    TaskAttribute operationAttribute = bugReport.getRoot().getAttribute("task.common.operation");
                    TaskOperation.applyTo((TaskAttribute)operationAttribute, (String)BugzillaOperation.new_default.toString(), (String)IBugzillaConstants.BUGZILLA_REPORT_STATUS_4_0.START.toString());
                    break;
                }
                case UNCONFIRMED: {
                    this.addOperation(bugReport, BugzillaOperation.none);
                    this.addOperation(bugReport, BugzillaOperation.confirmed);
                    this.addOperation(bugReport, BugzillaOperation.in_progress);
                    this.addOperation(bugReport, BugzillaOperation.resolve);
                    break;
                }
                case CONFIRMED: {
                    this.addOperation(bugReport, BugzillaOperation.none);
                    this.addOperation(bugReport, BugzillaOperation.in_progress);
                    this.addOperation(bugReport, BugzillaOperation.resolve);
                    break;
                }
                case IN_PROGRESS: {
                    this.addOperation(bugReport, BugzillaOperation.none);
                    this.addOperation(bugReport, BugzillaOperation.confirmed);
                    this.addOperation(bugReport, BugzillaOperation.resolve);
                    break;
                }
                case RESOLVED: {
                    this.addOperation(bugReport, BugzillaOperation.none);
                    if (unconfirmedAllowed.booleanValue()) {
                        this.addOperation(bugReport, BugzillaOperation.unconfirmed);
                    }
                    if (everConfirmed != null && "1".equals(everConfirmed.getValue())) {
                        this.addOperation(bugReport, BugzillaOperation.confirmed);
                    }
                    this.addOperation(bugReport, BugzillaOperation.verify_with_resolution);
                    break;
                }
                case VERIFIED: {
                    this.addOperation(bugReport, BugzillaOperation.none);
                    if (unconfirmedAllowed.booleanValue()) {
                        this.addOperation(bugReport, BugzillaOperation.unconfirmed);
                    }
                    if (everConfirmed != null && "1".equals(everConfirmed.getValue())) {
                        this.addOperation(bugReport, BugzillaOperation.confirmed);
                    }
                    this.addOperation(bugReport, BugzillaOperation.resolve);
                }
            }
            if (status != IBugzillaConstants.BUGZILLA_REPORT_STATUS_4_0.START) {
                this.addOperation(bugReport, BugzillaOperation.duplicate);
            }
        }
        BugzillaAttribute key = BugzillaAttribute.SET_DEFAULT_ASSIGNEE;
        TaskAttribute operationAttribute = bugReport.getRoot().getAttribute(key.getKey());
        if (operationAttribute == null) {
            operationAttribute = bugReport.getRoot().createAttribute(key.getKey());
            operationAttribute.getMetaData().defaults().setReadOnly(key.isReadOnly()).setKind(key.getKind()).setLabel(key.toString()).setType(key.getType());
            operationAttribute.setValue("0");
        }
        if ((operationAttribute = bugReport.getRoot().getMappedAttribute("task.common.user.assigned")) != null) {
            operationAttribute.getMetaData().setReadOnly(false);
        }
    }

    public void addValidOperationsBefore4(TaskData bugReport) {
        BugzillaVersion bugzillaVersion;
        TaskAttribute attributeStatus = bugReport.getRoot().getMappedAttribute("task.common.status");
        IBugzillaConstants.BUGZILLA_REPORT_STATUS status = IBugzillaConstants.BUGZILLA_REPORT_STATUS.NEW;
        if (attributeStatus != null) {
            try {
                status = IBugzillaConstants.BUGZILLA_REPORT_STATUS.valueOf(attributeStatus.getValue());
            }
            catch (RuntimeException runtimeException) {
                status = IBugzillaConstants.BUGZILLA_REPORT_STATUS.NEW;
            }
        }
        if ((bugzillaVersion = this.getInstallVersion()) == null) {
            bugzillaVersion = BugzillaVersion.MIN_VERSION;
        }
        if (this.validTransitions != null && attributeStatus != null && this.validTransitions.isValid()) {
            this.addOperation(bugReport, BugzillaOperation.none);
            for (AbstractBugzillaOperation b : this.validTransitions.getValidTransitions(attributeStatus.getValue())) {
                if (b.toString().equals(BugzillaOperation.close.toString()) && (attributeStatus.getValue().equals("RESOLVED") && b.getInputId() != null || !attributeStatus.getValue().equals("RESOLVED") && b.getInputId() == null)) continue;
                this.addOperation(bugReport, b);
            }
        } else {
            switch (status) {
                case NEW: {
                    this.addOperation(bugReport, BugzillaOperation.none);
                    this.addOperation(bugReport, BugzillaOperation.accept);
                    this.addOperation(bugReport, BugzillaOperation.resolve);
                    if (bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_2) >= 0) {
                        this.addOperation(bugReport, BugzillaOperation.close_with_resolution);
                    }
                    this.addOperation(bugReport, BugzillaOperation.duplicate);
                    break;
                }
                case UNCONFIRMED: 
                case REOPENED: {
                    this.addOperation(bugReport, BugzillaOperation.none);
                    this.addOperation(bugReport, BugzillaOperation.accept);
                    this.addOperation(bugReport, BugzillaOperation.resolve);
                    if (bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_2) >= 0) {
                        this.addOperation(bugReport, BugzillaOperation.close_with_resolution);
                    }
                    this.addOperation(bugReport, BugzillaOperation.duplicate);
                    if (bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_2) < 0) break;
                    this.addOperation(bugReport, BugzillaOperation.markNew);
                    break;
                }
                case ASSIGNED: {
                    this.addOperation(bugReport, BugzillaOperation.none);
                    this.addOperation(bugReport, BugzillaOperation.resolve);
                    if (bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_2) >= 0) {
                        this.addOperation(bugReport, BugzillaOperation.close_with_resolution);
                    }
                    this.addOperation(bugReport, BugzillaOperation.duplicate);
                    if (bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_2) < 0) break;
                    this.addOperation(bugReport, BugzillaOperation.markNew);
                    break;
                }
                case RESOLVED: {
                    this.addOperation(bugReport, BugzillaOperation.none);
                    this.addOperation(bugReport, BugzillaOperation.reopen);
                    this.addOperation(bugReport, BugzillaOperation.verify);
                    this.addOperation(bugReport, BugzillaOperation.close);
                    if (bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_0) < 0) break;
                    this.addOperation(bugReport, BugzillaOperation.duplicate);
                    this.addOperation(bugReport, BugzillaOperation.resolve);
                    break;
                }
                case CLOSED: {
                    this.addOperation(bugReport, BugzillaOperation.none);
                    this.addOperation(bugReport, BugzillaOperation.reopen);
                    if (bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_0) < 0) break;
                    this.addOperation(bugReport, BugzillaOperation.duplicate);
                    this.addOperation(bugReport, BugzillaOperation.resolve);
                    break;
                }
                case VERIFIED: {
                    this.addOperation(bugReport, BugzillaOperation.none);
                    this.addOperation(bugReport, BugzillaOperation.reopen);
                    this.addOperation(bugReport, BugzillaOperation.close);
                    if (bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_0) < 0) break;
                    this.addOperation(bugReport, BugzillaOperation.duplicate);
                    this.addOperation(bugReport, BugzillaOperation.resolve);
                }
            }
        }
        if (bugzillaVersion.compareTo(BugzillaVersion.BUGZILLA_3_0) < 0) {
            TaskAttribute productAttribute = bugReport.getRoot().getMappedAttribute(BugzillaAttribute.PRODUCT.getKey());
            productAttribute.getMetaData().setReadOnly(true);
        }
        if (bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_0) <= 0) {
            if (status == IBugzillaConstants.BUGZILLA_REPORT_STATUS.NEW || status == IBugzillaConstants.BUGZILLA_REPORT_STATUS.ASSIGNED || status == IBugzillaConstants.BUGZILLA_REPORT_STATUS.REOPENED || status == IBugzillaConstants.BUGZILLA_REPORT_STATUS.UNCONFIRMED) {
                this.addOperation(bugReport, BugzillaOperation.reassign);
                this.addOperation(bugReport, BugzillaOperation.reassignbycomponent);
            }
        } else {
            BugzillaAttribute key = BugzillaAttribute.SET_DEFAULT_ASSIGNEE;
            TaskAttribute operationAttribute = bugReport.getRoot().getAttribute(key.getKey());
            if (operationAttribute == null) {
                operationAttribute = bugReport.getRoot().createAttribute(key.getKey());
                operationAttribute.getMetaData().defaults().setReadOnly(key.isReadOnly()).setKind(key.getKind()).setLabel(key.toString()).setType(key.getType());
                operationAttribute.setValue("0");
            }
            if ((operationAttribute = bugReport.getRoot().getMappedAttribute("task.common.user.assigned")) != null) {
                operationAttribute.getMetaData().setReadOnly(false);
            }
        }
    }

    public void addOperation(TaskData bugReport, AbstractBugzillaOperation op) {
        TaskAttribute attribute;
        TaskAttribute operationAttribute = bugReport.getRoot().getAttribute("task.common.operation");
        if (operationAttribute == null) {
            operationAttribute = bugReport.getRoot().createAttribute("task.common.operation");
        }
        if (op.toString() == BugzillaOperation.none.toString()) {
            attribute = bugReport.getRoot().createAttribute("task.common.operation-" + op.toString());
            String label = "Leave";
            TaskAttribute attributeStatus = bugReport.getRoot().getMappedAttribute("task.common.status");
            TaskAttribute attributeResolution = bugReport.getRoot().getMappedAttribute("task.common.resolution");
            if (attributeStatus != null && attributeResolution != null) {
                label = String.format(op.getLabel(), attributeStatus.getValue(), attributeResolution.getValue());
            }
            TaskOperation.applyTo((TaskAttribute)attribute, (String)op.toString(), (String)label);
            TaskOperation.applyTo((TaskAttribute)operationAttribute, (String)op.toString(), (String)label);
        } else if (op.toString() == BugzillaOperation.resolve.toString()) {
            attribute = bugReport.getRoot().createAttribute("task.common.operation-" + op.toString());
            TaskOperation.applyTo((TaskAttribute)attribute, (String)op.toString(), (String)op.getLabel());
            TaskAttribute attrResolvedInput = attribute.getTaskData().getRoot().createAttribute(op.getInputId());
            attrResolvedInput.getMetaData().setType(op.getInputType());
            attribute.getMetaData().putValue("task.meta.associated.attribute", op.getInputId());
            for (String resolution : this.getResolutions()) {
                if (resolution.compareTo("DUPLICATE") == 0 || resolution.compareTo("MOVED") == 0) continue;
                attrResolvedInput.putOption(resolution, resolution);
            }
            if (this.getResolutions().size() > 0) {
                attrResolvedInput.setValue(this.getResolutions().get(0));
            }
        } else if (op.toString().equals(BugzillaOperation.verify_with_resolution.toString()) && op.getInputId() != null) {
            TaskAttribute attributeResolution = bugReport.getRoot().getMappedAttribute("task.common.resolution");
            String oldResolutionValue = attributeResolution.getValue();
            attribute = bugReport.getRoot().createAttribute("task.common.operation-" + op.toString());
            TaskOperation.applyTo((TaskAttribute)attribute, (String)op.toString(), (String)op.getLabel());
            TaskAttribute attrResolvedInput = attribute.getTaskData().getRoot().createAttribute(op.getInputId());
            attrResolvedInput.getMetaData().setType(op.getInputType());
            attribute.getMetaData().putValue("task.meta.associated.attribute", op.getInputId());
            for (String resolution : this.getResolutions()) {
                if (resolution.compareTo("DUPLICATE") == 0 || resolution.compareTo("MOVED") == 0) continue;
                attrResolvedInput.putOption(resolution, resolution);
            }
            if (this.getResolutions().size() > 0) {
                attrResolvedInput.setValue(oldResolutionValue);
            }
        } else if (op.toString().equals(BugzillaOperation.close_with_resolution.toString()) && op.getInputId() != null) {
            attribute = bugReport.getRoot().createAttribute("task.common.operation-" + op.toString());
            TaskOperation.applyTo((TaskAttribute)attribute, (String)op.toString(), (String)op.getLabel());
            TaskAttribute attrResolvedInput = attribute.getTaskData().getRoot().createAttribute(op.getInputId());
            attrResolvedInput.getMetaData().setType(op.getInputType());
            attribute.getMetaData().putValue("task.meta.associated.attribute", op.getInputId());
            for (String resolution : this.getResolutions()) {
                if (resolution.compareTo("DUPLICATE") == 0 || resolution.compareTo("MOVED") == 0) continue;
                attrResolvedInput.putOption(resolution, resolution);
            }
            if (this.getResolutions().size() > 0) {
                attrResolvedInput.setValue(this.getResolutions().get(0));
            }
        } else if (op.toString() == BugzillaOperation.duplicate.toString()) {
            attribute = bugReport.getRoot().createAttribute("task.common.operation-" + op.toString());
            TaskOperation.applyTo((TaskAttribute)attribute, (String)op.toString(), (String)op.getLabel());
            if (op.getInputId() != null) {
                TaskAttribute attrInput = bugReport.getRoot().getAttribute(op.getInputId());
                if (attrInput == null) {
                    attrInput = bugReport.getRoot().createAttribute(op.getInputId());
                }
                attrInput.getMetaData().defaults().setReadOnly(false).setType(op.getInputType());
                attribute.getMetaData().putValue("task.meta.associated.attribute", op.getInputId());
            }
        } else if (op.toString() == BugzillaOperation.new_default.toString()) {
            attribute = bugReport.getRoot().createAttribute("task.common.operation-" + op.toString());
            TaskOperation.applyTo((TaskAttribute)attribute, (String)op.toString(), (String)op.getLabel());
        } else {
            attribute = bugReport.getRoot().createAttribute("task.common.operation-" + op.toString());
            if (bugReport.isNew()) {
                TaskOperation.applyTo((TaskAttribute)attribute, (String)op.toString(), (String)op.getLabel());
            } else {
                TaskOperation.applyTo((TaskAttribute)attribute, (String)op.toString(), (String)op.getLabel());
            }
            if (op.getInputId() != null) {
                TaskAttribute attrInput = bugReport.getRoot().createAttribute(op.getInputId());
                attrInput.getMetaData().defaults().setReadOnly(false).setType(op.getInputType());
                attribute.getMetaData().putValue("task.meta.associated.attribute", op.getInputId());
            }
        }
        if (op.toString().equals(BugzillaOperation.none.toString())) {
            attribute.getMetaData().putValue("task.meta.description", Messages.RepositoryConfiguration_Operation_Tooltip_none);
        } else if (op.toString().equals(BugzillaOperation.new_default.toString())) {
            attribute.getMetaData().putValue("task.meta.description", Messages.RepositoryConfiguration_Operation_Tooltip_new_default);
        } else if (op.toString().equals(BugzillaOperation.unconfirmed.toString())) {
            attribute.getMetaData().putValue("task.meta.description", Messages.RepositoryConfiguration_Operation_Tooltip_unconfirmed);
        } else if (op.toString().equals(BugzillaOperation.confirmed.toString())) {
            attribute.getMetaData().putValue("task.meta.description", Messages.RepositoryConfiguration_Operation_Tooltip_confirmed);
        } else if (op.toString().equals(BugzillaOperation.in_progress.toString())) {
            attribute.getMetaData().putValue("task.meta.description", Messages.RepositoryConfiguration_Operation_Tooltip_in_progress);
        } else if (op.toString().equals(BugzillaOperation.resolve.toString())) {
            attribute.getMetaData().putValue("task.meta.description", Messages.RepositoryConfiguration_Operation_Tooltip_resolve);
        } else if (op.toString().equals(BugzillaOperation.verify.toString()) || op.toString().equals(BugzillaOperation.verify_with_resolution.toString())) {
            attribute.getMetaData().putValue("task.meta.description", Messages.RepositoryConfiguration_Operation_Tooltip_veryfy);
        } else if (op.toString().equals(BugzillaOperation.duplicate.toString())) {
            attribute.getMetaData().putValue("task.meta.description", Messages.RepositoryConfiguration_Operation_Tooltip_duplicate);
        } else if (op.toString().equals(BugzillaOperation.reopen.toString())) {
            attribute.getMetaData().putValue("task.meta.description", Messages.RepositoryConfiguration_Operation_Tooltip_reopen);
        } else if (op.toString().equals(BugzillaOperation.close.toString()) || op.toString().equals(BugzillaOperation.close_with_resolution.toString())) {
            attribute.getMetaData().putValue("task.meta.description", Messages.RepositoryConfiguration_Operation_Tooltip_close);
        }
    }

    public void addFlag(BugzillaFlag newFlag) {
        this.flags.add(newFlag);
    }

    public List<BugzillaFlag> getFlags() {
        return this.flags;
    }

    public BugzillaFlag getFlagWithId(Integer id) {
        for (BugzillaFlag bugzillaFlag : this.flags) {
            if (bugzillaFlag.getFlagId() != id.intValue()) continue;
            return bugzillaFlag;
        }
        return null;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void updateAttachmentOptions(TaskData existingReport) {
        for (TaskAttribute attribute : new HashSet(existingReport.getRoot().getAttributes().values())) {
            if (!attribute.getId().startsWith("task.common.attachment")) continue;
            for (TaskAttribute attachmentAttribute : attribute.getAttributes().values()) {
                if (!attachmentAttribute.getId().startsWith("task.common.kind.flag")) continue;
                TaskAttribute state = attachmentAttribute.getAttribute("state");
                attachmentAttribute.clearOptions();
                String nameValue = state.getMetaData().getLabel();
                state.putOption("", "");
                for (BugzillaFlag bugzillaFlag : this.flags) {
                    if (!nameValue.equals(bugzillaFlag.getName()) || !bugzillaFlag.getType().equals("attachment") || !"attachment".equals(bugzillaFlag.getType())) continue;
                    if (!bugzillaFlag.isRequestable()) break;
                    state.putOption("?", "?");
                    break;
                }
                state.putOption("-", "-");
                state.putOption("+", "+");
                String flagNameValue = state.getMetaData().getLabel();
                for (BugzillaFlag bugzillaFlag : this.flags) {
                    if (!flagNameValue.equals(bugzillaFlag.getName()) || !bugzillaFlag.getType().equals("attachment")) continue;
                    TaskAttribute requestee = attachmentAttribute.getAttribute("requestee");
                    if (requestee == null) {
                        requestee = attachmentAttribute.createMappedAttribute("requestee");
                        requestee.getMetaData().defaults().setType("shortText");
                        requestee.setValue("");
                    }
                    requestee.getMetaData().setReadOnly(!bugzillaFlag.isSpecifically_requestable());
                }
            }
        }
    }

    private void addMissingAttachmentFlags(TaskData taskData, BugzillaRepositoryConnector connector) {
        ArrayList<String> existingFlags = new ArrayList<String>();
        List<BugzillaFlag> flags = this.getFlags();
        for (TaskAttribute attribute : new HashSet(taskData.getRoot().getAttributes().values())) {
            if (!attribute.getId().startsWith("task.common.attachment")) continue;
            existingFlags.clear();
            for (TaskAttribute attachmentAttribute : attribute.getAttributes().values()) {
                String nameValue;
                TaskAttribute state;
                if (!attachmentAttribute.getId().startsWith("task.common.kind.flag") || (state = attachmentAttribute.getAttribute("state")) == null || existingFlags.contains(nameValue = state.getMetaData().getLabel())) continue;
                existingFlags.add(nameValue);
            }
            TaskAttribute productAttribute = taskData.getRoot().getMappedAttribute(BugzillaAttribute.PRODUCT.getKey());
            TaskAttribute componentAttribute = taskData.getRoot().getMappedAttribute(BugzillaAttribute.COMPONENT.getKey());
            for (BugzillaFlag bugzillaFlag : flags) {
                if (!bugzillaFlag.getType().equals("attachment") || !bugzillaFlag.isUsedIn(productAttribute.getValue(), componentAttribute.getValue()) || existingFlags.contains(bugzillaFlag.getName()) && !bugzillaFlag.isMultiplicable()) continue;
                BugzillaFlagMapper mapper = new BugzillaFlagMapper(connector);
                mapper.setRequestee("");
                mapper.setSetter("");
                mapper.setState(" ");
                mapper.setFlagId(bugzillaFlag.getName());
                mapper.setNumber(0);
                mapper.setDescription(bugzillaFlag.getDescription());
                TaskAttribute newattribute = attribute.createAttribute("task.common.kind.flag_type" + bugzillaFlag.getFlagId());
                mapper.applyTo(newattribute);
            }
        }
    }

    public void setETagValue(String eTagValue) {
        this.eTagValue = eTagValue;
    }

    public String getETagValue() {
        return this.eTagValue;
    }

    public String getDuplicateStatus() {
        return this.validTransitions == null ? IBugzillaConstants.BUGZILLA_REPORT_STATUS.RESOLVED.toString() : this.validTransitions.getDuplicateStatus();
    }

    public String getStartStatus() {
        if (this.validTransitions == null) {
            return this.version.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_4_0) < 0 || !this.getStatusValues().contains(IBugzillaConstants.BUGZILLA_REPORT_STATUS_4_0.IN_PROGRESS.toString()) && !this.getStatusValues().contains(IBugzillaConstants.BUGZILLA_REPORT_STATUS_4_0.CONFIRMED.toString()) ? IBugzillaConstants.BUGZILLA_REPORT_STATUS.NEW.toString() : IBugzillaConstants.BUGZILLA_REPORT_STATUS_4_0.CONFIRMED.toString();
        }
        return this.validTransitions.getStartStatus();
    }

    public String getDefaultMilestones(String product) {
        ProductEntry entry = this.products.get(product);
        if (entry != null) {
            return entry.getDefaultMilestone();
        }
        return null;
    }

    public void setDefaultMilestone(String product, String defaultMilestone) {
        ProductEntry entry = this.products.get(product);
        if (entry == null) {
            entry = new ProductEntry(product);
            this.products.put(product, entry);
        }
        entry.setDefaultMilestone(defaultMilestone);
    }

    public Date getLastModifiedHeader() {
        return this.lastModifiedHeader;
    }

    public void setLastModifiedHeader(Date lastModifiedHeader) {
        this.lastModifiedHeader = lastModifiedHeader;
    }

    public Boolean getUnconfirmedAllowed(String product) {
        ProductEntry entry = this.products.get(product);
        if (entry != null) {
            return entry.getUnconfirmedAllowed();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProductEntry
    implements Serializable {
        private static final long serialVersionUID = 4120139521246741120L;
        String productName;
        List<String> components = new ArrayList<String>();
        List<String> versions = new ArrayList<String>();
        List<String> milestones = new ArrayList<String>();
        String defaultMilestone = null;
        Boolean unconfirmedAllowed = false;

        ProductEntry(String name) {
            this.productName = name;
        }

        List<String> getComponents() {
            return this.components;
        }

        void addComponent(String componentName) {
            if (!this.components.contains(componentName)) {
                this.components.add(componentName);
            }
        }

        List<String> getVersions() {
            return this.versions;
        }

        void addVersion(String name) {
            if (!this.versions.contains(name)) {
                this.versions.add(name);
            }
        }

        List<String> getTargetMilestones() {
            return this.milestones;
        }

        void addTargetMilestone(String target) {
            this.milestones.add(target);
        }

        public String getDefaultMilestone() {
            return this.defaultMilestone;
        }

        public void setDefaultMilestone(String defaultMilestone) {
            this.defaultMilestone = defaultMilestone;
        }

        public Boolean getUnconfirmedAllowed() {
            return this.unconfirmedAllowed;
        }

        public void setUnconfirmedAllowed(Boolean unconfirmedAllowed) {
            this.unconfirmedAllowed = unconfirmedAllowed;
        }
    }
}

