/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.epub.ncx;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BookStruct implements Enumerator
{
    PAGENUMBER(0, "PAGENUMBER", "PAGE_NUMBER"),
    NOTE(1, "NOTE", "NOTE"),
    NOTEREFERENCE(2, "NOTEREFERENCE", "NOTE_REFERENCE"),
    ANNOTATION(3, "ANNOTATION", "ANNOTATION"),
    LINENUMBER(4, "LINENUMBER", "LINE_NUMBER"),
    OPTIONALSIDEBAR(5, "OPTIONALSIDEBAR", "OPTIONAL_SIDEBAR"),
    OPTIONALPRODUCERNOTE(6, "OPTIONALPRODUCERNOTE", "OPTIONAL_PRODUCER_NOTE");

    public static final int PAGENUMBER_VALUE = 0;
    public static final int NOTE_VALUE = 1;
    public static final int NOTEREFERENCE_VALUE = 2;
    public static final int ANNOTATION_VALUE = 3;
    public static final int LINENUMBER_VALUE = 4;
    public static final int OPTIONALSIDEBAR_VALUE = 5;
    public static final int OPTIONALPRODUCERNOTE_VALUE = 6;
    private static final BookStruct[] VALUES_ARRAY;
    public static final List<BookStruct> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BookStruct[]{PAGENUMBER, NOTE, NOTEREFERENCE, ANNOTATION, LINENUMBER, OPTIONALSIDEBAR, OPTIONALPRODUCERNOTE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BookStruct get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BookStruct result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BookStruct getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BookStruct result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BookStruct get(int value) {
        switch (value) {
            case 0: {
                return PAGENUMBER;
            }
            case 1: {
                return NOTE;
            }
            case 2: {
                return NOTEREFERENCE;
            }
            case 3: {
                return ANNOTATION;
            }
            case 4: {
                return LINENUMBER;
            }
            case 5: {
                return OPTIONALSIDEBAR;
            }
            case 6: {
                return OPTIONALPRODUCERNOTE;
            }
        }
        return null;
    }

    private BookStruct(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

