/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.git.core;

import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.mylyn.internal.git.core.GitConnector;
import org.eclipse.mylyn.versions.core.ScmRepository;

public class GitRepository
extends ScmRepository {
    private final RepositoryMapping mapping;

    public GitRepository(GitConnector connector, RepositoryMapping mapping) {
        this.mapping = mapping;
        this.setConnector(connector);
    }

    public Repository getRepository() {
        return this.mapping.getRepository();
    }

    public RepositoryMapping getMapping() {
        return this.mapping;
    }

    public String getUrl() {
        String originUrl = this.getRepository().getConfig().getString("remote", "origin", "url");
        if (originUrl != null) {
            return originUrl;
        }
        return super.getUrl();
    }

    public String getWorkspaceRevision(IResource resource) {
        return null;
    }

    public String convertWorkspacePath(IResource resource) {
        return this.mapping.getRepoRelativePath(resource);
    }
}

