/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.internal.core.operations;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.spi.RunBuildRequest;
import org.eclipse.mylyn.builds.internal.core.BuildServer;
import org.eclipse.mylyn.builds.internal.core.operations.AbstractElementOperation;
import org.eclipse.mylyn.builds.internal.core.operations.BuildJob;
import org.eclipse.mylyn.builds.internal.core.operations.IOperationService;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunBuildOperation
extends AbstractElementOperation<IBuildPlan> {
    private final RunBuildRequest request;
    private final BuildServer server;

    public RunBuildOperation(IOperationService service, RunBuildRequest request) {
        super(service);
        Assert.isNotNull((Object)request);
        this.request = request;
        this.server = (BuildServer)request.getPlan().getServer();
    }

    @Override
    protected BuildJob doCreateJob(IBuildPlan element) {
        return new BuildJob(NLS.bind((String)"Running Build {0}", (Object)element.getLabel())){

            protected IStatus doExecute(IOperationMonitor progress) {
                MultiStatus result = new MultiStatus("org.eclipse.mylyn.builds.core", 0, "Running of build failed", null);
                try {
                    RunBuildOperation.this.server.getBehaviour().runBuild(RunBuildOperation.this.request, progress);
                }
                catch (CoreException e) {
                    result.add((IStatus)new Status(4, "org.eclipse.mylyn.builds.core", NLS.bind((String)"Running build ''{0}'' failed", (Object)RunBuildOperation.this.request.getPlan().getName()), (Throwable)e));
                }
                catch (OperationCanceledException operationCanceledException) {
                    return Status.CANCEL_STATUS;
                }
                this.setStatus((IStatus)result);
                return Status.OK_STATUS;
            }
        };
    }

    @Override
    protected List<IBuildPlan> doSyncInitInput() {
        return Collections.singletonList(this.request.getPlan());
    }
}

