/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskAttributeMapper {
    private final TaskRepository taskRepository;

    public TaskAttributeMapper(TaskRepository taskRepository) {
        Assert.isNotNull((Object)((Object)taskRepository));
        this.taskRepository = taskRepository;
    }

    public TaskAttribute createTaskAttachment(TaskData taskData) {
        TaskAttribute taskAttribute = taskData.getRoot().createAttribute(this.mapToRepositoryKey(taskData.getRoot(), "task.common.new.attachment"));
        return taskAttribute;
    }

    public boolean equals(TaskAttribute newAttribute, TaskAttribute oldAttribute) {
        if ("comment".equals(newAttribute.getMetaData().getType())) {
            if (newAttribute.getValues().equals(oldAttribute.getValues())) {
                return true;
            }
            if (oldAttribute != null) {
                TaskAttribute commentIdAttribute = oldAttribute.getAttribute("task.common.comment.id");
                if ((commentIdAttribute == null || commentIdAttribute.getValue().equals("")) && newAttribute.getValue().equals("")) {
                    return true;
                }
                if (commentIdAttribute != null && commentIdAttribute.getValue().equals(newAttribute.getValue())) {
                    return true;
                }
            }
        }
        return newAttribute.getValues().equals(oldAttribute.getValues());
    }

    public TaskAttribute getAssoctiatedAttribute(TaskAttribute taskAttribute) {
        String id = taskAttribute.getMetaDatum("task.meta.associated.attribute");
        if (id != null) {
            TaskAttribute associatedAttribute = taskAttribute.getAttribute(id);
            if (associatedAttribute != null) {
                return associatedAttribute;
            }
            return taskAttribute.getTaskData().getRoot().getAttribute(id);
        }
        return null;
    }

    public TaskAttribute getAssoctiatedAttribute(TaskOperation taskOperation) {
        TaskAttribute taskAttribute = taskOperation.getTaskAttribute();
        if (taskAttribute != null) {
            return this.getAssoctiatedAttribute(taskAttribute);
        }
        return null;
    }

    public List<TaskAttribute> getAttributesByType(TaskData taskData, String type) {
        Assert.isNotNull((Object)taskData);
        Assert.isNotNull((Object)type);
        ArrayList<TaskAttribute> result = new ArrayList<TaskAttribute>();
        for (TaskAttribute taskAttribute : taskData.getRoot().getAttributes().values()) {
            if (!type.equals(taskAttribute.getMetaData().getType())) continue;
            result.add(taskAttribute);
        }
        return result;
    }

    public boolean getBooleanValue(TaskAttribute attribute) {
        String booleanString = attribute.getValue();
        if (booleanString != null && booleanString.length() > 0) {
            return Boolean.parseBoolean(booleanString);
        }
        return false;
    }

    public Date getDateValue(TaskAttribute attribute) {
        String dateString = attribute.getValue();
        try {
            if (dateString != null && dateString.length() > 0) {
                return new Date(Long.parseLong(dateString));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }

    @Deprecated
    public String getDefaultOption(TaskAttribute taskAttribute) {
        return taskAttribute.getMetaData().getDefaultOption();
    }

    public Double getDoubleValue(TaskAttribute attribute) {
        String doubleString = attribute.getValue();
        try {
            if (doubleString != null) {
                return Double.parseDouble(doubleString);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }

    public Integer getIntegerValue(TaskAttribute attribute) {
        String integerString = attribute.getValue();
        try {
            if (integerString != null) {
                return Integer.parseInt(integerString);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }

    public String getLabel(TaskAttribute taskAttribute) {
        return taskAttribute.getMetaData().getLabel();
    }

    public Long getLongValue(TaskAttribute attribute) {
        String longString = attribute.getValue();
        try {
            if (longString != null) {
                return Long.parseLong(longString);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }

    public Map<String, String> getOptions(TaskAttribute attribute) {
        return attribute.getOptions();
    }

    public IRepositoryPerson getRepositoryPerson(TaskAttribute taskAttribute) {
        IRepositoryPerson person = this.taskRepository.createPerson(taskAttribute.getValue());
        TaskAttribute child = taskAttribute.getMappedAttribute("task.common.person.name");
        if (child != null) {
            person.setName(this.getValue(child));
        }
        return person;
    }

    public List<TaskOperation> getTaskOperations(TaskAttribute operationsAttribute) {
        Assert.isNotNull((Object)operationsAttribute);
        TaskData taskData = operationsAttribute.getTaskData();
        ArrayList<TaskOperation> result = new ArrayList<TaskOperation>();
        for (TaskAttribute taskAttribute : taskData.getRoot().getAttributes().values()) {
            if (!"operation".equals(taskAttribute.getMetaData().getType()) || taskAttribute.getId().equals(this.mapToRepositoryKey(taskData.getRoot(), "task.common.operation"))) continue;
            result.add(TaskOperation.createFrom(taskAttribute));
        }
        return result;
    }

    public TaskOperation getTaskOperation(TaskAttribute taskAttribute) {
        Assert.isNotNull((Object)taskAttribute);
        return TaskOperation.createFrom(taskAttribute);
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    public String getValue(TaskAttribute taskAttribute) {
        return taskAttribute.getValue();
    }

    public String getValueLabel(TaskAttribute taskAttribute) {
        List<String> labels = this.getValueLabels(taskAttribute);
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (String value : labels) {
            sb.append(sep).append(value);
            sep = ", ";
        }
        return sb.toString();
    }

    public List<String> getValueLabels(TaskAttribute taskAttribute) {
        List<String> values = taskAttribute.getValues();
        Map<String, String> options = this.getOptions(taskAttribute);
        ArrayList<String> result = new ArrayList<String>(values.size());
        for (String value : values) {
            String option = options.get(value);
            if (option != null) {
                value = option;
            }
            result.add(value);
        }
        return result;
    }

    public List<String> getValues(TaskAttribute attribute) {
        return new ArrayList<String>(attribute.getValues());
    }

    public boolean hasValue(TaskAttribute attribute) {
        return attribute.getValues().size() > 0;
    }

    public String mapToRepositoryKey(TaskAttribute parent, String key) {
        return key;
    }

    public void setBooleanValue(TaskAttribute attribute, Boolean value) {
        attribute.setValue(Boolean.toString(value));
    }

    public void setDateValue(TaskAttribute attribute, Date date) {
        if (date != null) {
            attribute.setValue(Long.toString(date.getTime()));
        } else {
            attribute.clearValues();
        }
    }

    public void setDoubleValue(TaskAttribute attribute, Double value) {
        if (value != null) {
            attribute.setValue(value.toString());
        } else {
            attribute.clearValues();
        }
    }

    public void setIntegerValue(TaskAttribute attribute, Integer value) {
        if (value != null) {
            attribute.setValue(value.toString());
        } else {
            attribute.clearValues();
        }
    }

    public void setLongValue(TaskAttribute attribute, Long value) {
        if (value != null) {
            attribute.setValue(value.toString());
        } else {
            attribute.clearValues();
        }
    }

    public void setRepositoryPerson(TaskAttribute taskAttribute, IRepositoryPerson person) {
        this.setValue(taskAttribute, person.getPersonId());
        if (person.getName() != null) {
            TaskAttribute child = taskAttribute.createAttribute("task.common.person.name");
            this.setValue(child, person.getName());
        }
    }

    public void setTaskOperation(TaskAttribute taskAttribute, TaskOperation taskOperation) {
        Assert.isNotNull((Object)taskAttribute);
        Assert.isNotNull((Object)taskOperation);
        TaskOperation.applyTo(taskAttribute, taskOperation.getOperationId(), taskOperation.getLabel());
    }

    public void setValue(TaskAttribute attribute, String value) {
        attribute.setValue(value);
    }

    public void setValues(TaskAttribute attribute, List<String> values) {
        attribute.setValues(values);
    }

    public void updateTaskAttachment(ITaskAttachment taskAttachment, TaskAttribute taskAttribute) {
        TaskAttachmentMapper.createFrom(taskAttribute).applyTo(taskAttachment);
    }

    public void updateTaskComment(ITaskComment taskComment, TaskAttribute taskAttribute) {
        TaskCommentMapper.createFrom(taskAttribute).applyTo(taskComment);
    }
}

