/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.net.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.PostMethod;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.commons.net.http.CommonHttpMethod3;

public class CommonPostMethod3
extends PostMethod
implements CommonHttpMethod3 {
    private boolean gzipAccepted;
    private boolean gzipReceived;
    private InputStream inputStream;
    private final Object releaseLock = new Object();

    public CommonPostMethod3() {
        this.init();
    }

    public CommonPostMethod3(String requestPath) {
        super(requestPath);
        this.init();
    }

    public int execute(HttpState state, HttpConnection conn) throws HttpException, IOException {
        if (this.gzipAccepted) {
            this.setRequestHeader("Accept-encoding", "gzip");
        }
        return super.execute(state, conn);
    }

    public InputStream getResponseBodyAsStream(IProgressMonitor monitor) throws IOException {
        if (this.inputStream == null) {
            this.inputStream = WebUtil.getResponseBodyAsStream((HttpMethodBase)this, monitor);
        }
        this.gzipReceived = this.isZippedResponse();
        if (this.gzipReceived) {
            this.inputStream = new GZIPInputStream(this.inputStream);
        }
        return this.inputStream;
    }

    private void init() {
        this.gzipAccepted = true;
    }

    public final boolean isGzipAccepted() {
        return this.gzipAccepted;
    }

    private boolean isZippedResponse() {
        return this.getResponseHeader("Content-Encoding") != null && this.getResponseHeader("Content-Encoding").getValue().equals("gzip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection() {
        Object object = this.releaseLock;
        synchronized (object) {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {}
                this.inputStream = null;
            }
            super.releaseConnection();
        }
    }

    public void releaseConnection(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            this.abort();
        } else {
            try {
                this.releaseConnection();
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    protected void responseBodyConsumed() {
        super.responseBodyConsumed();
    }

    public final void setGzipAccepted(boolean gzipAccepted) {
        this.gzipAccepted = gzipAccepted;
    }
}

