/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.textile.core;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.core.parser.builder.AbstractMarkupDocumentBuilder;

public class TextileDocumentBuilder
extends AbstractMarkupDocumentBuilder {
    private static final Pattern PATTERN_MULTIPLE_NEWLINES = Pattern.compile("(\r\n|\r|\n){2,}");
    private final Map<String, String> entityToLiteral = new HashMap<String, String>();
    private boolean previousWasExtended;
    private boolean emitAttributes;

    public TextileDocumentBuilder(Writer out) {
        super(out);
        this.entityToLiteral.put("nbsp", " ");
        this.entityToLiteral.put("#160", " ");
        this.entityToLiteral.put("quot", "\"");
        this.entityToLiteral.put("amp", "&");
        this.entityToLiteral.put("lt", "<");
        this.entityToLiteral.put("gt", ">");
        this.entityToLiteral.put("copy", "(c)");
        this.entityToLiteral.put("reg", "(r)");
        this.entityToLiteral.put("#8482", "(t)");
        this.entityToLiteral.put("euro", "\u20ac");
        this.entityToLiteral.put("#36", "$");
        this.entityToLiteral.put("#37", "%");
        this.emitAttributes = true;
    }

    protected AbstractMarkupDocumentBuilder.Block computeBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        switch (type) {
            case NUMERIC_LIST: 
            case BULLETED_LIST: 
            case DEFINITION_LIST: {
                return new AbstractMarkupDocumentBuilder.SuffixBlock((AbstractMarkupDocumentBuilder)this, type, "\n");
            }
            case CODE: {
                return new ContentBlock(type, "bc. ", "\n\n", false, false);
            }
            case LIST_ITEM: 
            case DEFINITION_TERM: 
            case DEFINITION_ITEM: {
                char prefixChar = this.computeCurrentListType() == DocumentBuilder.BlockType.NUMERIC_LIST ? (char)'#' : '*';
                return new ContentBlock(type, String.valueOf(this.computePrefix(prefixChar, this.computeListLevel())) + " ", "\n", false, true);
            }
            case DIV: {
                if (this.currentBlock == null) {
                    return new ContentBlock(type, "", "\n", false, false);
                }
                return new ContentBlock(type, "", "", false, false);
            }
            case FOOTNOTE: {
                return new ContentBlock(type, "fn1. ", "\n\n", false, false);
            }
            case TIP: 
            case WARNING: 
            case INFORMATION: 
            case NOTE: 
            case PANEL: {
                attributes.appendCssClass(type.name().toLowerCase());
            }
            case PARAGRAPH: {
                String attributesMarkup = this.computeAttributes(attributes);
                return new ContentBlock(type, attributesMarkup.length() > 0 || this.previousWasExtended ? "p" + attributesMarkup + ". " : attributesMarkup, "\n\n", false, false);
            }
            case PREFORMATTED: {
                return new ContentBlock(type, "pre" + this.computeAttributes(attributes) + ". ", "\n\n", false, false);
            }
            case QUOTE: {
                return new ContentBlock(type, "bq" + this.computeAttributes(attributes) + ". ", "\n\n", false, false);
            }
            case TABLE: {
                return new AbstractMarkupDocumentBuilder.SuffixBlock((AbstractMarkupDocumentBuilder)this, type, "\n");
            }
            case TABLE_CELL_HEADER: 
            case TABLE_CELL_NORMAL: {
                return new TableCellBlock(type);
            }
            case TABLE_ROW: {
                return new AbstractMarkupDocumentBuilder.SuffixBlock((AbstractMarkupDocumentBuilder)this, type, "|\n");
            }
        }
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).warning("Unexpected block type: " + type);
        return new ContentBlock(type, "", "", false, false);
    }

    protected AbstractMarkupDocumentBuilder.Block computeSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        ContentBlock block;
        String appendStyle = null;
        switch (type) {
            case UNDERLINED: {
                appendStyle = "text-decoration:underline;";
                break;
            }
            case MONOSPACE: {
                appendStyle = "text-decoration:underline;";
            }
        }
        if (appendStyle != null) {
            attributes = new Attributes(attributes.getId(), attributes.getCssClass(), attributes.getCssStyle(), attributes.getLanguage());
            attributes.appendCssStyle(appendStyle);
        }
        String spanAttributes = this.computeAttributes(attributes);
        switch (type) {
            case BOLD: {
                block = new ContentBlock("*" + spanAttributes, "*", true, false);
                break;
            }
            case CITATION: {
                block = new ContentBlock("??" + spanAttributes, "??", true, false);
                break;
            }
            case DELETED: {
                block = new ContentBlock("-" + spanAttributes, "-", true, false);
                break;
            }
            case EMPHASIS: {
                block = new ContentBlock("_" + spanAttributes, "_", true, false);
                break;
            }
            case INSERTED: {
                block = new ContentBlock("+" + spanAttributes, "+", true, false);
                break;
            }
            case CODE: {
                block = new ContentBlock("@" + spanAttributes, "@", true, false);
                break;
            }
            case ITALIC: {
                block = new ContentBlock("__" + spanAttributes, "__", true, false);
                break;
            }
            case LINK: {
                if (attributes instanceof LinkAttributes) {
                    block = new LinkBlock((LinkAttributes)attributes);
                    break;
                }
                block = new SpanBlock(spanAttributes, true, false);
                break;
            }
            case MONOSPACE: {
                block = new SpanBlock(spanAttributes, true, false);
            }
            case STRONG: {
                block = new ContentBlock("*" + spanAttributes, "*", true, false);
                break;
            }
            case SUBSCRIPT: {
                block = new ContentBlock("^" + spanAttributes, "^", true, false);
                break;
            }
            case SUPERSCRIPT: {
                block = new ContentBlock("~" + spanAttributes, "~", true, false);
                break;
            }
            default: {
                block = spanAttributes.length() == 0 ? new SpanBlock("", false, false) : new SpanBlock(spanAttributes, true, false);
            }
        }
        return block;
    }

    private String computeAttributes(Attributes attributes) {
        String attributeMarkup = "";
        if (this.emitAttributes) {
            String classId = "";
            if (attributes.getCssClass() != null) {
                classId = attributes.getCssClass();
            }
            if (attributes.getId() != null) {
                classId = String.valueOf(classId) + "#" + attributes.getId();
            }
            if (classId.length() > 0) {
                attributeMarkup = String.valueOf(attributeMarkup) + "(" + classId + ")";
            }
            if (attributes.getCssStyle() != null) {
                attributeMarkup = String.valueOf(attributeMarkup) + "{" + attributes.getCssStyle() + "}";
            }
        }
        return attributeMarkup;
    }

    protected ContentBlock computeHeading(int level, Attributes attributes) {
        return new ContentBlock("h" + level + ". ", "\n\n", false, false);
    }

    public void characters(String text) {
        this.assertOpenBlock();
        try {
            int x = 0;
            while (x < text.length()) {
                char c = text.charAt(x);
                switch (c) {
                    case '\u00a0': {
                        this.currentBlock.write(32);
                        break;
                    }
                    case '\u00a9': {
                        this.currentBlock.write("(c)");
                        break;
                    }
                    case '\u00ae': {
                        this.currentBlock.write("(r)");
                        break;
                    }
                    default: {
                        this.currentBlock.write((int)c);
                    }
                }
                ++x;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void entityReference(String entity) {
        this.assertOpenBlock();
        String literal = this.entityToLiteral.get(entity);
        if (literal == null) {
            literal = "&" + entity + ";";
        }
        try {
            this.currentBlock.write(literal);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void image(Attributes attributes, String url) {
        this.assertOpenBlock();
        try {
            this.currentBlock.write(33);
            this.writeAttributes(attributes);
            this.currentBlock.write(url);
            this.currentBlock.write(33);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void link(Attributes attributes, String hrefOrHashName, String text) {
        this.assertOpenBlock();
        try {
            this.currentBlock.write(34);
            this.writeAttributes(attributes);
            this.currentBlock.write(text);
            this.currentBlock.write(34);
            this.currentBlock.write(58);
            this.currentBlock.write(hrefOrHashName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        this.assertOpenBlock();
        try {
            this.currentBlock.write(33);
            this.writeAttributes(imageAttributes);
            this.currentBlock.write(imageUrl);
            this.currentBlock.write(33);
            this.currentBlock.write(58);
            this.currentBlock.write(href);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void acronym(String text, String definition) {
        this.assertOpenBlock();
        try {
            this.currentBlock.write(text);
            this.currentBlock.write(40);
            this.currentBlock.write(definition);
            this.currentBlock.write(41);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void lineBreak() {
        this.assertOpenBlock();
        try {
            this.currentBlock.write(10);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeAttributes(Attributes attributes) {
        if (!this.emitAttributes) {
            return;
        }
        try {
            this.currentBlock.write(this.computeAttributes(attributes));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isEmitAttributes() {
        return this.emitAttributes;
    }

    public void setEmitAttributes(boolean emitAttributes) {
        this.emitAttributes = emitAttributes;
    }

    private class ContentBlock
    extends AbstractMarkupDocumentBuilder.Block {
        protected final String prefix;
        protected final String suffix;
        protected final boolean requireAdjacentSeparator;
        protected final boolean emitWhenEmpty;

        ContentBlock(DocumentBuilder.BlockType blockType, String prefix, String suffix, boolean requireAdjacentSeparator, boolean emitWhenEmpty) {
            super((AbstractMarkupDocumentBuilder)TextileDocumentBuilder.this, blockType);
            this.prefix = prefix;
            this.suffix = suffix;
            this.requireAdjacentSeparator = requireAdjacentSeparator;
            this.emitWhenEmpty = emitWhenEmpty;
        }

        ContentBlock(String prefix, String suffix, boolean requireAdjacentWhitespace, boolean emitWhenEmpty) {
            this(null, prefix, suffix, requireAdjacentWhitespace, emitWhenEmpty);
        }

        public void write(int c) throws IOException {
            if (this.getBlockType() != DocumentBuilder.BlockType.CODE && this.getBlockType() != DocumentBuilder.BlockType.PREFORMATTED) {
                c = TextileDocumentBuilder.this.normalizeWhitespace(c);
            }
            TextileDocumentBuilder.this.emitContent(c);
        }

        public void write(String s) throws IOException {
            if (this.getBlockType() != DocumentBuilder.BlockType.CODE && this.getBlockType() != DocumentBuilder.BlockType.PREFORMATTED) {
                s = TextileDocumentBuilder.this.normalizeWhitespace(s);
            }
            TextileDocumentBuilder.this.emitContent(s);
        }

        public void open() throws IOException {
            super.open();
            TextileDocumentBuilder.this.pushWriter(new StringWriter());
            if (this.requireAdjacentSeparator) {
                TextileDocumentBuilder.this.clearRequireAdjacentSeparator();
            }
        }

        public void close() throws IOException {
            Writer thisContent = TextileDocumentBuilder.this.popWriter();
            String content = thisContent.toString();
            boolean extendedBlock = this.isExtended(content);
            if (content.length() > 0 || this.emitWhenEmpty) {
                if (this.requireAdjacentSeparator) {
                    TextileDocumentBuilder.this.requireAdjacentSeparator();
                }
                this.emitContent(content, extendedBlock);
                if (this.requireAdjacentSeparator) {
                    TextileDocumentBuilder.this.requireAdjacentSeparator();
                }
            }
            super.close();
            if (this.getBlockType() != null) {
                TextileDocumentBuilder.this.previousWasExtended = extendedBlock;
            }
        }

        protected void emitContent(String content, boolean extended) throws IOException {
            String prefix = extended ? this.prefix.replace(".", "..") : this.prefix;
            String suffix = extended ? String.valueOf(this.suffix) + "\n" : this.suffix;
            TextileDocumentBuilder.this.emitContent(prefix);
            TextileDocumentBuilder.this.emitContent(content);
            TextileDocumentBuilder.this.emitContent(suffix);
        }

        private boolean isExtended(String content) {
            if (this.getBlockType() != null) {
                switch (this.getBlockType()) {
                    case QUOTE: 
                    case CODE: 
                    case PREFORMATTED: {
                        return PATTERN_MULTIPLE_NEWLINES.matcher(content).find();
                    }
                }
            }
            return false;
        }
    }

    private class LinkBlock
    extends ContentBlock {
        private final LinkAttributes attributes;

        private LinkBlock(LinkAttributes attributes) {
            super(null, "", "", true, true);
            this.attributes = attributes;
        }

        protected void emitContent(String content, boolean extended) throws IOException {
            if (content.matches("!.*?!")) {
                TextileDocumentBuilder.this.emitContent(content);
            } else {
                TextileDocumentBuilder.this.emitContent(34);
                TextileDocumentBuilder.this.emitContent(content);
                TextileDocumentBuilder.this.emitContent(34);
            }
            TextileDocumentBuilder.this.emitContent(58);
            TextileDocumentBuilder.this.emitContent(this.attributes.getHref());
        }
    }

    private class SpanBlock
    extends ContentBlock {
        public SpanBlock(String spanAttributes, boolean requireAdjacentWhitespace, boolean emitWhenEmpty) {
            super(null, "%" + spanAttributes, "%", requireAdjacentWhitespace, emitWhenEmpty);
        }

        protected void emitContent(String content, boolean extended) throws IOException {
            boolean nestedSpan = this.computeNestedSpan();
            if (!nestedSpan) {
                String prefix = extended ? this.prefix.replace(".", "..") : this.prefix;
                TextileDocumentBuilder.this.emitContent(prefix);
            }
            TextileDocumentBuilder.this.emitContent(content);
            if (!nestedSpan) {
                String suffix = extended ? String.valueOf(this.suffix) + "\n" : this.suffix;
                TextileDocumentBuilder.this.emitContent(suffix);
            }
        }

        private boolean computeNestedSpan() {
            AbstractMarkupDocumentBuilder.Block block = this.getPreviousBlock();
            while (block != null) {
                if (block instanceof SpanBlock) {
                    return true;
                }
                block = block.getPreviousBlock();
            }
            return false;
        }
    }

    private class TableCellBlock
    extends ContentBlock {
        public TableCellBlock(DocumentBuilder.BlockType blockType) {
            super(blockType, blockType == DocumentBuilder.BlockType.TABLE_CELL_NORMAL ? "|" : "|_.", "", false, true);
        }

        protected void emitContent(String content, boolean extended) throws IOException {
            if (content.length() == 0) {
                content = " ";
            }
            super.emitContent(content, extended);
        }
    }
}

