/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.commons.core.ICoreRunnable;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AutomaticRepositoryTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ITaskListRunnable;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.UncategorizedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnsubmittedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.sync.DeleteTasksJob;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.internal.WorkbenchImages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteAction
extends BaseSelectionListenerAction {
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.delete";

    public DeleteAction() {
        super(Messages.DeleteAction_Delete);
        this.setId(ID);
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_DELETE"));
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    public void run() {
        this.doDelete(this.getStructuredSelection().toList());
    }

    protected void doDelete(List<?> toDelete) {
        boolean allLocalTasks = true;
        boolean allSupportRepositoryDeletion = true;
        boolean allElementsAreTasks = true;
        for (Object object : toDelete) {
            if (object instanceof ITask) {
                ITask task = (ITask)object;
                AbstractRepositoryConnector repositoryConnector = TasksUi.getRepositoryConnector(task.getConnectorKind());
                TaskRepository repository = TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
                allSupportRepositoryDeletion = repository != null && repositoryConnector != null ? (allSupportRepositoryDeletion &= repositoryConnector.canDeleteTask(repository, task)) : false;
                allLocalTasks &= task instanceof LocalTask;
                continue;
            }
            allElementsAreTasks = false;
        }
        String elements = this.buildElementListString(toDelete);
        String message = this.buildMessage(toDelete, elements, allElementsAreTasks);
        if (toDelete.isEmpty()) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.DeleteAction_Delete_failed, (String)Messages.DeleteAction_Nothing_selected);
        } else {
            boolean deleteConfirmed = false;
            boolean deleteOnServer = false;
            final boolean allTasksDeletable = allSupportRepositoryDeletion;
            if (allLocalTasks || !allElementsAreTasks) {
                deleteConfirmed = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.DeleteAction_Delete_Tasks, (String)message);
            } else {
                String toggleMessage = Messages.DeleteAction_Also_delete_from_repository_X;
                toggleMessage = allTasksDeletable ? NLS.bind((String)toggleMessage, (Object)"") : NLS.bind((String)toggleMessage, (Object)Messages.DeleteAction_Not_supported);
                MessageDialogWithToggle dialog = new MessageDialogWithToggle(WorkbenchUtil.getShell(), Messages.DeleteAction_Delete_Tasks, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0, toggleMessage, false){

                    protected Control createContents(Composite parent) {
                        Control createdControl = super.createContents(parent);
                        this.getToggleButton().setEnabled(allTasksDeletable);
                        return createdControl;
                    }
                };
                deleteConfirmed = dialog.open() == 2;
                boolean bl = deleteOnServer = dialog.getToggleState() && allTasksDeletable;
            }
            if (deleteConfirmed) {
                this.deleteElements(toDelete, deleteOnServer);
            }
        }
    }

    private void deleteElements(final List<?> toDelete, final boolean deleteOnServer) {
        ICoreRunnable op = new ICoreRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask(Messages.DeleteAction_Delete_in_progress, -1);
                    DeleteAction.prepareDeletion(toDelete);
                    TasksUiPlugin.getTaskList().run(new ITaskListRunnable(){

                        public void execute(IProgressMonitor monitor) throws CoreException {
                            DeleteAction.performDeletion(toDelete);
                            if (deleteOnServer) {
                                DeleteAction.this.performDeletionFromServer(toDelete);
                            }
                        }
                    }, monitor);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            WorkbenchUtil.runInUi((ICoreRunnable)op, null);
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)"Problems encountered deleting task list elements: {0}", (Object)e.getMessage()), (Throwable)e);
            TasksUiInternal.logAndDisplayStatus(Messages.DeleteTaskRepositoryAction_Delete_Task_Repository_Failed, (IStatus)status);
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    private String buildMessage(List<?> toDelete, String elements, boolean allElementsAreTasks) {
        Object object;
        String message = toDelete.size() == 1 ? ((object = toDelete.get(0)) instanceof ITask ? ((AbstractTask)object instanceof LocalTask ? Messages.DeleteAction_Permanently_delete_from_task_list : Messages.DeleteAction_Delete_task_from_task_list_context_planning_deleted) : (object instanceof TaskCategory ? Messages.DeleteAction_Permanently_delete_the_category : (object instanceof IRepositoryQuery ? Messages.DeleteAction_Permanently_delete_the_query : (object instanceof UnmatchedTaskContainer ? Messages.DeleteAction_Delete_the_planning_information_and_context_of_all_unmatched_tasks : (object instanceof UnsubmittedTaskContainer ? Messages.DeleteAction_Delete_all_of_the_unsubmitted_tasks : Messages.DeleteAction_Permanently_delete_the_element_listed_below))))) : (allElementsAreTasks ? Messages.DeleteAction_Delete_tasks_from_task_list_context_planning_deleted : Messages.DeleteAction_Delete_elements_from_task_list_context_planning_deleted);
        message = String.valueOf(message) + "\n\n" + elements;
        return message;
    }

    private String buildElementListString(List<?> toDelete) {
        String elements = "";
        int i = 0;
        for (Object object : toDelete) {
            if (object instanceof UnmatchedTaskContainer) continue;
            if (++i < 20) {
                if (!(object instanceof IRepositoryElement)) continue;
                elements = String.valueOf(elements) + "    " + ((IRepositoryElement)object).getSummary() + "\n";
                continue;
            }
            elements = String.valueOf(elements) + "...";
            break;
        }
        return elements;
    }

    public static void prepareDeletion(Collection<?> toDelete) {
        for (Object selectedObject : toDelete) {
            if (selectedObject instanceof AbstractTask) {
                AbstractTask task = (AbstractTask)selectedObject;
                TasksUi.getTaskActivityManager().deactivateTask((ITask)task);
                TasksUiInternal.closeTaskEditorInAllPages((ITask)task, false);
                continue;
            }
            if (!(selectedObject instanceof AutomaticRepositoryTaskContainer) || toDelete.size() != 1) continue;
            DeleteAction.prepareDeletion(((AutomaticRepositoryTaskContainer)selectedObject).getChildren());
        }
    }

    public static void performDeletion(Collection<?> toDelete) {
        block2: for (Object selectedObject : toDelete) {
            if (selectedObject instanceof AbstractTask) {
                AbstractTask task = (AbstractTask)selectedObject;
                TasksUiInternal.getTaskList().deleteTask((ITask)task);
                try {
                    TasksUiPlugin.getTaskDataManager().deleteTaskData((ITask)task);
                }
                catch (CoreException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to delete task data", (Throwable)e));
                }
                TasksUiPlugin.getContextStore().deleteContext((ITask)task);
                continue;
            }
            if (selectedObject instanceof IRepositoryQuery) {
                TasksUiInternal.getTaskList().deleteQuery((RepositoryQuery)selectedObject);
                continue;
            }
            if (selectedObject instanceof TaskCategory) {
                TasksUiInternal.getTaskList().deleteCategory((AbstractTaskCategory)((TaskCategory)selectedObject));
                continue;
            }
            if (!(selectedObject instanceof AutomaticRepositoryTaskContainer) || toDelete.size() != 1) continue;
            int i = 0;
            while (i < 5) {
                Collection children = ((AutomaticRepositoryTaskContainer)selectedObject).getChildren();
                if (children.isEmpty()) continue block2;
                DeleteAction.performDeletion(children);
                ++i;
            }
        }
    }

    private void performDeletionFromServer(List<?> toDelete) {
        ArrayList<ITask> tasksToDelete = new ArrayList<ITask>();
        for (Object element : toDelete) {
            if (!(element instanceof ITask)) continue;
            tasksToDelete.add((ITask)element);
        }
        final DeleteTasksJob deleteTaskJob = new DeleteTasksJob(Messages.DeleteAction_Deleting_tasks_from_repositories, tasksToDelete, TasksUi.getRepositoryManager());
        deleteTaskJob.setPriority(10);
        deleteTaskJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (deleteTaskJob.getStatus() != null && !deleteTaskJob.getStatus().isOK()) {
                    StatusHandler.log((IStatus)deleteTaskJob.getStatus());
                }
            }
        });
        deleteTaskJob.setUser(true);
        deleteTaskJob.schedule();
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        List elements = selection.toList();
        for (Object object : elements) {
            if (!(object instanceof UncategorizedTaskContainer)) continue;
            return false;
        }
        return true;
    }
}

