/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.commands;

import java.util.Collections;
import java.util.Date;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.ClearOutgoingAction;
import org.eclipse.mylyn.internal.tasks.ui.commands.AbstractTaskHandler;
import org.eclipse.mylyn.internal.tasks.ui.commands.AbstractTaskListViewHandler;
import org.eclipse.mylyn.internal.tasks.ui.commands.GoToUnreadTaskHandler;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.util.TreeWalker;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.monitor.ui.MonitorUi;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.swt.widgets.Shell;

public abstract class MarkTaskHandler
extends AbstractTaskHandler {

    public static class ClearActiveTimeHandler
    extends AbstractTaskHandler {
        public ClearActiveTimeHandler() {
            this.setFilterBasedOnActiveTaskList(true);
        }

        protected void execute(ExecutionEvent event, ITask task) throws ExecutionException {
            if (MessageDialog.openConfirm((Shell)WorkbenchUtil.getShell(), (String)Messages.TaskEditorPlanningPart_Confirm_Activity_Time_Deletion, (String)Messages.TaskEditorPlanningPart_Do_you_wish_to_reset_your_activity_time_on_this_task_)) {
                MonitorUi.getActivityContextManager().removeActivityTime(task.getHandleIdentifier(), 0L, System.currentTimeMillis());
            }
        }
    }

    public static class ClearOutgoingHandler
    extends AbstractTaskHandler {
        public ClearOutgoingHandler() {
            this.setFilterBasedOnActiveTaskList(true);
        }

        protected void execute(ExecutionEvent event, ITask task) throws ExecutionException {
            ClearOutgoingAction action = new ClearOutgoingAction(Collections.singletonList(task));
            if (action.isEnabled()) {
                action.run();
            }
        }
    }

    public static class MarkTaskCompleteHandler
    extends AbstractTaskHandler {
        public static final String ID_COMMAND = "org.eclipse.mylyn.tasks.ui.command.markTaskComplete";

        public MarkTaskCompleteHandler() {
            this.setFilterBasedOnActiveTaskList(true);
        }

        protected void execute(ExecutionEvent event, ITask task) throws ExecutionException {
            if (TasksUiInternal.hasLocalCompletionState(task)) {
                task.setCompletionDate(new Date());
                TasksUiPlugin.getTaskList().notifyElementChanged((IRepositoryElement)task);
            }
        }
    }

    public static class MarkTaskIncompleteHandler
    extends AbstractTaskHandler {
        public MarkTaskIncompleteHandler() {
            this.setFilterBasedOnActiveTaskList(true);
        }

        protected void execute(ExecutionEvent event, ITask task) throws ExecutionException {
            if (TasksUiInternal.hasLocalCompletionState(task)) {
                task.setCompletionDate(null);
                TasksUiPlugin.getTaskList().notifyElementChanged((IRepositoryElement)task);
            }
        }
    }

    public static class MarkTaskReadGoToNextUnreadTaskHandler
    extends AbstractTaskListViewHandler {
        protected void execute(ExecutionEvent event, TaskListView taskListView, IRepositoryElement item) throws ExecutionException {
            if (item instanceof ITask) {
                ITask task = (ITask)item;
                TasksUiPlugin.getTaskDataManager().setTaskRead(task, true);
                GoToUnreadTaskHandler.execute(event, TreeWalker.Direction.DOWN);
            }
        }
    }

    public static class MarkTaskReadGoToPreviousUnreadTaskHandler
    extends AbstractTaskListViewHandler {
        protected void execute(ExecutionEvent event, TaskListView taskListView, IRepositoryElement item) throws ExecutionException {
            if (item instanceof ITask) {
                ITask task = (ITask)item;
                TasksUiPlugin.getTaskDataManager().setTaskRead(task, true);
                GoToUnreadTaskHandler.execute(event, TreeWalker.Direction.UP);
            }
        }
    }

    public static class MarkTaskReadHandler
    extends AbstractTaskHandler {
        public static final String ID_COMMAND = "org.eclipse.mylyn.tasks.ui.command.markTaskRead";

        public MarkTaskReadHandler() {
            this.setFilterBasedOnActiveTaskList(true);
        }

        protected void execute(ExecutionEvent event, ITask task) throws ExecutionException {
            TasksUiPlugin.getTaskDataManager().setTaskRead(task, true);
        }
    }

    public static class MarkTaskUnreadHandler
    extends AbstractTaskHandler {
        public MarkTaskUnreadHandler() {
            this.setFilterBasedOnActiveTaskList(true);
        }

        protected void execute(ExecutionEvent event, ITask task) throws ExecutionException {
            TasksUiPlugin.getTaskDataManager().setTaskRead(task, false);
        }
    }
}

