/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.editor;

import com.google.gerrit.common.data.PatchSetDetail;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.internal.gerrit.core.GerritConnector;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritPatchSetContent;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.statushandlers.StatusManager;

public class GetPatchSetContentJob
extends Job {
    private GerritPatchSetContent patchSetContent;
    private final PatchSetDetail patchSetDetail;
    private final TaskRepository repository;

    public GetPatchSetContentJob(TaskRepository repository, PatchSetDetail patchSetDetail) {
        super("Caching Patch Set Content");
        this.repository = repository;
        this.patchSetDetail = patchSetDetail;
    }

    public GerritPatchSetContent getPatchSetContent() {
        return this.patchSetContent;
    }

    protected IStatus run(IProgressMonitor monitor) {
        GerritConnector connector = (GerritConnector)TasksUi.getRepositoryConnector((String)this.repository.getConnectorKind());
        GerritClient client = connector.getClient(this.repository);
        try {
            int reviewId = this.patchSetDetail.getInfo().getKey().getParentKey().get();
            this.patchSetContent = client.getPatchSetContent(String.valueOf(reviewId), null, this.patchSetDetail, monitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        catch (GerritException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.mylyn.gerrit.ui", "Review retrieval failed", (Throwable)e), 1);
        }
        return Status.OK_STATUS;
    }
}

