/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.egit;

import com.google.gerrit.reviewdb.AccountGeneralPreferences;
import com.google.gerrit.reviewdb.Project;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.ui.internal.provisional.wizards.GitRepositoryInfo;
import org.eclipse.egit.ui.internal.provisional.wizards.IRepositorySearchResult;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.commons.workbench.SubstringPatternFilter;
import org.eclipse.mylyn.internal.gerrit.core.GerritCorePlugin;
import org.eclipse.mylyn.internal.gerrit.core.GerritUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritConfiguration;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.ui.egit.GerritRepositorySearchPageContentProvider;
import org.eclipse.mylyn.internal.gerrit.ui.egit.GerritRepositorySearchPageLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.actions.AddRepositoryAction;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class GerritRepositorySearchPage
extends WizardPage
implements IRepositorySearchResult {
    private Combo cloneUriCombo;
    private Button refreshButton;

    public GerritRepositorySearchPage() {
        super(GerritRepositorySearchPage.class.getName());
        this.setTitle("Source Git Repository");
        this.setMessage("Select the Gerrit project");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        Composite composite = new Composite(container, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        FilteredTree tree = new FilteredTree(composite, 2820, (PatternFilter)new SubstringPatternFilter(), true);
        final TreeViewer tv = tree.getViewer();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tree);
        tv.setContentProvider((IContentProvider)new GerritRepositorySearchPageContentProvider());
        tv.setLabelProvider((IBaseLabelProvider)new GerritRepositorySearchPageLabelProvider());
        tv.setInput((Object)this);
        tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ITreeSelection selection = (ITreeSelection)event.getSelection();
                GerritRepositorySearchPage.this.selectionChanged(tv, selection);
            }
        });
        tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ITreeSelection selection = (ITreeSelection)event.getSelection();
                GerritRepositorySearchPage.this.doubleClick(tv, selection);
            }
        });
        tv.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x100000E) {
                    GerritRepositorySearchPage.this.refreshConfigIfTaskRepositoryIsSelected(tv);
                }
            }
        });
        Composite buttonsComposite = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(buttonsComposite);
        buttonsComposite.setLayoutData((Object)new GridData(768));
        buttonsComposite.setLayout((Layout)new GridLayout(2, false));
        Button addButton = new Button(buttonsComposite, 0);
        addButton.setText("Add...");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = GerritRepositorySearchPage.this.getShell();
                if (shell != null && !shell.isDisposed()) {
                    AddRepositoryAction addRepositoryAction = new AddRepositoryAction();
                    addRepositoryAction.setPromptToAddQuery(false);
                    TaskRepository addedRepository = addRepositoryAction.showWizard(shell, "org.eclipse.mylyn.gerrit");
                    if (addedRepository != null) {
                        tv.refresh();
                        GerritRepositorySearchPage.this.refreshConfig(tv, addedRepository);
                    }
                }
            }
        });
        this.refreshButton = new Button(buttonsComposite, 0);
        this.refreshButton.setText("Refresh");
        this.refreshButton.setEnabled(false);
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GerritRepositorySearchPage.this.refreshConfigIfTaskRepositoryIsSelected(tv);
            }
        });
        Group repositoryGroup = new Group(composite, 0);
        repositoryGroup.setText("Git Repository");
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo((Composite)repositoryGroup);
        repositoryGroup.setLayoutData((Object)new GridData(768));
        repositoryGroup.setLayout((Layout)new GridLayout(2, false));
        new Label((Composite)repositoryGroup, 0).setText("URI:");
        this.cloneUriCombo = new Combo((Composite)repositoryGroup, 4);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.cloneUriCombo);
        this.clearCloneUris();
        this.setControl((Control)container);
    }

    private void selectionChanged(TreeViewer tv, ITreeSelection selection) {
        this.clearError();
        if (selection.size() == 1) {
            this.refreshButton.setEnabled(true);
            if (selection.getFirstElement() instanceof Project) {
                TreePath path = selection.getPaths()[0];
                TaskRepository repository = (TaskRepository)path.getSegment(0);
                Project project = (Project)path.getSegment(1);
                try {
                    GerritConfiguration config = GerritCorePlugin.getGerritClient((TaskRepository)repository).getConfiguration();
                    this.setCloneUris(GerritUtil.getCloneUris((GerritConfiguration)config, (TaskRepository)repository, (Project)project));
                }
                catch (URISyntaxException e) {
                    String message = NLS.bind((String)"Unable to compute Git clone URI for Gerrit project {0}", (Object)project.getName());
                    this.showError(e, message);
                    this.clearCloneUris();
                }
            } else if (selection.getFirstElement() instanceof TaskRepository) {
                this.clearCloneUris();
            }
        } else {
            this.refreshButton.setEnabled(false);
            this.clearCloneUris();
        }
    }

    private void showError(Exception e, String message) {
        GerritCorePlugin.logError((String)message, (Throwable)e);
        this.setErrorMessage(message);
    }

    private void clearError() {
        this.setErrorMessage(null);
    }

    private void setCloneUris(HashMap<AccountGeneralPreferences.DownloadScheme, String> uriMap) {
        this.cloneUriCombo.removeAll();
        this.addCloneUriIfNotNull(uriMap, AccountGeneralPreferences.DownloadScheme.SSH);
        this.addCloneUriIfNotNull(uriMap, AccountGeneralPreferences.DownloadScheme.HTTP);
        this.addCloneUriIfNotNull(uriMap, AccountGeneralPreferences.DownloadScheme.ANON_HTTP);
        this.addCloneUriIfNotNull(uriMap, AccountGeneralPreferences.DownloadScheme.ANON_GIT);
        if (this.cloneUriCombo.getItemCount() > 0) {
            this.cloneUriCombo.select(0);
            this.cloneUriCombo.setEnabled(true);
            this.setPageComplete(true);
        } else {
            this.clearCloneUris();
            this.showError(null, "No download scheme is offered. Additional schemes may be available after a refresh of the repository configuration.");
        }
    }

    private void addCloneUriIfNotNull(HashMap<AccountGeneralPreferences.DownloadScheme, String> uriMap, AccountGeneralPreferences.DownloadScheme scheme) {
        String uri = uriMap.get(scheme);
        if (uri != null) {
            this.cloneUriCombo.add(uri);
        }
    }

    private void clearCloneUris() {
        this.cloneUriCombo.removeAll();
        this.cloneUriCombo.setText("");
        this.cloneUriCombo.setEnabled(false);
        this.setPageComplete(false);
    }

    private void doubleClick(TreeViewer tv, ITreeSelection selection) {
        this.clearError();
        this.selectionChanged(tv, selection);
        if (selection.size() == 1 && selection.getFirstElement() instanceof TaskRepository) {
            Object element = selection.getFirstElement();
            if (tv.getExpandedState(element)) {
                tv.collapseToLevel(element, 1);
            } else {
                tv.expandToLevel(element, 1);
            }
        }
        if (this.isPageComplete()) {
            this.getContainer().showPage(this.getNextPage());
        }
    }

    private void refreshConfig(TreeViewer tv, final TaskRepository repository) {
        this.clearError();
        try {
            final GerritClient client = GerritCorePlugin.getGerritClient((TaskRepository)repository);
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Refreshing " + repository.getRepositoryLabel(), -1);
                    try {
                        client.refreshConfig(monitor);
                    }
                    catch (GerritException e) {
                        throw new InvocationTargetException(e, e.getMessage());
                    }
                    monitor.done();
                }
            });
            tv.refresh((Object)repository);
        }
        catch (InvocationTargetException e) {
            this.showError(e, e.getMessage());
        }
        catch (InterruptedException interruptedException) {}
    }

    private void refreshConfigIfTaskRepositoryIsSelected(TreeViewer tv) {
        ITreeSelection selection = (ITreeSelection)tv.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof TaskRepository) {
            this.refreshConfig(tv, (TaskRepository)element);
        } else if (element instanceof Project) {
            TreePath path = selection.getPaths()[0];
            this.refreshConfig(tv, (TaskRepository)path.getSegment(0));
        }
    }

    public GitRepositoryInfo getGitRepositoryInfo() {
        GitRepositoryInfo gitRepositoryInfo = new GitRepositoryInfo(this.cloneUriCombo.getText());
        this.addFetchReviewNotesRefSpec(gitRepositoryInfo);
        this.addPushToGerritRefSpec(gitRepositoryInfo);
        this.addCreateGerritChangeIdConfig(gitRepositoryInfo);
        return gitRepositoryInfo;
    }

    private void addFetchReviewNotesRefSpec(GitRepositoryInfo gitRepositoryInfo) {
        String notesRef = "refs/notes/*";
        gitRepositoryInfo.addFetchRefSpec("+" + notesRef + ":" + notesRef);
    }

    private void addPushToGerritRefSpec(GitRepositoryInfo gitRepositoryInfo) {
        gitRepositoryInfo.addPushInfo("HEAD:refs/for/master", null);
    }

    private void addCreateGerritChangeIdConfig(GitRepositoryInfo gitRepositoryInfo) {
        gitRepositoryInfo.addRepositoryConfigProperty("gerrit", null, "createchangeid", "true");
    }
}

