/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core;

import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.trac.core.TracAttribute;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.util.TracUtil;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracAttributeMapper
extends TaskAttributeMapper {
    public static final String NEW_CC = "task.common.newcc";
    public static final String REMOVE_CC = "task.common.removecc";
    public static final EnumSet<Flag> NO_FLAGS = EnumSet.noneOf(Flag.class);
    private final ITracClient client;

    public static boolean isInternalAttribute(TaskAttribute attribute) {
        String type = attribute.getMetaData().getType();
        if ("attachment".equals(type) || "operation".equals(type) || "comment".equals(type)) {
            return true;
        }
        String id = attribute.getId();
        return "task.common.comment.new".equals(id) || "task.common.addselfcc".equals(id) || REMOVE_CC.equals(id) || NEW_CC.equals(id);
    }

    public TracAttributeMapper(TaskRepository taskRepository, ITracClient client) {
        super(taskRepository);
        Assert.isNotNull((Object)client);
        this.client = client;
    }

    public Date getDateValue(TaskAttribute attribute) {
        return TracUtil.parseDate(attribute.getValue());
    }

    public String mapToRepositoryKey(TaskAttribute parent, String key) {
        TracAttribute attribute = TracAttribute.getByTaskKey(key);
        return attribute != null ? attribute.getTracKey() : key;
    }

    public void setDateValue(TaskAttribute attribute, Date date) {
        if (date == null) {
            attribute.clearValues();
        } else {
            attribute.setValue(String.valueOf(TracUtil.toTracTime(date)));
        }
    }

    public Map<String, String> getOptions(TaskAttribute attribute) {
        Map options = TracAttributeMapper.getRepositoryOptions(this.client, attribute.getId());
        return options != null ? options : super.getOptions(attribute);
    }

    public static Map<String, String> getRepositoryOptions(ITracClient client, String trackKey) {
        if (client.hasAttributes()) {
            if (TracAttribute.STATUS.getTracKey().equals(trackKey)) {
                return TracAttributeMapper.getOptions(client.getTicketStatus(), false);
            }
            if (TracAttribute.RESOLUTION.getTracKey().equals(trackKey)) {
                return TracAttributeMapper.getOptions(client.getTicketResolutions(), false);
            }
            if (TracAttribute.COMPONENT.getTracKey().equals(trackKey)) {
                return TracAttributeMapper.getOptions(client.getComponents(), false);
            }
            if (TracAttribute.VERSION.getTracKey().equals(trackKey)) {
                return TracAttributeMapper.getOptions(client.getVersions(), true);
            }
            if (TracAttribute.PRIORITY.getTracKey().equals(trackKey)) {
                return TracAttributeMapper.getOptions(client.getPriorities(), false);
            }
            if (TracAttribute.SEVERITY.getTracKey().equals(trackKey)) {
                return TracAttributeMapper.getOptions(client.getSeverities(), false);
            }
            if (TracAttribute.MILESTONE.getTracKey().equals(trackKey)) {
                return TracAttributeMapper.getOptions(client.getMilestones(), true);
            }
            if (TracAttribute.TYPE.getTracKey().equals(trackKey)) {
                return TracAttributeMapper.getOptions(client.getTicketTypes(), false);
            }
        }
        return null;
    }

    private static Map<String, String> getOptions(Object[] values, boolean allowEmpty) {
        if (values != null && values.length > 0) {
            LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
            if (allowEmpty) {
                options.put("", "");
            }
            Object[] objectArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                options.put(value.toString(), value.toString());
                ++n2;
            }
            return options;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flag {
        READ_ONLY,
        ATTRIBUTE,
        PEOPLE;

    }
}

