/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core.client;

import java.util.regex.Pattern;
import org.apache.xmlrpc.XmlRpcException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.commons.xmlrpc.CommonXmlRpcClient;
import org.eclipse.mylyn.internal.commons.xmlrpc.XmlRpcOperation;
import org.eclipse.mylyn.internal.commons.xmlrpc.XmlRpcPermissionDeniedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class TracXmlRpcOperation<T>
extends XmlRpcOperation<T> {
    private static final Pattern RPC_METHOD_NOT_FOUND_PATTERN = Pattern.compile("RPC method \".*\" not found");
    private boolean accountMangerAuthenticationFailed;

    public TracXmlRpcOperation(CommonXmlRpcClient client) {
        super(client);
    }

    protected Object executeCall(IProgressMonitor monitor, String method, Object ... parameters) throws XmlRpcException {
        try {
            this.preCall();
            return super.executeCall(monitor, method, parameters);
        }
        catch (XmlRpcPermissionDeniedException e) {
            if (this.accountMangerAuthenticationFailed) {
                throw e;
            }
            AuthenticationCredentials credentials = this.getClient().getLocation().getCredentials(AuthenticationType.REPOSITORY);
            if (!this.credentialsValid(credentials)) {
                throw e;
            }
            this.preCall();
            return super.executeCall(monitor, method, parameters);
        }
    }

    private void preCall() {
    }

    protected boolean isNoSuchMethodException(XmlRpcException e) {
        return e.code == 1 && e.getMessage() != null && RPC_METHOD_NOT_FOUND_PATTERN.matcher(e.getMessage()).find();
    }
}

