/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.subclipse.core;

import java.net.MalformedURLException;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.subclipse.core.SubclipseArtifact;
import org.eclipse.mylyn.internal.subclipse.core.SubclipseCorePlugin;
import org.eclipse.mylyn.internal.subclipse.core.SubclipseRepository;
import org.eclipse.mylyn.versions.core.Change;
import org.eclipse.mylyn.versions.core.ChangeSet;
import org.eclipse.mylyn.versions.core.ChangeType;
import org.eclipse.mylyn.versions.core.ScmArtifact;
import org.eclipse.mylyn.versions.core.ScmRepository;
import org.eclipse.mylyn.versions.core.ScmUser;
import org.eclipse.mylyn.versions.core.spi.ScmConnector;
import org.eclipse.mylyn.versions.core.spi.ScmResourceUtils;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileRevision;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.commands.GetLogsCommand;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubclipseConnector
extends ScmConnector {
    private final ILog logger = SubclipseCorePlugin.getDefault().getLog();
    private final Map<IProject, SubclipseRepository> mapProjToRepo = new HashMap<IProject, SubclipseRepository>();
    private Integer threadBookNum = new Integer(0);
    private final Map<String, IProject> mapSvnFolderToProject = new HashMap<String, IProject>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ScmArtifact getArtifact(IResource resource, String revision) {
        ISVNRemoteResource localResource = null;
        SubclipseRepository repo = null;
        ISVNRemoteResource resolvedResource = null;
        try {
            localResource = SVNWorkspaceRoot.getBaseResourceFor((IResource)resource);
            if (revision == null) {
                resolvedResource = localResource;
            } else {
                SVNRevision.Number svnRevision = new SVNRevision.Number(Long.parseLong(revision));
                GetLogsCommand logCmd = new GetLogsCommand(localResource, null, (SVNRevision)svnRevision, (SVNRevision)svnRevision, false, 1L, null, true);
                try {
                    logCmd.run((IProgressMonitor)new NullProgressMonitor());
                }
                catch (SVNException sVNException) {
                    return null;
                }
                ILogEntry[] entries = logCmd.getLogEntries();
                if (entries.length < 1) {
                    return null;
                }
                resolvedResource = entries[entries.length - 1].getRemoteResource();
            }
            if (resolvedResource == null) {
                return null;
            }
            repo = (SubclipseRepository)this.getRepository(resource, null);
        }
        catch (SVNException sVNException) {
            return null;
        }
        catch (CoreException coreException) {
            return null;
        }
        String id = Long.toString(resolvedResource.getLastChangedRevision().getNumber());
        SubclipseArtifact artifact = new SubclipseArtifact(id, resolvedResource.getRepositoryRelativePath(), repo);
        artifact.setProjectName(resource.getProject().getName());
        artifact.setProjectRelativePath(resource.getProjectRelativePath().toPortableString());
        artifact.setRemoteResource(resolvedResource);
        return artifact;
    }

    public ChangeSet getChangeSet(ScmRepository repository, IFileRevision revision, IProgressMonitor monitor) throws CoreException {
        SubclipseRepository repo = (SubclipseRepository)repository;
        SVNRevision sRevision = this.resolveSvnRevision(revision);
        return this.getChangeSet(repo, sRevision, monitor);
    }

    private ChangeSet getChangeSet(SubclipseRepository repository, SVNRevision sRevision, IProgressMonitor monitor) throws CoreException {
        boolean fetchChangePaths;
        SVNUrl repoLocationUrl = repository.getProjectSVNFolder();
        ISVNLogMessage[] messages = this.resolveChangeSets(repository, repoLocationUrl, sRevision, sRevision, fetchChangePaths = true, null);
        if (messages == null) {
            return null;
        }
        assert (messages.length == 1);
        ISVNLogMessage isvnLogMessage = messages[0];
        List<Change> changes = this.buildChanges(repository, isvnLogMessage, true);
        return this.changeSet(repository, isvnLogMessage, changes);
    }

    private List<Change> buildChanges(SubclipseRepository repository, ISVNLogMessage isvnLogMessage, boolean withBaseVersions) throws CoreException {
        ISVNLogMessageChangePath[] changePaths = isvnLogMessage.getChangedPaths();
        ArrayList<Change> changes = new ArrayList<Change>();
        SVNRevision.Number sRevision = isvnLogMessage.getRevision();
        String id = String.valueOf(sRevision.getNumber());
        ISVNLogMessageChangePath[] iSVNLogMessageChangePathArray = changePaths;
        int n = changePaths.length;
        int n2 = 0;
        while (n2 < n) {
            ISVNLogMessageChangePath isvnLogMessageChangePath = iSVNLogMessageChangePathArray[n2];
            ChangeType ctype = this.mapChangeType(isvnLogMessageChangePath);
            SubclipseArtifact newArtifact = this.getArtifact(repository, isvnLogMessageChangePath, id);
            SubclipseArtifact oldArtifact = null;
            if (ctype == ChangeType.ADDED || ctype == ChangeType.REPLACED) {
                changes.add(new Change(oldArtifact, (ScmArtifact)newArtifact, ctype));
            } else {
                if (withBaseVersions) {
                    try {
                        oldArtifact = this.resolveBaseArtifact(repository, newArtifact.getRepositoryURL(), sRevision, isvnLogMessageChangePath, ctype);
                    }
                    catch (MalformedURLException e) {
                        this.logger.log((IStatus)new Status(4, "org.eclipse.mylyn.subclipse.core", "Error resolving an artifact url" + isvnLogMessageChangePath.getPath(), (Throwable)e));
                    }
                    if (ctype == ChangeType.DELETED) {
                        newArtifact = null;
                    }
                }
                if (newArtifact != null || oldArtifact != null) {
                    changes.add(new Change(oldArtifact, (ScmArtifact)newArtifact, ctype));
                }
            }
            ++n2;
        }
        return changes;
    }

    public List<ChangeSet> getChangeSets(ScmRepository repository, IProgressMonitor monitor) throws CoreException {
        SubclipseRepository repo = (SubclipseRepository)repository;
        SVNRevision.Number firstRevision = new SVNRevision.Number(1L);
        ISVNLogMessage[] messages = this.resolveChangeSets(repo, repo.getProjectSVNFolder(), SVNRevision.HEAD, (SVNRevision)firstRevision, false, 20L);
        ArrayList<ChangeSet> changeSets = new ArrayList<ChangeSet>(messages.length);
        ArrayList<Change> changes = new ArrayList<Change>();
        ISVNLogMessage[] iSVNLogMessageArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            ISVNLogMessage message = iSVNLogMessageArray[n2];
            changeSets.add(this.changeSet(repo, message, changes));
            ++n2;
        }
        this.resolveSubclipseProjects();
        return changeSets;
    }

    public Iterator<ChangeSet> getChangeSetsIterator(ScmRepository repository, IProgressMonitor monitor) {
        this.resolveSubclipseProjects();
        SubclipseRepository repo = (SubclipseRepository)repository;
        ChangeSetsIterator niterator = this.scheduleIterator(monitor, repo);
        return niterator;
    }

    private ChangeSetsIterator scheduleIterator(final IProgressMonitor monitor, final SubclipseRepository repo) {
        final ChangeSetsIterator niterator = new ChangeSetsIterator(repo, monitor);
        Thread monitorThread = new Thread(new Runnable(){

            public void run() {
                Thread thread = new Thread(niterator);
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(repo.getName())).append("-");
                SubclipseConnector subclipseConnector = SubclipseConnector.this;
                Integer n = subclipseConnector.threadBookNum + 1;
                subclipseConnector.threadBookNum = n;
                String name = stringBuilder.append(n).toString();
                thread.setName(name);
                thread.start();
                niterator.setRunnableThread(thread);
                try {
                    while (thread.isAlive()) {
                        if (monitor.isCanceled()) {
                            thread.interrupt();
                            break;
                        }
                        Thread.sleep(100L);
                    }
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    thread.interrupt();
                }
            }
        });
        monitorThread.start();
        return niterator;
    }

    public String getProviderId() {
        return SVNProviderPlugin.getTypeId();
    }

    protected SubclipseRepository getRepository(ISVNRepositoryLocation location, IProject project) {
        SubclipseRepository repository = new SubclipseRepository(this, location, project);
        return repository;
    }

    public ScmRepository getRepository(IResource resource, IProgressMonitor monitor) throws CoreException {
        IProject project = resource.getProject();
        SubclipseRepository repo = this.mapProjToRepo.get(project);
        if (repo == null) {
            ISVNRepositoryLocation location = SVNWorkspaceRoot.getRepositoryFor((IPath)project.getLocation());
            repo = this.getRepository(location, project);
            this.mapProjToRepo.put(project, repo);
        }
        return repo;
    }

    public List<ScmRepository> getRepositories(IProgressMonitor monitor) throws CoreException {
        if (this.mapSvnFolderToProject.size() == 0) {
            this.resolveSubclipseProjects();
        }
        ArrayList<ScmRepository> repositories = new ArrayList<ScmRepository>(this.mapSvnFolderToProject.size());
        for (IProject project : this.mapSvnFolderToProject.values()) {
            ScmRepository repository = this.getRepository((IResource)project, monitor);
            repositories.add(repository);
        }
        return repositories;
    }

    private SubclipseArtifact getArtifact(SubclipseRepository repo, ISVNLogMessageChangePath changePath, String id) {
        SubclipseArtifact artifact = new SubclipseArtifact(id, changePath.getPath(), repo);
        String artifactRepoURLStr = null;
        try {
            artifactRepoURLStr = artifact.getRepositoryURL().toString();
        }
        catch (MalformedURLException e) {
            this.logger.log((IStatus)new Status(4, "org.eclipse.mylyn.subclipse.core", "Unable to resolve URL", (Throwable)e));
            return null;
        }
        if (this.mapSvnFolderToProject.size() == 0) {
            this.resolveSubclipseProjects();
        }
        Set<String> projectFolders = this.mapSvnFolderToProject.keySet();
        for (String projURLStr : projectFolders) {
            IProject project;
            String projectAbsPathStr;
            String artifactWSLocation;
            URI absURI;
            IFile ifile;
            if (!artifactRepoURLStr.startsWith(projURLStr) || (ifile = ScmResourceUtils.getWorkSpaceFile((URI)(absURI = URIUtil.toURI((IPath)new Path(artifactWSLocation = artifactRepoURLStr.replace(projURLStr, projectAbsPathStr = (project = this.mapSvnFolderToProject.get(projURLStr)).getLocation().toString())))), (IProject)project)) == null) continue;
            artifact.setProjectName(project.getName());
            artifact.setProjectRelativePath(ifile.getProjectRelativePath().toPortableString());
            break;
        }
        return artifact;
    }

    private SubclipseArtifact resolveBaseArtifact(SubclipseRepository repo, SVNUrl pathUrl, SVNRevision.Number sRevision, ISVNLogMessageChangePath targetMessageChangePath, ChangeType ctype) throws CoreException {
        SubclipseArtifact oldArtifact = null;
        if (ctype == ChangeType.DELETED) {
            sRevision = new SVNRevision.Number(sRevision.getNumber() - 1L);
        }
        SVNRevision eRevision = null;
        try {
            eRevision = SVNRevision.getRevision((String)"1");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        ISVNLogMessage[] filePreviousCommits = null;
        boolean fetchChangePaths = true;
        filePreviousCommits = this.resolveChangeSets(repo, pathUrl, (SVNRevision)sRevision, eRevision, fetchChangePaths, 2L);
        String revisionId = null;
        if (filePreviousCommits != null && filePreviousCommits.length > 1) {
            ISVNLogMessage aBaseCommitMessage = ctype != ChangeType.DELETED ? filePreviousCommits[1] : filePreviousCommits[0];
            revisionId = aBaseCommitMessage.getRevision().toString();
            assert (revisionId != null);
            oldArtifact = this.getArtifact(repo, targetMessageChangePath, revisionId);
        }
        return oldArtifact;
    }

    private SVNRevision resolveSvnRevision(IFileRevision revision) throws CoreException {
        String versionId = revision.getContentIdentifier();
        SVNRevision sRevision = null;
        try {
            sRevision = SVNRevision.getRevision((String)versionId);
        }
        catch (ParseException e1) {
            Status status = new Status(4, "org.eclipse.mylyn.subclipse.core", "Unable to resolve VersionId " + versionId, (Throwable)e1);
            throw new CoreException((IStatus)status);
        }
        return sRevision;
    }

    private ChangeType mapChangeType(ISVNLogMessageChangePath isvnLogMessageChangePath) {
        ChangeType changetype = null;
        char action = isvnLogMessageChangePath.getAction();
        switch (action) {
            case 'M': {
                changetype = ChangeType.MODIFIED;
                break;
            }
            case 'A': {
                changetype = ChangeType.ADDED;
                break;
            }
            case 'D': {
                changetype = ChangeType.DELETED;
                break;
            }
            case 'R': {
                changetype = ChangeType.REPLACED;
            }
        }
        return changetype;
    }

    private ISVNLogMessage[] resolveChangeSets(SubclipseRepository repository, SVNUrl urlLocation, SVNRevision start, SVNRevision end, boolean fetchChangePath, Long limit) throws CoreException {
        ISVNRepositoryLocation location = repository.getLocation();
        ISVNLogMessage[] messages = null;
        try {
            ISVNClientAdapter adapter = location.getSVNClient();
            messages = limit == null || limit < 1L ? adapter.getLogMessages(urlLocation, start, end, fetchChangePath) : adapter.getLogMessages(urlLocation, start, start, end, true, fetchChangePath, limit.longValue());
        }
        catch (SVNClientException e) {
            StringBuilder sb = new StringBuilder("Unable to resolve ChangeSet:" + start.toString() + " for location");
            if (urlLocation != null) {
                sb.append(": " + urlLocation.toString());
            }
            Status status = new Status(4, "org.eclipse.mylyn.subclipse.core", sb.toString(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        return messages;
    }

    private ChangeSet changeSet(SubclipseRepository repository, ISVNLogMessage message, List<Change> changes) {
        ChangeSet changeSet = null;
        changeSet = new ChangeSet(this.getScmUser(message.getAuthor()), message.getDate(), message.getRevision().toString(), message.getMessage(), (ScmRepository)repository, changes);
        return changeSet;
    }

    private ScmUser getScmUser(String name) {
        return new ScmUser("", name, "");
    }

    private void resolveSubclipseProjects() {
        IProject[] projects;
        this.mapSvnFolderToProject.clear();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)iProject);
            if (provider != null && this.getProviderId().equals(provider.getID())) {
                String folderUrlStr = SVNWorkspaceRoot.getSVNFolderFor((IContainer)iProject).getUrl().toString();
                this.mapSvnFolderToProject.put(folderUrlStr, iProject);
            }
            ++n2;
        }
    }

    static /* synthetic */ ISVNLogMessage[] access$0(SubclipseConnector subclipseConnector, SubclipseRepository subclipseRepository, SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl, Long l) throws CoreException {
        return subclipseConnector.resolveChangeSets(subclipseRepository, sVNUrl, sVNRevision, sVNRevision2, bl, l);
    }

    static /* synthetic */ List access$1(SubclipseConnector subclipseConnector, SubclipseRepository subclipseRepository, ISVNLogMessage iSVNLogMessage, boolean bl) throws CoreException {
        return subclipseConnector.buildChanges(subclipseRepository, iSVNLogMessage, bl);
    }

    static /* synthetic */ ChangeSet access$2(SubclipseConnector subclipseConnector, SubclipseRepository subclipseRepository, ISVNLogMessage iSVNLogMessage, List list) {
        return subclipseConnector.changeSet(subclipseRepository, iSVNLogMessage, list);
    }

    static /* synthetic */ ILog access$3(SubclipseConnector subclipseConnector) {
        return subclipseConnector.logger;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ChangeSetsIterator
    implements Iterator<ChangeSet>,
    Runnable {
        private final int QUEUE_MAX = 40;
        private final Long CHUNKSIZE = 21L;
        private boolean dataProcessingStarted = false;
        private final SVNRevision earliestRevision = new SVNRevision.Number(1L);
        private final ArrayBlockingQueue<ChangeSet> changeSetQueue = new ArrayBlockingQueue(40);
        private final SubclipseRepository repo;
        private volatile AtomicBoolean done = new AtomicBoolean(false);
        private volatile AtomicBoolean cancelled = new AtomicBoolean(false);
        private Thread thread = null;
        private final IProgressMonitor monitor;
        private final String[] EXIT_ERROR_MESSAGES = new String[]{"connection refused", "Connection timed out"};

        public ChangeSetsIterator(SubclipseRepository repository, IProgressMonitor aMonitor) {
            this.repo = repository;
            this.monitor = aMonitor;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public void run() {
            msgList = null;
            messageBeingProcessed = null;
            headRevisionNum = new SVNRevision.Number(0x7FFFFFFFFFFFFFFFL);
            failedAttemptsCount = 0;
            while (headRevisionNum.compareTo((Object)this.earliestRevision) == 1 && !this.cancelled.get() && !this.done.get()) {
                block15: {
                    messageBeingProcessed = null;
                    startRevision /* !! */  = null;
                    startRevision /* !! */  = this.dataProcessingStarted != false ? headRevisionNum : SVNRevision.HEAD;
                    try {
                        msgList = SubclipseConnector.access$0(SubclipseConnector.this, this.repo, this.repo.getProjectSVNFolder(), (SVNRevision)startRevision /* !! */ , this.earliestRevision, true, this.CHUNKSIZE);
                        size = msgList.length;
                        i = 0;
                        while (i < size && !this.cancelled.get() && !this.done.get()) {
                            messageBeingProcessed = msgList[i];
                            if ((long)i != this.CHUNKSIZE - 1L) {
                                changes = SubclipseConnector.access$1(SubclipseConnector.this, this.repo, messageBeingProcessed, false);
                                changeset = SubclipseConnector.access$2(SubclipseConnector.this, this.repo, messageBeingProcessed, changes);
                                try {
                                    this.changeSetQueue.put(changeset);
                                }
                                catch (InterruptedException v0) {
                                    this.cancelled.set(true);
                                    this.monitor.done();
                                    return;
                                }
                                if (this.monitor.isCanceled()) {
                                    this.cancelled.set(true);
                                }
                            }
                            ++i;
                        }
                        headRevisionNum = this.updateProcessingHead(msgList[size - 1], headRevisionNum, false);
                        this.monitor.worked(1);
                        failedAttemptsCount = 0;
                        if ((long)size < this.CHUNKSIZE) {
                            this.done.set(true);
                        }
                        break block15;
                    }
                    catch (CoreException e) {
                        sb = new StringBuilder("Unable to resolve changeSets, ");
                        cause = e.getCause().getMessage();
                        var12_14 = this.EXIT_ERROR_MESSAGES;
                        var11_13 = this.EXIT_ERROR_MESSAGES.length;
                        var10_12 = 0;
                        ** while (var10_12 < var11_13)
                    }
lbl-1000:
                    // 1 sources

                    {
                        errMessage = var12_14[var10_12];
                        if (cause.contains(errMessage)) {
                            this.cancelled.set(true);
                            sb.append(cause);
                        }
                        ++var10_12;
                        continue;
                    }
lbl49:
                    // 1 sources

                    if (failedAttemptsCount == 0) {
                        e.printStackTrace();
                        SubclipseConnector.access$3(SubclipseConnector.this).log((IStatus)new Status(4, "org.eclipse.mylyn.subclipse.core", sb.toString(), (Throwable)e));
                    }
                    ++failedAttemptsCount;
                    if (!this.cancelled.get()) {
                        if (headRevisionNum != SVNRevision.HEAD && failedAttemptsCount < 11) {
                            headRevisionNum = this.updateProcessingHead(messageBeingProcessed, headRevisionNum, true);
                        } else {
                            this.cancelled.set(true);
                            this.done.set(true);
                        }
                    }
                }
                if (!this.monitor.isCanceled()) continue;
                this.cancelled.set(true);
            }
            this.done.set(true);
            this.monitor.done();
        }

        private SVNRevision.Number updateProcessingHead(ISVNLogMessage messageBeingProcessed, SVNRevision.Number current, boolean next) {
            long nextRevisionValue = messageBeingProcessed != null ? messageBeingProcessed.getRevision().getNumber() : current.getNumber();
            if (next) {
                --nextRevisionValue;
            }
            this.dataProcessingStarted = true;
            return new SVNRevision.Number(nextRevisionValue);
        }

        @Override
        public boolean hasNext() {
            if (this.changeSetQueue.size() > 0) {
                return true;
            }
            return !this.cancelled.get() && !this.done.get();
        }

        @Override
        public ChangeSet next() {
            try {
                return this.changeSetQueue.poll(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
                return null;
            }
        }

        @Override
        public void remove() {
            this.changeSetQueue.poll();
        }

        public Thread getRunnableThread() {
            return this.thread;
        }

        public void setRunnableThread(Thread thread) {
            this.thread = thread;
        }

        public void setCancelled(boolean cancelled) {
            this.cancelled.set(cancelled);
        }

        public boolean isCancelled() {
            return this.cancelled.get();
        }
    }
}

