/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.core.spi.BuildConnector;
import org.eclipse.mylyn.builds.core.spi.BuildServerBehaviour;
import org.eclipse.mylyn.builds.internal.core.BuildModel;
import org.eclipse.mylyn.builds.internal.core.BuildServer;
import org.eclipse.mylyn.builds.internal.core.IBuildLoader;
import org.eclipse.mylyn.builds.internal.core.IBuildModelRealm;
import org.eclipse.mylyn.builds.internal.core.operations.IOperationService;
import org.eclipse.mylyn.builds.internal.core.util.BuildModelManager;
import org.eclipse.mylyn.builds.ui.BuildsUi;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiPlugin;
import org.eclipse.mylyn.internal.builds.ui.OperationFactory;
import org.eclipse.mylyn.internal.builds.ui.OperationServiceUi;
import org.eclipse.mylyn.internal.builds.ui.console.BuildConsoleManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildsUiInternal {
    private static IBuildLoader buildLoader = new IBuildLoader(){
        private volatile IBuildModelRealm realm;

        public IBuildModelRealm getRealm() {
            if (this.realm == null) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        realm = new IBuildModelRealm(){
                            Display display = Display.getDefault();

                            public void asyncExec(Runnable runnable) {
                                this.checkDisplay();
                                this.display.asyncExec(runnable);
                            }

                            public void exec(Runnable runnable) {
                                this.checkDisplay();
                                if (Display.getCurrent() != null) {
                                    runnable.run();
                                } else {
                                    this.display.asyncExec(runnable);
                                }
                            }

                            public void syncExec(Runnable runnable) {
                                this.checkDisplay();
                                if (Display.getCurrent() != null) {
                                    runnable.run();
                                } else {
                                    this.display.syncExec(runnable);
                                }
                            }

                            protected void checkDisplay() {
                                if (this.display.isDisposed()) {
                                    throw new OperationCanceledException();
                                }
                            }
                        };
                    }
                });
            }
            return this.realm;
        }

        public BuildServerBehaviour loadBehaviour(BuildServer server) throws CoreException {
            BuildServerBehaviour behaviour;
            String connectorKind = server.getConnectorKind();
            if (connectorKind == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.builds.ui", NLS.bind((String)"Loading of connector for server ''{0}'' failed. No connector kind was specified.", (Object)server.getName())));
            }
            BuildConnector connector = BuildsUi.getConnector(connectorKind);
            if (connector == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.builds.ui", NLS.bind((String)"Loading of connector for server ''{0}'' failed. Connector kind ''{1}'' is not known.", (Object)server.getName(), (Object)connectorKind)));
            }
            try {
                behaviour = connector.getBehaviour(server.getLocation());
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.builds.ui", NLS.bind((String)"Unexpected error during loading of connector for server ''{0}'' with connector kind ''{1}'' failed.", (Object)server.getName(), (Object)connectorKind), (Throwable)e));
            }
            catch (LinkageError e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.builds.ui", NLS.bind((String)"Unexpected error during loading of connector for server ''{0}'' with connector kind ''{1}'' failed.", (Object)server.getName(), (Object)connectorKind), (Throwable)e));
            }
            catch (AssertionError e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.builds.ui", NLS.bind((String)"Unexpected error during loading of connector for server ''{0}'' with connector kind ''{1}'' failed.", (Object)server.getName(), (Object)connectorKind), (Throwable)((Object)e)));
            }
            if (behaviour == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.builds.ui", NLS.bind((String)"Unexpected error during loading of connector for server ''{0}'' with connector kind ''{1}'' failed, returned behaviour object is null.", (Object)server.getName(), (Object)connectorKind)));
            }
            return behaviour;
        }
    };
    private static volatile BuildConsoleManager consoleManager;
    public static final int DEFAULT_REFRESH_INTERVAL = 900000;
    public static final String ID_PREFERENCE_PAGE_BUILDS = "org.eclipse.mylyn.builds.preferences.BuildsPage";
    private static BuildModelManager manager;
    private static OperationServiceUi operationService;
    private static volatile OperationFactory operationFactory;
    public static final int MIN_REFRESH_INTERVAL = 60000;
    public static final String PREF_AUTO_REFRESH_ENABLED = "refresh.enabled";
    public static final String PREF_AUTO_REFRESH_INTERVAL = "refresh.interval";
    public static final String PREF_REFRESH_ON_FOCUS = "refresh.onfocus";
    public static final String PREF_SHOW_TEST_FAILURES_ONLY = "editor.testResults.failuresOnly";

    public static IBuildServer createServer(String connectorKind, RepositoryLocation location) {
        return BuildsUiInternal.getManager().createServer(connectorKind, location);
    }

    public static BuildConsoleManager getConsoleManager() {
        if (consoleManager == null) {
            consoleManager = new BuildConsoleManager();
        }
        return consoleManager;
    }

    protected static synchronized BuildModelManager getManager() {
        if (manager == null) {
            manager = new BuildModelManager(BuildsUiPlugin.getDefault().getBuildsFile().toFile(), buildLoader);
            manager.getModel().setLoader(buildLoader);
            manager.getModel().setScheduler(BuildsUiInternal.getOperationService().getScheduler());
        }
        return manager;
    }

    public static synchronized IOperationService getOperationService() {
        if (operationService == null) {
            operationService = new OperationServiceUi();
        }
        return operationService;
    }

    public static synchronized BuildModel getModel() {
        return BuildsUiInternal.getManager().getModel();
    }

    public static synchronized void save() throws IOException {
        if (manager != null) {
            manager.save();
        }
    }

    public static Set<String> toSetOfIds(Collection<IBuildPlan> plans) {
        HashSet<String> ids = new HashSet<String>();
        for (IBuildPlan plan : plans) {
            if (!plan.isSelected()) continue;
            ids.add(plan.getId());
        }
        return ids;
    }

    public static OperationFactory getFactory() {
        if (operationFactory == null) {
            operationFactory = new OperationFactory(BuildsUiInternal.getOperationService());
        }
        return operationFactory;
    }

    public static List<IBuildElement> getElements(ExecutionEvent event) {
        String selector = event.getParameter("element");
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            List items = ((IStructuredSelection)selection).toList();
            ArrayList<IBuildElement> result = new ArrayList<IBuildElement>(items.size());
            for (Object item : items) {
                if (!(item instanceof IBuildElement)) continue;
                Object element = (IBuildElement)item;
                if ("lastBuild".equals(selector)) {
                    element = element instanceof IBuildPlan ? ((IBuildPlan)element).getLastBuild() : null;
                }
                result.add((IBuildElement)element);
            }
            return result;
        }
        return Collections.emptyList();
    }
}

