/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.actions;

import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.builds.core.BuildStatus;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.IChange;
import org.eclipse.mylyn.builds.core.IChangeArtifact;
import org.eclipse.mylyn.builds.core.ITestCase;
import org.eclipse.mylyn.builds.core.ITestSuite;
import org.eclipse.mylyn.builds.core.TestCaseResult;
import org.eclipse.mylyn.commons.core.DateUtil;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewTaskFromBuildAction
extends BaseSelectionListenerAction {
    public NewTaskFromBuildAction() {
        super("New Task from Build...");
        this.setToolTipText("New Task from Build");
        this.setImageDescriptor(TasksUiImages.TASK_NEW);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return selection.getFirstElement() instanceof IBuildPlan || selection.getFirstElement() instanceof IBuild;
    }

    public void run() {
        Object selection = this.getStructuredSelection().getFirstElement();
        if (selection instanceof IBuild) {
            NewTaskFromBuildAction.createTask((IBuild)selection);
        }
    }

    public static boolean createTask(final IBuild build) {
        TaskMapping mapping = new TaskMapping(){

            public String getSummary() {
                BuildStatus status = build.getStatus();
                if (status != null) {
                    return NLS.bind((String)"Build {0}: {1}", (Object)build.getLabel(), (Object)status.toString());
                }
                return NLS.bind((String)"Build {0}", (Object)build.getLabel());
            }

            public String getDescription() {
                StringBuilder sb = new StringBuilder();
                sb.append(NLS.bind((String)"Build Results at {0} .\n", (Object)build.getUrl()));
                sb.append("\n");
                if (build.getChangeSet() != null && build.getChangeSet().getChanges().size() > 0) {
                    sb.append("= Changes =\n");
                    sb.append("\n");
                    sb.append("Changed Files:");
                    sb.append("\n");
                    for (IChange change : build.getChangeSet().getChanges()) {
                        for (IChangeArtifact artifact : change.getArtifacts()) {
                            sb.append(" " + artifact.getFile());
                        }
                        sb.append("\n");
                    }
                    sb.append("\n");
                }
                if (build.getTestResult() != null) {
                    sb.append("= Tests Results =\n");
                    sb.append(NLS.bind((String)"Duration: {0}", (Object)DateUtil.getFormattedDurationShort((long)build.getTestResult().getDuration())));
                    sb.append("\n");
                    sb.append("Failed Tests:\n");
                    NewTaskFromBuildAction.appendFailed(sb, build.getTestResult().getSuites());
                    sb.append("\n");
                }
                return sb.toString();
            }
        };
        return TasksUiUtil.openNewTaskEditor((Shell)WorkbenchUtil.getShell(), (ITaskMapping)mapping, null);
    }

    public static void appendFailed(StringBuilder sb, List<ITestSuite> suites) {
        for (ITestSuite suite : suites) {
            for (ITestCase testCase : suite.getCases()) {
                if (testCase.getStatus() != TestCaseResult.FAILED && testCase.getStatus() != TestCaseResult.REGRESSION) continue;
                NewTaskFromBuildAction.append(sb, testCase);
            }
        }
    }

    public static void append(StringBuilder sb, ITestSuite suite) {
        for (ITestCase testCase : suite.getCases()) {
            NewTaskFromBuildAction.append(sb, testCase);
        }
    }

    public static void append(StringBuilder sb, ITestCase testCase) {
        if (testCase.getStackTrace() != null) {
            sb.append(testCase.getStackTrace());
        } else {
            sb.append(" ");
            sb.append(testCase.getClassName());
            if (testCase.getLabel() != null) {
                sb.append(".");
                sb.append(testCase.getLabel());
                sb.append("(");
                String className = testCase.getClassName();
                int i = className.lastIndexOf(".");
                if (i != -1) {
                    className = className.substring(i + 1);
                }
                if ((i = className.lastIndexOf("$")) != -1) {
                    className = className.substring(0, i);
                }
                sb.append(className);
                sb.append(".java:0)");
            }
        }
        sb.append("\n");
    }
}

