/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.oslc.cm.tests;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.oslc.core.OslcServiceDescriptor;
import org.eclipse.mylyn.internal.oslc.core.OslcServiceProvider;
import org.eclipse.mylyn.internal.oslc.core.client.AbstractOslcClient;
import org.eclipse.mylyn.internal.oslc.core.cm.AbstractChangeRequest;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class RtcOlscTest
extends TestCase {
    private TaskRepository repository;
    private AbstractWebLocation location;
    private AbstractOslcClient client;
    private static final String BASE_URL = "https://192.168.0.3:9443/jazz/oslc/workitems/catalog";
    private static final String SERVICE_URL = "https://192.168.0.3:9443/jazz/oslc/contexts/_9Dyg4DLzEd-G-8cuiS4gvg/workitems/services.xml";

    protected void setUp() throws Exception {
        super.setUp();
        this.repository = new TaskRepository("rtc", SERVICE_URL);
        this.repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials("ADMIN", "ADMIN"), false);
        this.location = new TaskRepositoryLocationFactory().createWebLocation(this.repository);
        this.client = new AbstractOslcClient(this.location, new OslcServiceDescriptor(SERVICE_URL)){

            public RepositoryResponse putTaskData(TaskData taskData, Set<TaskAttribute> oldValues, IProgressMonitor monitor) throws CoreException {
                return null;
            }

            public String getUserAgent() {
                return null;
            }

            public TaskData getTaskData(String encodedTaskId, TaskAttributeMapper mapper, IProgressMonitor monitor) throws CoreException {
                return null;
            }

            protected AbstractChangeRequest createChangeRequest(String id, String title) {
                return new AbstractChangeRequest(id, title){};
            }
        };
    }

    public void testServiceCatalogParsing() throws Exception {
        List services = this.client.getAvailableServices(BASE_URL, null);
        RtcOlscTest.assertEquals((int)1, (int)services.size());
        OslcServiceProvider desc = (OslcServiceProvider)services.get(0);
        OslcServiceDescriptor serviceDescriptor = this.client.getServiceDescriptor(desc, null);
        RtcOlscTest.assertTrue((boolean)serviceDescriptor.getSimpleQueryUrl().endsWith("/workitems"));
    }

    public void testSimpleQuery() throws Exception {
        List services = this.client.getAvailableServices(BASE_URL, null);
        OslcServiceProvider cfr_ignored_0 = (OslcServiceProvider)services.get(0);
        Collection result = this.client.performQuery("dc:title=\"my first work item\"", null);
        RtcOlscTest.assertEquals((int)1, (int)result.size());
        AbstractChangeRequest request = (AbstractChangeRequest)result.iterator().next();
        request.getTitle().equals("my first work item");
    }
}

