/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.compare;

import java.io.InputStream;
import org.eclipse.compare.ICompareInputLabelProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.mylyn.commons.workbench.CommonImageManger;
import org.eclipse.mylyn.internal.reviews.ui.compare.ByteArrayInput;
import org.eclipse.mylyn.internal.reviews.ui.compare.CompareUtil;
import org.eclipse.mylyn.internal.reviews.ui.compare.FileRevisionTypedElement;
import org.eclipse.mylyn.internal.reviews.ui.providers.FileItemNodeLabelProvider;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IFileVersion;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.history.IFileRevision;

public class FileItemNode
extends DiffNode {
    private final IFileItem fileItem;
    private IPath path;
    private String name;
    private ICompareInputLabelProvider labelProvider;
    private static CommonImageManger imageManger;

    public FileItemNode(ReviewBehavior behavior, IFileItem fileItem, IProgressMonitor monitor) {
        super(0);
        String basePath;
        this.fileItem = fileItem;
        String targetPath = fileItem.getTarget().getPath();
        int kind = 3;
        if (targetPath == null) {
            targetPath = fileItem.getBase().getPath();
            kind = 1;
        }
        if ((basePath = fileItem.getBase().getPath()) == null) {
            basePath = targetPath;
            kind = 2;
        }
        if (targetPath.equals("/COMMIT_MSG")) {
            kind = 0;
        }
        this.setLeft(this.getElement(behavior, fileItem.getBase(), basePath, monitor));
        this.setRight(this.getElement(behavior, fileItem.getTarget(), targetPath, monitor));
        this.labelProvider = new FileItemNodeLabelProvider();
        this.setKind(kind);
        IPath path = Path.fromPortableString((String)targetPath);
        this.setPath(path);
        this.name = path.lastSegment();
    }

    private ITypedElement getElement(ReviewBehavior behavior, IFileVersion reviewFileVersion, String path, IProgressMonitor monitor) {
        IFileRevision repoFileRevision = behavior.getFileRevision(reviewFileVersion);
        if (repoFileRevision != null) {
            InputStream repoFileContents = null;
            try {
                repoFileContents = repoFileRevision.getStorage(monitor).getContents();
                if (repoFileContents != null) {
                    return new FileRevisionTypedElement(repoFileRevision, monitor);
                }
            }
            catch (CoreException coreException) {}
        }
        return new ByteArrayInput(CompareUtil.getContent(reviewFileVersion), path);
    }

    public FileItemNode(String name) {
        super(0);
        this.name = name;
        this.fileItem = null;
    }

    public IFileItem getFileItem() {
        return this.fileItem;
    }

    public Image getImage() {
        if (imageManger == null) {
            imageManger = new CommonImageManger();
        }
        return this.fileItem != null ? imageManger.getFileImage(this.getName()) : imageManger.getFolderImage();
    }

    public String getName() {
        return this.name;
    }

    public IPath getPath() {
        return this.path;
    }

    public String getType() {
        return this.fileItem != null ? super.getType() : "FOLDER";
    }

    public void setPath(IPath path) {
        this.path = path;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ICompareInputLabelProvider getLabelProvider() {
        return this.labelProvider;
    }
}

