/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ui.spi.editor;

import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.reviews.ui.Messages;
import org.eclipse.mylyn.internal.reviews.ui.providers.ReviewsLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IRepository;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.IRemoteEmfObserver;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfConsumer;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfObserver;
import org.eclipse.mylyn.reviews.ui.spi.editor.AbstractReviewSection;
import org.eclipse.mylyn.reviews.ui.spi.editor.ReviewSetSection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class ReviewSetContentSection {
    private static final int MAXIMUM_ITEMS_SHOWN = 30;
    private final ReviewSetSection parentSection;
    private final IReviewItemSet set;
    private final Section section;
    private TableViewer viewer;
    private final RemoteEmfObserver<IReviewItemSet, List<IFileItem>, String, Long> itemListClient = new RemoteEmfObserver<IReviewItemSet, List<IFileItem>, String, Long>(){

        public void created(IReviewItemSet parentObject, List<IFileItem> modelObject) {
            ReviewSetContentSection.this.createItemSetTable();
            ReviewSetContentSection.this.updateMessage();
        }

        public void updated(IReviewItemSet parentObject, List<IFileItem> modelObject, boolean modified) {
            if (modified) {
                ReviewSetContentSection.this.updateItemSetTable();
            }
            ReviewSetContentSection.this.updateMessage();
        }

        public void updating(IReviewItemSet parent, List<IFileItem> object) {
            ReviewSetContentSection.this.updateMessage();
        }

        public void failed(IReviewItemSet parent, List<IFileItem> object, IStatus status) {
            Status errorStatus = new Status(4, "org.eclipse.mylyn.tasks.ui", "Error loading patch set", status.getException());
            StatusHandler.log((IStatus)errorStatus);
            if (ReviewSetContentSection.this.getParentSection().getSection().getTextClient() != null) {
                AbstractReviewSection.appendMessage(ReviewSetContentSection.this.getParentSection().getSection(), "Couldn't load patch set.");
            }
        }
    };
    private Composite tableContainer;
    private Composite actionContainer;

    public ReviewSetContentSection(ReviewSetSection parentSection, final IReviewItemSet set) {
        this.parentSection = parentSection;
        this.set = set;
        int style = 8210;
        this.section = parentSection.getToolkit().createSection(parentSection.getComposite(), style);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.section);
        this.section.setText(set.getName());
        this.section.setTitleBarForeground(parentSection.getToolkit().getColors().getColor("org.eclipse.ui.forms.TITLE"));
        parentSection.addTextClient(parentSection.getToolkit(), this.section, "", false);
        final RemoteEmfConsumer itemSetConsumer = this.getParentSection().getReviewEditorPage().getFactoryProvider().getReviewItemSetContentFactory().getConsumerForLocalKey((EObject)set, (Object)set.getId());
        this.itemListClient.setConsumer(itemSetConsumer);
        final RemoteEmfConsumer reviewConsumer = this.getParentSection().getReviewEditorPage().getFactoryProvider().getReviewFactory().getConsumerForModel((EObject)set.getReview().getRepository(), (Object)set.getReview());
        reviewConsumer.addObserver((IRemoteEmfObserver)new RemoteEmfObserver<IRepository, IReview, String, Date>(){

            public void updated(IRepository parentObject, IReview modelObject, boolean modified) {
                if (reviewConsumer.getRemoteObject() != null && ReviewSetContentSection.this.section.isExpanded() && modified) {
                    itemSetConsumer.retrieve(false);
                    ReviewSetContentSection.this.updateMessage();
                    ReviewSetContentSection.this.craeteButtons();
                }
            }

            public void failed(IRepository parentObject, IReview modelObject, IStatus status) {
                AbstractReviewSection.appendMessage(ReviewSetContentSection.this.getSection(), "Couldn't load patch set: " + status.getMessage());
            }
        });
        this.section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                if (e.getState()) {
                    if (set.getItems().isEmpty()) {
                        itemSetConsumer.retrieve(false);
                    }
                    ReviewSetContentSection.this.updateMessage();
                    ReviewSetContentSection.this.craeteButtons();
                }
            }
        });
        this.createMainSection();
        this.createItemSetTable();
        this.updateMessage();
    }

    public void updateMessage() {
        if (this.section.isDisposed()) {
            return;
        }
        String time = DateFormat.getDateTimeInstance().format(this.set.getCreationDate());
        int numComments = this.set.getAllComments().size();
        String message = numComments > 0 ? NLS.bind((String)"{0}, {1} Comments", (Object)time, (Object)numComments) : NLS.bind((String)"{0}", (Object)time);
        if (this.itemListClient != null && this.itemListClient.getConsumer().isRetrieving()) {
            message = String.valueOf(message) + " " + Messages.Reviews_RetrievingContents;
        }
        AbstractReviewSection.appendMessage(this.getSection(), message);
    }

    void createMainSection() {
        Composite composite = this.parentSection.getToolkit().createComposite((Composite)this.section);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        this.section.setClient((Control)composite);
        Label authorLabel = new Label(composite, 0);
        FormColors colors = this.parentSection.getToolkit().getColors();
        authorLabel.setForeground(colors.getColor("org.eclipse.ui.forms.TITLE"));
        authorLabel.setText("Author");
        Text authorText = new Text(composite, 8);
        if (this.set.getAddedBy() != null) {
            authorText.setText(this.set.getAddedBy().getDisplayName());
        } else {
            authorText.setText("Unspecified");
        }
        Label committerLabel = new Label(composite, 0);
        committerLabel.setForeground(colors.getColor("org.eclipse.ui.forms.TITLE"));
        committerLabel.setText("Committer");
        Text committerText = new Text(composite, 8);
        if (this.set.getCommittedBy() != null) {
            committerText.setText(this.set.getCommittedBy().getDisplayName());
        } else {
            committerText.setText("Unspecified");
        }
        Label commitLabel = new Label(composite, 0);
        commitLabel.setForeground(colors.getColor("org.eclipse.ui.forms.TITLE"));
        commitLabel.setText("Commit");
        Hyperlink commitLink = new Hyperlink(composite, 8);
        commitLink.setText(this.set.getRevision());
        commitLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                ReviewSetContentSection.this.getParentSection().getUiFactoryProvider().getOpenCommitFactory(ReviewSetContentSection.this.getParentSection(), ReviewSetContentSection.this.set).execute();
            }
        });
        Label refLabel = new Label(composite, 0);
        refLabel.setForeground(colors.getColor("org.eclipse.ui.forms.TITLE"));
        refLabel.setText("Ref");
        Text refText = new Text(composite, 8);
        refText.setText(this.set.getReference());
        this.tableContainer = new Composite(composite, 0);
        this.tableContainer.setBackground(Display.getCurrent().getSystemColor(16));
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)this.tableContainer);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.tableContainer);
        this.actionContainer = new Composite(composite, 0);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)this.actionContainer);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(this.actionContainer);
        this.craeteButtons();
        this.parentSection.getTaskEditorPage().reflow();
    }

    public void createItemSetTable() {
        if (this.viewer == null && !this.set.getItems().isEmpty()) {
            boolean fixedViewerSize = this.set.getItems().size() > 30;
            int heightHint = fixedViewerSize ? 300 : -1;
            int style = 268437508;
            style = fixedViewerSize ? (style |= 0x200) : (style |= 0x10);
            this.viewer = new TableViewer(this.tableContainer, style);
            GridDataFactory.fillDefaults().span(2, 1).grab(true, true).hint(500, heightHint).applyTo(this.viewer.getControl());
            this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public void dispose() {
                }

                public Object[] getElements(Object inputElement) {
                    return this.getReviewItems(inputElement).toArray();
                }

                private List<IFileItem> getReviewItems(Object inputElement) {
                    if (inputElement instanceof IReviewItemSet) {
                        return ((IReviewItemSet)inputElement).getItems();
                    }
                    return Collections.emptyList();
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
            DelegatingStyledCellLabelProvider styledLabelProvider = new DelegatingStyledCellLabelProvider(new ReviewsLabelProvider.Simple()){

                public String getToolTipText(Object element) {
                    return ReviewsLabelProvider.ITEMS_COLUMN.getToolTipText(element);
                }
            };
            this.viewer.setLabelProvider((IBaseLabelProvider)styledLabelProvider);
            this.viewer.addOpenListener(new IOpenListener(){

                public void open(OpenEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    IFileItem item = (IFileItem)selection.getFirstElement();
                    if (item != null) {
                        ReviewSetContentSection.this.getParentSection().getUiFactoryProvider().getOpenFileFactory(ReviewSetContentSection.this.getParentSection(), ReviewSetContentSection.this.set, item).execute();
                    }
                }
            });
            EditorUtil.addScrollListener((Scrollable)this.viewer.getTable());
            this.viewer.setInput((Object)this.set);
            this.getParentSection().getTaskEditorPage().reflow();
        }
    }

    public void updateItemSetTable() {
        if (this.set.getItems().size() > 0 && this.viewer != null) {
            this.viewer.setInput((Object)this.set);
        }
    }

    public void craeteButtons() {
        if (!this.actionContainer.isDisposed()) {
            Control[] controlArray = this.actionContainer.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control oldActionControl = controlArray[n2];
                oldActionControl.dispose();
                ++n2;
            }
            this.getParentSection().getUiFactoryProvider().createControls(this.getParentSection(), this.actionContainer, this.getParentSection().getToolkit(), this.set);
            this.actionContainer.layout();
            this.getParentSection().getTaskEditorPage().reflow();
        }
    }

    public Section getSection() {
        return this.section;
    }

    public ReviewSetSection getParentSection() {
        return this.parentSection;
    }

    public void dispose() {
        this.itemListClient.dispose();
        this.section.dispose();
    }
}

