/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.Messages;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.PageMapping;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.TemplateProcessor;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.AbstractMarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.mediawiki.core.Template;
import org.eclipse.mylyn.wikitext.mediawiki.core.TemplateResolver;

public abstract class AbstractMediaWikiLanguage
extends AbstractMarkupLanguage {
    private static final String CATEGORY_PREFIX = ":";
    private static final Pattern STANDARD_EXTERNAL_LINK_FORMAT = Pattern.compile(".*?/([^/]+)/(\\{\\d+\\})");
    private static final Pattern QUALIFIED_INTERNAL_LINK = Pattern.compile("([^/]+)/(.+)");
    private PageMapping pageMapping;
    private Map<String, String> imageMapping;

    protected String mapPageNameToHref(String pageName) {
        Matcher matcher;
        String mapping;
        if (this.pageMapping != null && (mapping = this.pageMapping.mapPageNameToHref(pageName)) != null) {
            return mapping;
        }
        String pageId = pageName.replace(' ', '_');
        if (pageId.startsWith(CATEGORY_PREFIX) && pageId.length() > CATEGORY_PREFIX.length()) {
            return pageId.substring(CATEGORY_PREFIX.length());
        }
        if (pageId.startsWith("#")) {
            return pageId;
        }
        if (this.internalLinkPattern.contains("index.php?")) {
            try {
                pageId = URLEncoder.encode(pageId, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(MessageFormat.format(Messages.getString("AbstractMediaWikiLanguage_cannotComputeUrl"), pageId), e);
            }
        }
        if (QUALIFIED_INTERNAL_LINK.matcher(pageId).matches() && (matcher = STANDARD_EXTERNAL_LINK_FORMAT.matcher(this.internalLinkPattern)).matches()) {
            String prefix = matcher.group(1);
            if (pageId.startsWith(String.valueOf(prefix) + '/')) {
                return String.valueOf(this.internalLinkPattern.substring(0, matcher.start(1))) + pageId;
            }
            return String.valueOf(this.internalLinkPattern.substring(0, matcher.start(2))) + pageId;
        }
        return MessageFormat.format(this.internalLinkPattern, pageId);
    }

    public PageMapping getPageMapping() {
        return this.pageMapping;
    }

    public void setPageMapping(PageMapping pageMapping) {
        this.pageMapping = pageMapping;
    }

    public void processContent(MarkupParser parser, String markupContent, boolean asDocument) {
        if (this.isEnableMacros()) {
            markupContent = this.preprocessContent(markupContent);
        }
        super.processContent(parser, markupContent, asDocument);
    }

    private String preprocessContent(String markupContent) {
        return new TemplateProcessor(this).processTemplates(markupContent);
    }

    public abstract List<Template> getTemplates();

    public abstract List<TemplateResolver> getTemplateProviders();

    public abstract String getTemplateExcludes();

    public Set<String> getImageNames() {
        if (this.imageMapping == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet<String>(this.imageMapping.values()));
    }

    public void setImageNames(Set<String> imageNames) {
        if (this.imageMapping == null) {
            this.imageMapping = new HashMap<String, String>();
        } else {
            this.imageMapping.clear();
        }
        for (String name : imageNames) {
            this.imageMapping.put(name.toLowerCase(), name);
        }
    }

    public String mapImageName(String imageName) {
        String substitute;
        String string = substitute = this.imageMapping == null ? null : this.imageMapping.get(imageName.toLowerCase());
        if (substitute != null) {
            imageName = substitute;
        }
        return imageName;
    }

    public MarkupLanguage clone() {
        AbstractMediaWikiLanguage copy = (AbstractMediaWikiLanguage)super.clone();
        copy.imageMapping = this.imageMapping;
        copy.pageMapping = this.pageMapping;
        return copy;
    }
}

