/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests.core;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.bugzilla.tests.support.BugzillaFixture;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class BugzillaFlagsTest
extends TestCase {
    private BugzillaClient client;
    private TaskAttribute flagA;
    private TaskAttribute flagB;
    private TaskAttribute flagC;
    private TaskAttribute flagC2;
    private TaskAttribute flagD;
    private TaskAttribute stateA;
    private TaskAttribute stateB;
    private TaskAttribute stateC;
    private TaskAttribute stateC2;
    private TaskAttribute stateD;

    protected void setUp() throws Exception {
        this.client = BugzillaFixture.current().client();
    }

    public void testFlags() throws Exception {
        String taskNumber = "2";
        TaskData taskData = BugzillaFixture.current().getTask(taskNumber, this.client);
        BugzillaFlagsTest.assertNotNull((Object)taskData);
        if (this.flagTests(taskData, true)) {
            this.changeFromSpace(taskData);
            taskData = BugzillaFixture.current().getTask(taskNumber, this.client);
            if (this.flagTests(taskData, false)) {
                this.changeToSpace(taskData);
            }
        } else {
            this.changeToSpace(taskData);
            taskData = BugzillaFixture.current().getTask(taskNumber, this.client);
            if (this.flagTests(taskData, true)) {
                this.changeFromSpace(taskData);
            }
        }
    }

    private void changeFromSpace(TaskData taskData) throws IOException, CoreException {
        BugzillaFlagsTest.assertEquals((String)"task.common.kind.flag_type1", (String)this.flagA.getId());
        BugzillaFlagsTest.assertEquals((String)"task.common.kind.flag_type2", (String)this.flagB.getId());
        BugzillaFlagsTest.assertEquals((String)"task.common.kind.flag_type5", (String)this.flagC.getId());
        BugzillaFlagsTest.assertEquals((String)"task.common.kind.flag_type6", (String)this.flagD.getId());
        Map optionA = this.stateA.getOptions();
        Map optionB = this.stateB.getOptions();
        Map optionC = this.stateC.getOptions();
        Map optionD = this.stateD.getOptions();
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionA.containsKey(""));
        BugzillaFlagsTest.assertEquals((boolean)false, (boolean)optionA.containsKey("?"));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionA.containsKey("+"));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionA.containsKey("-"));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionB.containsKey(""));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionB.containsKey("?"));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionB.containsKey("+"));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionB.containsKey("-"));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionC.containsKey(""));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionC.containsKey("?"));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionC.containsKey("+"));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionC.containsKey("-"));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionD.containsKey(""));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionD.containsKey("?"));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionD.containsKey("+"));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionD.containsKey("-"));
        HashSet<TaskAttribute> changed = new HashSet<TaskAttribute>();
        this.stateA.setValue("+");
        this.stateB.setValue("?");
        this.stateC.setValue("?");
        this.stateD.setValue("?");
        TaskAttribute requesteeD = this.flagD.getAttribute("requestee");
        requesteeD.setValue("guest@mylyn.eclipse.org");
        changed.add(this.flagA);
        changed.add(this.flagB);
        changed.add(this.flagC);
        changed.add(this.flagD);
        BugzillaFixture.current().submitTask(taskData, this.client);
    }

    private void changeToSpace(TaskData taskData) throws IOException, CoreException {
        Map optionA = this.stateA.getOptions();
        Map optionB = this.stateB.getOptions();
        Map optionC = this.stateC.getOptions();
        Map optionD = this.stateD.getOptions();
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionA.containsKey(""));
        BugzillaFlagsTest.assertEquals((boolean)false, (boolean)optionA.containsKey("?"));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionA.containsKey("+"));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionA.containsKey("-"));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionB.containsKey(""));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionB.containsKey("?"));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionB.containsKey("+"));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionB.containsKey("-"));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionC.containsKey(""));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionC.containsKey("?"));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionC.containsKey("+"));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionC.containsKey("-"));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionD.containsKey(""));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionD.containsKey("?"));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionD.containsKey("+"));
        BugzillaFlagsTest.assertEquals((boolean)true, (boolean)optionD.containsKey("-"));
        HashSet<TaskAttribute> changed = new HashSet<TaskAttribute>();
        this.stateA.setValue(" ");
        this.stateB.setValue(" ");
        this.stateC.setValue(" ");
        this.stateD.setValue(" ");
        changed.add(this.flagA);
        changed.add(this.flagB);
        changed.add(this.flagC);
        changed.add(this.flagD);
        BugzillaFixture.current().submitTask(taskData, this.client);
    }

    private boolean flagTests(TaskData taskData, boolean testSpace) {
        this.flagA = null;
        this.flagB = null;
        this.flagC = null;
        this.flagC2 = null;
        this.flagD = null;
        this.stateA = null;
        this.stateB = null;
        this.stateC = null;
        this.stateC2 = null;
        this.stateD = null;
        for (TaskAttribute taskAttribute : taskData.getRoot().getAttributes().values()) {
            if (!taskAttribute.getId().startsWith("task.common.kind.flag")) continue;
            TaskAttribute state = taskAttribute.getAttribute("state");
            if (state.getMetaData().getLabel().equals("BugFlag1")) {
                this.flagA = taskAttribute;
                this.stateA = state;
                continue;
            }
            if (state.getMetaData().getLabel().equals("BugFlag2")) {
                this.flagB = taskAttribute;
                this.stateB = state;
                continue;
            }
            if (state.getMetaData().getLabel().equals("BugFlag3")) {
                if (this.flagC == null) {
                    this.flagC = taskAttribute;
                    this.stateC = state;
                    continue;
                }
                this.flagC2 = taskAttribute;
                this.stateC2 = state;
                continue;
            }
            if (!state.getMetaData().getLabel().equals("BugFlag4")) continue;
            this.flagD = taskAttribute;
            this.stateD = state;
        }
        BugzillaFlagsTest.assertNotNull((Object)this.flagA);
        BugzillaFlagsTest.assertNotNull((Object)this.flagB);
        BugzillaFlagsTest.assertNotNull((Object)this.flagC);
        BugzillaFlagsTest.assertNotNull((Object)this.flagD);
        BugzillaFlagsTest.assertNotNull((Object)this.stateA);
        BugzillaFlagsTest.assertNotNull((Object)this.stateB);
        BugzillaFlagsTest.assertNotNull((Object)this.stateC);
        BugzillaFlagsTest.assertNotNull((Object)this.stateD);
        TaskAttribute requesteeD = this.flagD.getAttribute("requestee");
        if (testSpace) {
            return this.flagC2 == null && this.stateC2 == null && " ".equals(this.stateA.getValue()) && " ".equals(this.stateB.getValue()) && " ".equals(this.stateC.getValue()) && " ".equals(this.stateD.getValue());
        }
        return this.flagC2 != null && this.stateC2 != null && "+".equals(this.stateA.getValue()) && "?".equals(this.stateB.getValue()) && "?".equals(this.stateC.getValue()) && " ".equals(this.stateC2.getValue()) && "?".equals(this.stateD.getValue()) && "guest@mylyn.eclipse.org".equals(requesteeD.getValue());
    }
}

