/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.util;

import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.mylyn.wikitext.core.util.DefaultXmlStreamWriter;
import org.eclipse.mylyn.wikitext.core.util.FormattingXMLStreamWriter;
import org.eclipse.mylyn.wikitext.core.util.XmlStreamWriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FormattingXmlStreamWriterTest {
    private StringWriter out;
    private FormattingXMLStreamWriter writer;

    @Before
    public void setUp() {
        this.out = new StringWriter();
        this.writer = new FormattingXMLStreamWriter((XmlStreamWriter)new DefaultXmlStreamWriter((Writer)this.out));
    }

    @Test
    public void testXmlDecl() {
        this.writer.writeStartDocument();
        this.writer.writeEndDocument();
        Assert.assertEquals((Object)"<?xml version='1.0' ?>", (Object)this.out.toString());
    }

    @Test
    public void testComment() {
        this.writer.writeStartDocument("utf-8", "1.0");
        this.writer.writeComment("test one two");
        this.writer.writeEndDocument();
        Assert.assertEquals((Object)"<?xml version='1.0' encoding='utf-8' ?>\n<!-- test one two -->", (Object)this.out.toString());
    }

    @Test
    public void testElementWithComment() {
        this.writer.writeStartDocument("utf-8", "1.0");
        this.writer.writeStartElement("root");
        this.writer.writeComment("test one two");
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        Assert.assertEquals((Object)"<?xml version='1.0' encoding='utf-8' ?>\n<root>\n\t<!-- test one two -->\n</root>", (Object)this.out.toString());
    }

    @Test
    public void testElementAttributeOrdering() {
        this.writer.writeStartDocument();
        this.writer.writeStartElement("test");
        this.writer.writeAttribute("a", "test");
        this.writer.writeAttribute("b", "test");
        this.writer.writeAttribute("c", "test");
        this.writer.writeAttribute("d", "test");
        this.writer.writeAttribute("ever", "test");
        this.writer.writeAttribute("x", "test");
        this.writer.writeAttribute("xa", "test");
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        Assert.assertEquals((Object)"<?xml version='1.0' ?>\n<test a=\"test\" b=\"test\" c=\"test\" d=\"test\" ever=\"test\" x=\"test\" xa=\"test\"></test>", (Object)this.out.toString());
    }
}

