/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client;

import com.google.gerrit.common.data.AccountDashboardInfo;
import com.google.gerrit.common.data.AccountService;
import com.google.gerrit.common.data.ChangeDetail;
import com.google.gerrit.common.data.ChangeInfo;
import com.google.gerrit.common.data.ChangeListService;
import com.google.gerrit.common.data.GerritConfig;
import com.google.gerrit.common.data.PatchScript;
import com.google.gerrit.common.data.PatchSetDetail;
import com.google.gerrit.common.data.ReviewerResult;
import com.google.gerrit.common.data.SingleListChangeInfo;
import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.AccountDiffPreference;
import com.google.gerrit.reviewdb.ApprovalCategoryValue;
import com.google.gerrit.reviewdb.Change;
import com.google.gerrit.reviewdb.ContributorAgreement;
import com.google.gerrit.reviewdb.Patch;
import com.google.gerrit.reviewdb.PatchLineComment;
import com.google.gerrit.reviewdb.PatchSet;
import com.google.gerrit.reviewdb.Project;
import com.google.gson.reflect.TypeToken;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwtjsonrpc.client.RemoteJsonService;
import com.google.gwtjsonrpc.client.VoidResult;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.gerrit.core.GerritCorePlugin;
import org.eclipse.mylyn.internal.gerrit.core.GerritUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritAuthenticationState;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritChange;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritConfiguration;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritHtmlProcessor;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritHttpClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritService;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritSystemInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.JSonSupport;
import org.eclipse.mylyn.internal.gerrit.core.client.PatchSetContent;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ChangeDetailService;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ChangeDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ChangeManageService;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.GerritConfigX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.PatchDetailService;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.PatchSetPublishDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ProjectAdminService;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ProjectDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.data.GerritQueryResult;
import org.eclipse.mylyn.internal.gerrit.core.remote.GerritRemoteFactoryProvider;
import org.eclipse.mylyn.reviews.core.model.IRepository;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.spi.ReviewsClient;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.AbstractRemoteEmfFactoryProvider;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.osgi.util.NLS;

public class GerritClient
extends ReviewsClient {
    private final GerritHttpClient client;
    private volatile GerritConfiguration config;
    private Account myAcount;
    private AccountDiffPreference myDiffPreference;
    private final Map<Class<? extends RemoteJsonService>, RemoteJsonService> serviceByClass;
    private volatile boolean configRefreshed;
    private boolean restQueryAPIEnabled;

    public boolean isAuthenticationException(Throwable exception) {
        if (exception instanceof GerritException) {
            return ((GerritException)exception).getCode() == -32603 && "Invalid xsrfKey in request".equals(((GerritException)exception).getMessage());
        }
        return false;
    }

    public boolean isNotSignedInException(Throwable exception) {
        if (exception instanceof GerritException) {
            return ((GerritException)exception).getCode() == -32603 && "not signed in".equalsIgnoreCase(((GerritException)exception).getMessage());
        }
        return false;
    }

    public static GerritAuthenticationState authStateFromString(String token) {
        try {
            JSonSupport support = new JSonSupport();
            return (GerritAuthenticationState)support.getGson().fromJson(token, GerritAuthenticationState.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String authStateToString(GerritAuthenticationState authState) {
        if (authState == null) {
            return null;
        }
        try {
            JSonSupport support = new JSonSupport();
            return support.getGson().toJson((Object)authState);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public GerritClient(TaskRepository repository, AbstractWebLocation location) {
        this(repository, location, null, null, null);
    }

    public GerritClient(TaskRepository repository, AbstractWebLocation location, GerritConfiguration config, GerritAuthenticationState authState) {
        this(repository, location, config, authState, null);
    }

    public GerritClient(TaskRepository repository, AbstractWebLocation location, GerritConfiguration config, GerritAuthenticationState authState, String xsrfKey) {
        super(repository);
        this.client = new GerritHttpClient(location){

            @Override
            protected void sessionChanged(Cookie cookie) {
                GerritAuthenticationState authState = new GerritAuthenticationState();
                authState.setCookie(cookie);
                GerritClient.this.authStateChanged(authState);
            }
        };
        if (authState != null) {
            this.client.setXsrfCookie(authState.getCookie());
        }
        if (xsrfKey != null) {
            this.client.setXsrfKey(xsrfKey);
        }
        this.serviceByClass = new HashMap<Class<? extends RemoteJsonService>, RemoteJsonService>();
        this.config = config;
    }

    public PatchLineComment saveDraft(Patch.Key patchKey, String message, int line, short side, String parentUuid, IProgressMonitor monitor) throws GerritException {
        PatchLineComment.Key id = new PatchLineComment.Key(patchKey, null);
        final PatchLineComment comment = new PatchLineComment(id, line, this.getAccount(monitor).getId(), parentUuid);
        comment.setMessage(message);
        comment.setSide(side);
        return this.execute(monitor, new Operation<PatchLineComment>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getPatchDetailService().saveDraft(comment, this);
            }
        });
    }

    public ChangeDetail abandon(String reviewId, int patchSetId, final String message, IProgressMonitor monitor) throws GerritException {
        final PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        return this.execute(monitor, new Operation<ChangeDetail>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getChangeManageService().abandonChange(id, message, this);
            }
        });
    }

    public ChangeDetailX getChangeDetail(int reviewId, IProgressMonitor monitor) throws GerritException {
        final Change.Id id = new Change.Id(reviewId);
        return this.execute(monitor, new Operation<ChangeDetailX>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getChangeDetailService().changeDetailX(id, this);
            }
        });
    }

    public void loadPatchSetContent(PatchSetContent patchSetContent, IProgressMonitor monitor) {
        try {
            PatchSet.Id baseId = patchSetContent.getBase() != null ? patchSetContent.getBase().getId() : null;
            PatchSet.Id targetId = patchSetContent.getTarget().getId();
            if (patchSetContent.getTargetDetail() == null) {
                PatchSetDetail targetDetail = this.getPatchSetDetail(baseId, targetId, monitor);
                patchSetContent.setTargetDetail(targetDetail);
            }
            for (Patch patch : patchSetContent.getTargetDetail().getPatches()) {
                PatchScript patchScript = this.getPatchScript(patch.getKey(), baseId, targetId, monitor);
                if (patchScript == null) continue;
                patchSetContent.putPatchScriptByPatchKey(patch.getKey(), patchScript);
            }
        }
        catch (GerritException e) {
            this.handleMissingPatchSet("Patch Set " + patchSetContent.getId(), e);
        }
    }

    public GerritConfigX getGerritConfig() {
        return this.config == null ? null : this.config.getGerritConfig();
    }

    public GerritConfiguration getConfiguration() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountDiffPreference getDiffPreference(IProgressMonitor monitor) throws GerritException {
        GerritClient gerritClient = this;
        synchronized (gerritClient) {
            if (this.myDiffPreference != null) {
                return this.myDiffPreference;
            }
        }
        AccountDiffPreference diffPreference = this.execute(monitor, new Operation<AccountDiffPreference>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getAccountService().myDiffPreferences((AsyncCallback)this);
            }
        });
        GerritClient gerritClient2 = this;
        synchronized (gerritClient2) {
            this.myDiffPreference = diffPreference;
        }
        return this.myDiffPreference;
    }

    public GerritSystemInfo getInfo(IProgressMonitor monitor) throws GerritException {
        List<ContributorAgreement> contributorAgreements = null;
        Account account = null;
        if (!this.isAnonymous()) {
            account = this.execute(monitor, new Operation<Account>(){

                @Override
                public void execute(IProgressMonitor monitor) throws GerritException {
                    GerritClient.this.getAccountService().myAccount((AsyncCallback)this);
                }
            });
        } else {
            this.executeQuery(monitor, "status:open");
        }
        this.refreshConfigOnce(monitor);
        return new GerritSystemInfo(contributorAgreements, account);
    }

    public PatchScript getPatchScript(final Patch.Key key, final PatchSet.Id leftId, final PatchSet.Id rightId, IProgressMonitor monitor) throws GerritException {
        final AccountDiffPreference diffPrefs = this.createAccountDiffPreference();
        return this.execute(monitor, new Operation<PatchScript>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getPatchDetailService().patchScript(key, leftId, rightId, diffPrefs, this);
            }
        });
    }

    private AccountDiffPreference createAccountDiffPreference() {
        AccountDiffPreference diffPrefs = new AccountDiffPreference(null);
        diffPrefs.setLineLength(Integer.MAX_VALUE);
        diffPrefs.setTabSize(4);
        diffPrefs.setContext((short)-1);
        diffPrefs.setIgnoreWhitespace(AccountDiffPreference.Whitespace.IGNORE_NONE);
        diffPrefs.setIntralineDifference(false);
        return diffPrefs;
    }

    public PatchSetDetail getPatchSetDetail(final PatchSet.Id idBase, final PatchSet.Id idTarget, IProgressMonitor monitor) throws GerritException {
        PatchSetDetail result;
        block6: {
            result = null;
            try {
                result = this.execute(monitor, new Operation<PatchSetDetail>(){

                    @Override
                    public void execute(IProgressMonitor monitor) throws GerritException {
                        GerritClient.this.getChangeDetailService().patchSetDetail2(idBase, idTarget, GerritClient.this.createAccountDiffPreference(), this);
                    }
                });
            }
            catch (GerritException e) {
                try {
                    if (!this.isNoSuchServiceError(e)) {
                        throw e;
                    }
                    result = this.execute(monitor, new Operation<PatchSetDetail>(){

                        @Override
                        public void execute(IProgressMonitor monitor) throws GerritException {
                            GerritClient.this.getChangeDetailService().patchSetDetail(idTarget, this);
                        }
                    });
                }
                catch (GerritException e2) {
                    String message = e2.getMessage();
                    if (message != null && message.contains("Error parsing request")) {
                        result = this.execute(monitor, new Operation<PatchSetDetail>(){

                            @Override
                            public void execute(IProgressMonitor monitor) throws GerritException {
                                GerritClient.this.getChangeDetailService().patchSetDetail(idBase, idTarget, GerritClient.this.createAccountDiffPreference(), this);
                            }
                        });
                        break block6;
                    }
                    throw e2;
                }
            }
        }
        return result;
    }

    boolean isNoSuchServiceError(GerritException e) {
        String message = e.getMessage();
        return message != null && message.contains("No such service method");
    }

    public PatchSetPublishDetailX getPatchSetPublishDetail(final PatchSet.Id id, IProgressMonitor monitor) throws GerritException {
        PatchSetPublishDetailX publishDetail = this.execute(monitor, new Operation<PatchSetPublishDetailX>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getChangeDetailService().patchSetPublishDetailX(id, this);
            }
        });
        return publishDetail;
    }

    public GerritChange getChange(String reviewId, IProgressMonitor monitor) throws GerritException {
        int id;
        GerritChange change = new GerritChange();
        try {
            id = this.id(reviewId);
        }
        catch (GerritException e) {
            List<GerritQueryResult> result = this.executeQuery(monitor, reviewId);
            if (result.size() == 1) {
                id = result.get(0).getNumber();
            }
            throw e;
        }
        ChangeDetailX changeDetail = this.getChangeDetail(id, monitor);
        ArrayList<PatchSetDetail> patchSets = new ArrayList<PatchSetDetail>(changeDetail.getPatchSets().size());
        HashMap<PatchSet.Id, PatchSetPublishDetailX> patchSetPublishDetailByPatchSetId = new HashMap<PatchSet.Id, PatchSetPublishDetailX>();
        for (PatchSet patchSet : changeDetail.getPatchSets()) {
            try {
                PatchSetDetail patchSetDetail = this.getPatchSetDetail(null, patchSet.getId(), monitor);
                patchSets.add(patchSetDetail);
                if (this.isAnonymous()) continue;
                PatchSetPublishDetailX patchSetPublishDetail = this.getPatchSetPublishDetail(patchSet.getId(), monitor);
                patchSetPublishDetailByPatchSetId.put(patchSet.getId(), patchSetPublishDetail);
            }
            catch (GerritException e) {
                this.handleMissingPatchSet("Patch Set " + patchSet.getPatchSetId() + " items for Review " + reviewId, e);
            }
        }
        change.setChangeDetail(changeDetail);
        change.setPatchSets(patchSets);
        change.setPatchSetPublishDetailByPatchSetId(patchSetPublishDetailByPatchSetId);
        return change;
    }

    private void handleMissingPatchSet(String desc, GerritException e) {
        GerritCorePlugin.logWarning("Couldn't load " + desc + ". (Perhaps the Patch Set has been removed from repository?)", e);
    }

    public int id(String id) throws GerritException {
        if (id == null) {
            throw new GerritException("Invalid ID (null)");
        }
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException numberFormatException) {
            throw new GerritException(NLS.bind((String)"Invalid ID (''{0}'')", (Object)id));
        }
    }

    public void publishComments(String reviewId, int patchSetId, final String message, final Set<ApprovalCategoryValue.Id> approvals, IProgressMonitor monitor) throws GerritException {
        final PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        this.execute(monitor, new Operation<VoidResult>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getPatchDetailService().publishComments(id, message, approvals, this);
            }
        });
    }

    public ReviewerResult addReviewers(String reviewId, final List<String> reviewers, IProgressMonitor monitor) throws GerritException {
        final Change.Id id = new Change.Id(this.id(reviewId));
        try {
            return this.execute(monitor, new Operation<ReviewerResult>(){

                @Override
                public void execute(IProgressMonitor monitor) throws GerritException {
                    GerritClient.this.getPatchDetailService().addReviewers(id, reviewers, this);
                }
            });
        }
        catch (GerritException e) {
            String message = e.getMessage();
            if (message != null && message.contains("Error parsing request")) {
                return this.execute(monitor, new Operation<ReviewerResult>(){

                    @Override
                    public void execute(IProgressMonitor monitor) throws GerritException {
                        GerritClient.this.getPatchDetailService().addReviewers(id, reviewers, false, this);
                    }
                });
            }
            throw e;
        }
    }

    public List<GerritQueryResult> queryAllReviews(IProgressMonitor monitor) throws GerritException {
        return this.executeQuery(monitor, "status:open");
    }

    public List<GerritQueryResult> queryByProject(IProgressMonitor monitor, String project) throws GerritException {
        return this.executeQuery(monitor, "status:open project:" + project);
    }

    public List<GerritQueryResult> queryMyReviews(IProgressMonitor monitor) throws GerritException {
        if (!this.restQueryAPIEnabled) {
            try {
                final Account account = this.getAccount(monitor);
                AccountDashboardInfo ad = this.execute(monitor, new Operation<AccountDashboardInfo>(){

                    @Override
                    public void execute(IProgressMonitor monitor) throws GerritException {
                        GerritClient.this.getChangeListService().forAccount(account.getId(), (AsyncCallback)this);
                    }
                });
                List allMyChanges = ad.getByOwner();
                allMyChanges.addAll(ad.getForReview());
                allMyChanges.addAll(ad.getClosed());
                return this.convert(allMyChanges);
            }
            catch (GerritException e) {
                if (this.isNoSuchServiceError(e)) {
                    this.restQueryAPIEnabled = true;
                }
                throw e;
            }
        }
        return this.executeQueryRest(monitor, "owner:self OR reviewer:self");
    }

    public List<GerritQueryResult> queryWatchedReviews(IProgressMonitor monitor) throws GerritException {
        return this.executeQuery(monitor, "is:watched status:open");
    }

    private GerritConfigX refreshGerritConfig(final IProgressMonitor monitor) throws GerritException {
        try {
            GerritConfigX gerritConfig = this.client.execute(new GerritHttpClient.Request<GerritConfigX>(){

                @Override
                public HttpMethodBase createMethod() throws IOException {
                    return new GetMethod(String.valueOf(GerritClient.this.client.getUrl()) + "/");
                }

                @Override
                public GerritConfigX process(HttpMethodBase method) throws IOException {
                    InputStream in = WebUtil.getResponseBodyAsStream((HttpMethodBase)method, (IProgressMonitor)monitor);
                    try {
                        GerritHtmlProcessor processor = new GerritHtmlProcessor();
                        processor.parse(in, method.getResponseCharSet());
                        GerritConfigX gerritConfigX = processor.getConfig();
                        return gerritConfigX;
                    }
                    finally {
                        in.close();
                    }
                }
            }, monitor);
            if (gerritConfig == null) {
                throw new GerritException("Failed to obtain Gerrit configuration");
            }
            return gerritConfig;
        }
        catch (UnknownHostException cause) {
            GerritException e = new GerritException("Unknown host: " + cause.getMessage());
            e.initCause(cause);
            throw e;
        }
        catch (IOException cause) {
            GerritException e = new GerritException(cause.getMessage());
            e.initCause(cause);
            throw e;
        }
    }

    public GerritConfiguration refreshConfig(IProgressMonitor monitor) throws GerritException {
        Account account;
        List<Project> projects;
        GerritConfigX gerritConfig;
        block2: {
            this.configRefreshed = true;
            gerritConfig = this.refreshGerritConfig(monitor);
            projects = this.getVisibleProjects(monitor, gerritConfig);
            account = null;
            try {
                account = this.getAccount(monitor);
            }
            catch (GerritException e) {
                if (this.isNotSignedInException(e)) break block2;
                throw e;
            }
        }
        this.config = new GerritConfiguration(gerritConfig, projects, account);
        this.configurationChanged(this.config);
        return this.config;
    }

    public GerritConfiguration refreshConfigOnce(IProgressMonitor monitor) throws GerritException {
        if (!this.configRefreshed && this.config == null) {
            try {
                this.refreshConfig(monitor);
            }
            catch (GerritException gerritException) {}
        }
        return this.getConfiguration();
    }

    public ChangeDetail publish(String reviewId, int patchSetId, IProgressMonitor monitor) throws GerritException {
        final PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        return this.execute(monitor, new Operation<ChangeDetail>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getChangeManageService().publish(id, this);
            }
        });
    }

    public ChangeDetail rebase(String reviewId, int patchSetId, IProgressMonitor monitor) throws GerritException {
        final PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        return this.execute(monitor, new Operation<ChangeDetail>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getChangeManageService().rebaseChange(id, this);
            }
        });
    }

    public ChangeDetail restore(String reviewId, int patchSetId, final String message, IProgressMonitor monitor) throws GerritException {
        final PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        return this.execute(monitor, new Operation<ChangeDetail>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getChangeManageService().restoreChange(id, message, this);
            }
        });
    }

    public ChangeDetail revert(String reviewId, int patchSetId, final String message, IProgressMonitor monitor) throws GerritException {
        final PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        return this.execute(monitor, new Operation<ChangeDetail>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getChangeManageService().revertChange(id, message, this);
            }
        });
    }

    public ChangeDetail submit(String reviewId, int patchSetId, String message, IProgressMonitor monitor) throws GerritException {
        final PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        return this.execute(monitor, new Operation<ChangeDetail>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getChangeManageService().submit(id, this);
            }
        });
    }

    public List<GerritQueryResult> executeQuery(IProgressMonitor monitor, final String queryString) throws GerritException {
        if (!this.restQueryAPIEnabled) {
            try {
                SingleListChangeInfo sl = this.execute(monitor, new Operation<SingleListChangeInfo>(){

                    @Override
                    public void execute(IProgressMonitor monitor) throws GerritException {
                        GerritClient.this.getChangeListService().allQueryNext(queryString, "z", -1, (AsyncCallback)this);
                    }
                });
                return this.convert(sl.getChanges());
            }
            catch (GerritException e) {
                if (this.isNoSuchServiceError(e)) {
                    this.restQueryAPIEnabled = true;
                }
                throw e;
            }
        }
        return this.executeQueryRest(monitor, queryString);
    }

    private List<GerritQueryResult> convert(List<ChangeInfo> changes) {
        ArrayList<GerritQueryResult> results = new ArrayList<GerritQueryResult>(changes.size());
        for (ChangeInfo changeInfo : changes) {
            GerritQueryResult result = new GerritQueryResult(changeInfo);
            results.add(result);
        }
        return results;
    }

    public List<GerritQueryResult> executeQueryRest(IProgressMonitor monitor, final String queryString) throws GerritException {
        return this.execute(monitor, new Operation<List<GerritQueryResult>>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                try {
                    GerritHttpClient.Request<List<GerritQueryResult>> request = new GerritHttpClient.Request<List<GerritQueryResult>>(){

                        @Override
                        public HttpMethodBase createMethod() throws IOException {
                            GetMethod method = new GetMethod(String.valueOf(GerritClient.this.client.getUrl()) + "/changes/?format=JSON&q=" + URLEncoder.encode(queryString, "UTF-8"));
                            method.setRequestHeader("Accept", "application/json");
                            return method;
                        }

                        @Override
                        public List<GerritQueryResult> process(HttpMethodBase method) throws IOException {
                            JSonSupport json = new JSonSupport();
                            String content = method.getResponseBodyAsString();
                            if (content.startsWith(")]}'\n")) {
                                content = content.substring(5);
                            }
                            Type type = new TypeToken<List<GerritQueryResult>>(){}.getType();
                            return (List)json.getGson().fromJson(content, type);
                        }
                    };
                    List<GerritQueryResult> result = GerritClient.this.client.execute(request, monitor);
                    this.onSuccess(result);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Account getAccount(IProgressMonitor monitor) throws GerritException {
        GerritClient gerritClient = this;
        synchronized (gerritClient) {
            if (this.myAcount != null) {
                return this.myAcount;
            }
        }
        Account account = this.execute(monitor, new Operation<Account>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getAccountService().myAccount((AsyncCallback)this);
            }
        });
        GerritClient gerritClient2 = this;
        synchronized (gerritClient2) {
            this.myAcount = account;
        }
        return this.myAcount;
    }

    private AccountService getAccountService() {
        return this.getService(AccountService.class);
    }

    private ChangeDetailService getChangeDetailService() {
        return this.getService(ChangeDetailService.class);
    }

    private ChangeListService getChangeListService() {
        return this.getService(ChangeListService.class);
    }

    private ChangeManageService getChangeManageService() {
        return this.getService(ChangeManageService.class);
    }

    private PatchDetailService getPatchDetailService() {
        return this.getService(PatchDetailService.class);
    }

    /*
     * Unable to fully structure code
     */
    private List<Project> getVisibleProjects(IProgressMonitor monitor, GerritConfig gerritConfig) throws GerritException {
        block4: {
            block5: {
                result = new ArrayList<Project>();
                try {
                    projectDetails = this.execute(monitor, new Operation<List<ProjectDetailX>>(){

                        @Override
                        public void execute(IProgressMonitor monitor) throws GerritException {
                            GerritClient.this.getProjectAdminService().visibleProjectDetails(this);
                        }
                    });
                    for (ProjectDetailX projectDetail : projectDetails) {
                        if (GerritUtil.isPermissionOnlyProject(projectDetail, gerritConfig)) continue;
                        result.add(projectDetail.project);
                    }
                    break block4;
                }
                catch (GerritException e) {
                    if (!this.isNoSuchServiceError(e)) break block5;
                    projects = this.execute(monitor, new Operation<List<Project>>(){

                        @Override
                        public void execute(IProgressMonitor monitor) throws GerritException {
                            GerritClient.this.getProjectAdminService().visibleProjects(this);
                        }
                    });
                    ** for (project : projects)
                }
lbl-1000:
                // 1 sources

                {
                    projectDetail = new ProjectDetailX();
                    projectDetail.setProject(project);
                    if (GerritUtil.isPermissionOnlyProject(projectDetail, gerritConfig)) continue;
                    result.add(project);
                    continue;
lbl20:
                    // 1 sources

                    break block4;
                }
            }
            throw e;
        }
        return result;
    }

    private ProjectAdminService getProjectAdminService() {
        return this.getService(ProjectAdminService.class);
    }

    public boolean isAnonymous() {
        return this.client.isAnonymous();
    }

    protected void configurationChanged(GerritConfiguration config) {
    }

    protected void authStateChanged(GerritAuthenticationState config) {
    }

    protected <T> T execute(IProgressMonitor monitor, Operation<T> operation) throws GerritException {
        try {
            T t;
            GerritService.GerritRequest.setCurrentRequest(new GerritService.GerritRequest(monitor));
            try {
                t = this.executeOnce(monitor, operation);
            }
            catch (GerritException e) {
                block7: {
                    if (!this.isAuthenticationException(e)) break block7;
                    operation.reset();
                    T t2 = this.executeOnce(monitor, operation);
                    GerritService.GerritRequest.setCurrentRequest(null);
                    return t2;
                }
                throw e;
            }
            return t;
        }
        finally {
            GerritService.GerritRequest.setCurrentRequest(null);
        }
    }

    private <T> T executeOnce(IProgressMonitor monitor, Operation<T> operation) throws GerritException {
        operation.execute(monitor);
        if (operation.getException() instanceof GerritException) {
            throw (GerritException)operation.getException();
        }
        if (operation.getException() instanceof OperationCanceledException) {
            throw (OperationCanceledException)operation.getException();
        }
        if (operation.getException() instanceof RuntimeException) {
            throw (RuntimeException)operation.getException();
        }
        if (operation.getException() != null) {
            GerritException e = new GerritException();
            e.initCause(operation.getException());
            throw e;
        }
        return operation.getResult();
    }

    protected synchronized <T extends RemoteJsonService> T getService(Class<T> clazz) {
        Object service = this.serviceByClass.get(clazz);
        if (service == null) {
            service = GerritService.create(clazz, this.client);
            this.serviceByClass.put((Class<? extends RemoteJsonService>)clazz, (RemoteJsonService)service);
        }
        return (T)((RemoteJsonService)clazz.cast(service));
    }

    public AbstractRemoteEmfFactoryProvider<IRepository, IReview> createFactoryProvider() {
        return new GerritRemoteFactoryProvider(this);
    }

    private abstract class Operation<T>
    implements AsyncCallback<T> {
        private Throwable exception;
        private T result;

        private Operation() {
        }

        public abstract void execute(IProgressMonitor var1) throws GerritException;

        public Throwable getException() {
            return this.exception;
        }

        public T getResult() {
            return this.result;
        }

        public void onFailure(Throwable exception) {
            if (GerritClient.this.isAuthenticationException(exception)) {
                GerritClient.this.client.setXsrfCookie(null);
            }
            this.exception = exception;
        }

        public void onSuccess(T result) {
            this.setResult(result);
        }

        protected void setResult(T result) {
            this.result = result;
        }

        public void reset() {
            this.result = null;
            this.exception = null;
        }
    }
}

